package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcDrwgrpInfoController;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 卷册信息
 *
 * @author generator
 */
@Service("dcDrwgrpInfoService")
public class DcDrwgrpInfoServiceImpl extends BaseServiceImpl<DcDrwgrpInfoMapper, DcDrwgrpInfoEntity> implements IDcDrwgrpInfoService {

    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private DcDrwgrpInfoController dcDrwgrpInfoController;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    IAttachmentService iAttachmentService;


    /**
     * 升版
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean upgrade(List<DcDrwgrpInfoEntity> entities) {
        //获取卷册数据   如果有签发信息  则生成回收单
        entities.stream().forEach(f -> {
            Long oldId = f.getId();

            //查询旧的图册信息
            DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.baseMapper.selectById(oldId);

            //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
            List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                    .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                    .eq(DcDrawdistributeRecordEntity::getDr, 0));
            if (dcDrawdistributeRecordEntityList.size() > 0) {
                // 图纸回收-回收信息
                List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = new ArrayList<>();
                for (DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity : dcDrawdistributeRecordEntityList) {
                    if (RecycleEnum.N.getCode().equals(dcDrawdistributeRecordEntity.getRecycleSts())) {
                        DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = BeanMapper.map(dcDrawdistributeRecordEntity, DcDrawrecycleDrwgrpinfoEntity.class);
                        dcDrawrecycleDrwgrpinfoEntity.setId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setDrawdistributeDrwgrpinfoId(dcDrawdistributeRecordEntity.getId());
                        dcDrawrecycleDrwgrpinfoEntity.setTenantId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
                    }
                }
                // 图纸回收-图纸信息
                List<DcDrawrecycleDrawinfoEntity> dcDrawrecycleDrawinfoEntityList = new ArrayList<>();
                List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                        .eq(DcDrawInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode())
                        .eq(DcDrawInfoEntity::getDr, 0));
                for (DcDrawInfoEntity dcDrawInfoEntity : dcDrawInfoEntityList) {
                    DcDrawrecycleDrawinfoEntity dcDrawrecycleDrawinfoEntity = BeanMapper.map(dcDrawInfoEntity, DcDrawrecycleDrawinfoEntity.class);
                    dcDrawrecycleDrawinfoEntity.setId(null);
                    dcDrawrecycleDrawinfoEntity.setTenantId(null);
                    dcDrawrecycleDrawinfoEntity.setCreateDeptId(null);
                    dcDrawrecycleDrawinfoEntity.setCreateTime(null);
                    dcDrawrecycleDrawinfoEntity.setCreateUserCode(null);
                    dcDrawrecycleDrawinfoEntity.setUpdateTime(null);
                    dcDrawrecycleDrawinfoEntity.setUpdateUserCode(null);
                    dcDrawrecycleDrawinfoEntityList.add(dcDrawrecycleDrawinfoEntity);
                }
                DcDrawrecycleInfoEntity dcDrawrecycleInfoEntity = new DcDrawrecycleInfoEntity();
                dcDrawrecycleInfoEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                dcDrawrecycleInfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
                dcDrawrecycleInfoEntity.setDrwgrpName(dcDrwgrpInfoEntity.getDrwgrpName());
                dcDrawrecycleInfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                dcDrawrecycleInfoEntity.setDrwgrpType(dcDrwgrpInfoEntity.getDrwgrpType());
                dcDrawrecycleInfoEntity.setSourceUnitid(dcDrwgrpInfoEntity.getSourceUnitid());
                dcDrawrecycleInfoEntity.setSourceUnitname(dcDrwgrpInfoEntity.getSourceUnitname());
                dcDrawrecycleInfoEntity.setMgrp(dcDrwgrpInfoEntity.getMgrp());
                dcDrawrecycleInfoEntity.setSpecialty(dcDrwgrpInfoEntity.getSpecialty());
                dcDrawrecycleInfoEntity.setSys(dcDrwgrpInfoEntity.getSys());
                dcDrawrecycleInfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
                dcDrawrecycleInfoEntity.setIssueUserCode(dcDrwgrpInfoEntity.getIssueUserCode());
                dcDrawrecycleInfoEntity.setIssueUserName(dcDrwgrpInfoEntity.getIssueUserName());
                dcDrawrecycleInfoEntity.setIssueDate(dcDrwgrpInfoEntity.getIssueDate());
                dcDrawrecycleInfoEntity.setOrgCode(dcDrwgrpInfoEntity.getOrgCode());
                dcDrawrecycleInfoEntity.setOrgId(dcDrwgrpInfoEntity.getOrgId());
                dcDrawrecycleInfoEntity.setOrgName(dcDrwgrpInfoEntity.getOrgName());
                dcDrawrecycleInfoEntity.setParentOrgId(dcDrwgrpInfoEntity.getParentOrgId());
                dcDrawrecycleInfoEntity.setParentOrgCode(dcDrwgrpInfoEntity.getParentOrgCode());
                dcDrawrecycleInfoEntity.setParentOrgName(dcDrwgrpInfoEntity.getParentOrgName());
                dcDrawrecycleInfoEntity.setProjectCode(dcDrwgrpInfoEntity.getProjectCode());
                dcDrawrecycleInfoEntity.setProjectId(dcDrwgrpInfoEntity.getProjectId());
                dcDrawrecycleInfoEntity.setProjectName(dcDrwgrpInfoEntity.getProjectName());
                dcDrawrecycleInfoEntity.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
                dcDrawrecycleInfoEntity.setDcDrawrecycleDrawinfoList(dcDrawrecycleDrawinfoEntityList);
                dcDrawrecycleInfoEntity.setTenantId(null);
                dcDrawrecycleInfoEntity.setCreateDeptId(null);
                dcDrawrecycleInfoEntity.setCreateTime(null);
                dcDrawrecycleInfoEntity.setCreateUserCode(null);
                dcDrawrecycleInfoEntity.setUpdateTime(null);
                dcDrawrecycleInfoEntity.setUpdateUserCode(null);
                DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(dcDrawrecycleInfoEntity, DcDrawrecycleInfoVO.class);
                dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
                dcDrawrecycleDrwgrpinfoEntityList.forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                        .eq(DcDrawdistributeRecordEntity::getId, dcDrawrecycleDrwgrpinfoEntity.getDrawdistributeDrwgrpinfoId())
                        .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode())));
            }

            //新版数据添加
            f.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            f.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            f.setIssueSts("0");
            f.setIssueUserCode(null);
            f.setIssueUserName(null);
            f.setDrwgrpSts("N");
            f.setId(null);
            DcDrwgrpInfoVO vo = BeanMapper.map(f, DcDrwgrpInfoVO.class);
            vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());

            //校验同一个项目下卷册名称，卷册编号，卷册版本不能重复
            QueryWrapper<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityQueryWrapper = new QueryWrapper();
            dcDrwgrpInfoEntityQueryWrapper.lambda().eq(ToolUtil.isNotEmpty(f.getProjectId()), DcDrwgrpInfoEntity::getProjectId, f.getProjectId())
                    .eq(DcDrwgrpInfoEntity::getDr, 0)
                    .eq(DcDrwgrpInfoEntity::getDrwgrpCode, f.getDrwgrpCode())
                    .eq(DcDrwgrpInfoEntity::getDrwgrpName, f.getDrwgrpName())
                    .eq(DcDrwgrpInfoEntity::getDrwgrpVsn, f.getDrwgrpVsn());
            List<DcDrwgrpInfoEntity> list = baseMapper.selectList(dcDrwgrpInfoEntityQueryWrapper);
            if (list.size() > 0) {
                throw new BusinessException("该卷册已添加");
            }
            vo.getDcDrawInfoEntityList().forEach(dcDrawInfoVO -> dcDrawInfoVO.setId(null));
            CommonResponse<DcDrwgrpInfoVO> response = dcDrwgrpInfoController.saveOrUpdate(vo);
            if (response.isSuccess()) {
                List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrwgrpId, oldId));
                Map<String, Long> collect = dcDrawInfoEntityList.stream().collect(Collectors.toMap(dcDrawInfoEntity -> dcDrawInfoEntity.getDrawCode() + "_" + dcDrawInfoEntity.getDrawVsn(), DcDrawInfoEntity::getId));
                response.getData().getDcDrawInfoEntityList().forEach(dcDrawInfoVO -> {
                    Long billId = collect.get(dcDrawInfoVO.getDrawCode() + "_" + dcDrawInfoVO.getDrawVsn());
                    if (billId != null) {
                        iAttachmentService.attachmentFile(
                                billId,
                                "BT230602000000005",
                                dcDrawInfoVO.getId(),
                                "BT230602000000005");
                    }
                });
            }
            //更新旧版本
            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, oldId)
                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, DrwgrpStsEnum.S);
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新旧版数据失败!");
            }
        });
        return true;
    }

    /**
     * 图纸回收
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean annul(List<DcDrwgrpInfoEntity> entities) {
        //图纸库生成回收单
        entities.stream().forEach(f -> {
            List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                    .eq(DcDrawdistributeRecordEntity::getDrwgrpId, f.getId())
                    .eq(DcDrawdistributeRecordEntity::getDr, 0));
            if (dcDrawdistributeRecordEntityList.size() > 0) {
                // 图纸回收-回收信息
                List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = new ArrayList<>();
                for (DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity : dcDrawdistributeRecordEntityList) {
                    if ("N".equals(dcDrawdistributeRecordEntity.getRecycleSts())) {
                        DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = BeanMapper.map(dcDrawdistributeRecordEntity, DcDrawrecycleDrwgrpinfoEntity.class);
                        dcDrawrecycleDrwgrpinfoEntity.setId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setDrawdistributeDrwgrpinfoId(dcDrawdistributeRecordEntity.getId());
                        dcDrawrecycleDrwgrpinfoEntity.setTenantId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
                    }
                }
                // 图纸回收-图纸信息
                List<DcDrawrecycleDrawinfoEntity> dcDrawrecycleDrawinfoEntityList = new ArrayList<>();
                List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrwgrpId, f.getId())
                        .eq(DcDrawInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode())
                        .eq(DcDrawInfoEntity::getDr, 0));
                for (DcDrawInfoEntity dcDrawInfoEntity : dcDrawInfoEntityList) {
                    DcDrawrecycleDrawinfoEntity dcDrawrecycleDrawinfoEntity = BeanMapper.map(dcDrawInfoEntity, DcDrawrecycleDrawinfoEntity.class);
                    dcDrawrecycleDrawinfoEntity.setId(null);
                    dcDrawrecycleDrawinfoEntity.setTenantId(null);
                    dcDrawrecycleDrawinfoEntity.setCreateDeptId(null);
                    dcDrawrecycleDrawinfoEntity.setCreateTime(null);
                    dcDrawrecycleDrawinfoEntity.setCreateUserCode(null);
                    dcDrawrecycleDrawinfoEntity.setUpdateTime(null);
                    dcDrawrecycleDrawinfoEntity.setUpdateUserCode(null);
                    dcDrawrecycleDrawinfoEntityList.add(dcDrawrecycleDrawinfoEntity);
                }
                DcDrawrecycleInfoEntity dcDrawrecycleInfoEntity = new DcDrawrecycleInfoEntity();
                dcDrawrecycleInfoEntity.setOrgCode(f.getOrgCode());
                dcDrawrecycleInfoEntity.setOrgId(f.getOrgId());
                dcDrawrecycleInfoEntity.setOrgName(f.getOrgName());
                dcDrawrecycleInfoEntity.setParentOrgId(f.getParentOrgId());
                dcDrawrecycleInfoEntity.setParentOrgCode(f.getProjectCode());
                dcDrawrecycleInfoEntity.setParentOrgName(f.getParentOrgName());
                dcDrawrecycleInfoEntity.setProjectCode(f.getProjectCode());
                dcDrawrecycleInfoEntity.setProjectId(f.getProjectId());
                dcDrawrecycleInfoEntity.setProjectName(f.getProjectName());
                dcDrawrecycleInfoEntity.setDrwgrpCode(f.getDrwgrpCode());
                dcDrawrecycleInfoEntity.setDrwgrpName(f.getDrwgrpName());
                dcDrawrecycleInfoEntity.setDrwgrpVsn(f.getDrwgrpVsn());
                dcDrawrecycleInfoEntity.setDrwgrpType(f.getDrwgrpType());
                dcDrawrecycleInfoEntity.setSourceUnitid(f.getSourceUnitid());
                dcDrawrecycleInfoEntity.setSourceUnitname(f.getSourceUnitname());
                dcDrawrecycleInfoEntity.setMgrp(f.getMgrp());
                dcDrawrecycleInfoEntity.setSpecialty(f.getSpecialty());
                dcDrawrecycleInfoEntity.setSys(f.getSys());
                dcDrawrecycleInfoEntity.setDrawArriveDate(f.getDrawArriveDate());
                dcDrawrecycleInfoEntity.setIssueUserCode(f.getIssueUserCode());
                dcDrawrecycleInfoEntity.setIssueUserName(f.getIssueUserName());
                dcDrawrecycleInfoEntity.setIssueDate(f.getIssueDate());
                dcDrawrecycleInfoEntity.setRecycleSts(RecycleEnum.N.getCode());
                dcDrawrecycleInfoEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                dcDrawrecycleInfoEntity.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
                dcDrawrecycleInfoEntity.setDcDrawrecycleDrawinfoList(dcDrawrecycleDrawinfoEntityList);
                dcDrawrecycleInfoEntity.setTenantId(null);
                dcDrawrecycleInfoEntity.setCreateDeptId(null);
                dcDrawrecycleInfoEntity.setCreateTime(null);
                dcDrawrecycleInfoEntity.setCreateUserCode(null);
                dcDrawrecycleInfoEntity.setUpdateTime(null);
                dcDrawrecycleInfoEntity.setUpdateUserCode(null);
                DcDrawrecycleInfoVO vo = BeanMapper.map(dcDrawrecycleInfoEntity, DcDrawrecycleInfoVO.class);
                dcDrawrecycleInfoController.saveOrUpdate(vo);
                dcDrawrecycleDrwgrpinfoEntityList.forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                        .eq(DcDrawdistributeRecordEntity::getId, dcDrawrecycleDrwgrpinfoEntity.getDrawdistributeDrwgrpinfoId())
                        .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode())));
            }
            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, f.getId())
                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, DrwgrpStsEnum.S);
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新数据失败!");
            }
        });
        return true;
    }

    @Override
    public List<DcDrwgrpInfoEntity> checkExist(List<DcDrwgrpInfoEntity> entities) {

//            "excel数据与数据库对比存在重复的行"
            return baseMapper.checkDcDrwgrpInfoEntityList(entities);


    }
}
