/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.business.dc.vo.DcFiledistributeCenterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcFiledistributeCenter"})
public class DcFiledistributeCenterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";
    @Autowired
    private IDcFiledistributeCenterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> saveOrUpdate(@RequestBody DcFiledistributeCenterVO saveOrUpdateVO) {
        DcFiledistributeCenterEntity entity = (DcFiledistributeCenterEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcFiledistributeCenterEntity.class));
        if (entity.getSubmitType() == 1474197986685751304L && ValidateUtil.isEmpty(entity.getBillState())) {
            entity.setBillState(0);
        }
        entity.setAsBillState("N");
        this.service.saveOrUpdate((Object)entity, false);
        DcFiledistributeCenterVO vo = (DcFiledistributeCenterVO)((Object)BeanMapper.map((Object)((Object)entity), DcFiledistributeCenterVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/fillIssue"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> fillIssue(@RequestBody DcFiledistributeCenterVO saveOrUpdateVO) {
        saveOrUpdateVO.getDcFileissueRecordList().stream().forEach(e -> {
            e.setFileCode(saveOrUpdateVO.getFileCode());
            e.setFileName(saveOrUpdateVO.getFileName());
            e.setFileVsn(saveOrUpdateVO.getFileVsn());
            if (ValidateUtil.isEmpty(saveOrUpdateVO.getFileInternalCode())) {
                e.setFileInternalCode("N/A");
            }
        });
        DcFiledistributeCenterEntity entity = (DcFiledistributeCenterEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcFiledistributeCenterEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        DcFiledistributeCenterVO vo = (DcFiledistributeCenterVO)((Object)BeanMapper.map((Object)((Object)entity), DcFiledistributeCenterVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> cancel(@RequestBody DcFiledistributeCenterVO voEntity) {
        DcFiledistributeCenterEntity entity = (DcFiledistributeCenterEntity)((Object)BeanMapper.map((Object)((Object)voEntity), DcFiledistributeCenterEntity.class));
        this.service.cancel(entity);
        return CommonResponse.success((String)"\u4f5c\u5e9f\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> queryDetail(Long id) {
        DcFiledistributeCenterEntity entity = (DcFiledistributeCenterEntity)((Object)this.service.selectById(id));
        DcFiledistributeCenterVO vo = (DcFiledistributeCenterVO)((Object)BeanMapper.map((Object)((Object)entity), DcFiledistributeCenterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcFiledistributeCenterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcFiledistributeCenterVO dcFiledistributeCenterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcFiledistributeCenterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcFiledistributeCenterVO.class));
        pageData.getRecords().stream().forEach(e -> e.setFileStsCn(DrwgrpStsEnum.getEnumByCode(e.getFileSts()).getName()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, DcFiledistributeCenterVO.class);
            voList.forEach(vo -> vo.setFileStsCn(DrwgrpStsEnum.getEnumByCode(vo.getFileSts()).getName()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcFiledistributeCenter-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcFiledistributeCenterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcFiledistributeCenterVO>> refDcFiledistributeCenterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            param.getParams().put("fileSts", new Parameter("eq", (Object)_con.getString("fileSts")));
            param.getParams().put("attribute", new Parameter("eq", (Object)_con.getString("attribute")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcFiledistributeCenterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectAttributeByPid"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List<Map>>> selectAttributeByPid(@RequestParam String pid) {
        List<Map> categoryNameList = this.service.selectAttributeByPid(pid);
        if (ValidateUtil.isEmpty(categoryNameList)) {
            new BusinessException("\u6ca1\u6709\u6587\u4ef6\u5c5e\u6027\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        data.put("data", categoryNameList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", data);
    }

    @RequestMapping(value={"/selectTemplateByCategoryId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List<Map>>> selectTemplateByCategoryId(@RequestParam String id) {
        List<Map> templateList = this.service.selectTemplateByCategoryId(id);
        if (ValidateUtil.isEmpty(templateList)) {
            new BusinessException("\u6ca1\u6709\u6587\u4ef6\u5c5e\u6027\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        data.put("data", templateList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", data);
    }

    @RequestMapping(value={"/deleteCache"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> deleteCache(@RequestBody Map<String, Object> params) {
        String referCode = (String)params.get("referCode");
        String key = (String)params.get("key");
        RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
        String cacheKey = referCode + ":" + key;
        redisTemplate.delete((Object)cacheKey);
        return CommonResponse.success((String)"\u6e05\u7406\u7f13\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/selectAttribute"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List> selectAttribute() {
        List<Map> maps = this.service.selectAttribute();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", maps);
    }
}

