/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.mapper.DcSendFileMapper;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dcSendFileService")
public class DcSendFileServiceImpl
extends BaseServiceImpl<DcSendFileMapper, DcSendFileEntity>
implements IDcSendFileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";
    @Autowired
    private IDcSendFileService service;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public boolean upgradeFileSts(DcSendFileEntity entity) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DcSendFileEntity::getFileCode, (Object)entity.getFileCode())).eq(DcSendFileEntity::getProjectId, (Object)entity.getProjectId())).set(DcSendFileEntity::getFileSts, (Object)"N"));
    }

    @Override
    public CommonResponse<DcSendFileVO> saveOrUpdate(DcSendFileVO saveOrUpdateVO) {
        DcSendFileEntity entity = (DcSendFileEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcSendFileEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setId(IdWorker.getId());
        }
        BillCodeApiVO apiVO = new BillCodeApiVO();
        apiVO.setProjectId(entity.getProjectId());
        apiVO.setProjectCode(entity.getProjectCode());
        apiVO.setProjectName(entity.getProjectName());
        apiVO.setCategoryId(entity.getFiletype());
        ArrayList<BillCodeRuleSNVO> snVoList = new ArrayList<BillCodeRuleSNVO>();
        BillCodeRuleSNVO outSnVO = new BillCodeRuleSNVO();
        outSnVO.setRuleType(RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode());
        outSnVO.setSourcePid(entity.getId());
        outSnVO.setSourceCode(entity.getBillCode());
        outSnVO.setSourceType("BT230411000000004");
        outSnVO.setSourceTypeName("\u53d1\u6587\u7ba1\u7406");
        try {
            if (entity.getSpecialty() != null) {
                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSpecialty() + ""), (String)"data-dictionary");
                JSONObject specialtyRef = (JSONObject)specialtyReferValue.get(0);
                outSnVO.setRule05(specialtyRef.getString("code"));
            }
            if (entity.getMgrp() != null) {
                JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMgrp() + ""), (String)"data-dictionary");
                JSONObject mgrpSpecialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule07(mgrpSpecialtyRef.getString("code"));
            }
            snVoList.add(outSnVO);
            BillCodeRuleSNVO innerSnVO = new BillCodeRuleSNVO();
            BeanUtils.copyProperties((Object)outSnVO, (Object)innerSnVO);
            outSnVO.setRuleType(RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode());
            snVoList.add(innerSnVO);
        }
        catch (Exception e) {
            throw new BusinessException("referCode:data-dictionary id\uff1a" + entity.getSpecialty() + "\u8f6c\u6362\u51fa\u9519");
        }
        apiVO.setSnList(snVoList);
        CommonResponse snCommonResponse = this.billCodeRuleApi.generateBillCode(apiVO);
        if (!snCommonResponse.isSuccess()) {
            return CommonResponse.error((String)snCommonResponse.getMsg());
        }
        List snList = ((BillCodeApiVO)snCommonResponse.getData()).getSnList();
        for (BillCodeRuleSNVO codeSnVO : snList) {
            if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) {
                entity.setFileCode(codeSnVO.getGenerateBillCode());
                continue;
            }
            if (!RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) continue;
            entity.setFileInternalCode(codeSnVO.getGenerateBillCode());
        }
        boolean b = this.service.saveOrUpdate((Object)entity, false);
        if (b) {
            BillCodeApiVO responseData = (BillCodeApiVO)snCommonResponse.getData();
            this.billCodeRuleApi.commitBillCode(responseData);
        }
        DcSendFileVO vo = (DcSendFileVO)((Object)BeanMapper.map((Object)((Object)entity), DcSendFileVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> delete(List<DcSendFileVO> vos) {
        HashMap sourceIds = new HashMap();
        ArrayList<Long> idList = new ArrayList<Long>();
        if (ListUtil.isNotEmpty(vos)) {
            for (DcSendFileVO vo : vos) {
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids", idList);
        CommonResponse commonResponse = this.billCodeRuleApi.releaseBillCode(sourceIds);
        if (commonResponse.isSuccess()) {
            this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }
}

