package com.ejianc.business.basem.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.basem.mapper.AttachmentMapper;
import com.ejianc.business.basem.bean.AttachmentEntity;
import com.ejianc.business.basem.service.IAttachmentService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 附件
 * 
 * @author generator
 * 
 */
@Service("attachmentService")
@Transactional
public class AttachmentServiceImpl extends BaseServiceImpl<AttachmentMapper, AttachmentEntity> implements IAttachmentService{

    @Autowired
    private AttachmentMapper attachmentMapper;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 推送 附件
     * @param sourceBizId   来源业务主键
     * @param sourceBillType 单据类型
     * @param targetBizId 目标业务主键
     * @param targetBillType 目标单据类型
     * @return
     */
    public void attachmentFile(Long sourceBizId,String sourceBillType,Long targetBizId,String targetBillType){
        QueryWrapper<AttachmentEntity> where = new QueryWrapper<AttachmentEntity>();
        where.lambda()
                .eq(AttachmentEntity::getSourceId,sourceBizId)
                .eq(AttachmentEntity::getBillType,sourceBillType);
        List<AttachmentEntity> attachmentEntities = attachmentMapper.selectList(where);
        synchronized (AttachmentServiceImpl.class){
            if (ToolUtil.isNotEmpty(attachmentEntities)){
                List<AttachmentEntity> newAttachmentEntities = new ArrayList<>();
                for (int i = 0; i < attachmentEntities.size(); i++) {
                    AttachmentEntity e =  attachmentEntities.get(i);
                    AttachmentEntity newTemp = BeanMapper.map(e, AttachmentEntity.class);
                    newTemp.setId(IdWorker.getId());
                    newTemp.setSourceId(targetBizId);
                    newTemp.setBillType(targetBillType);
                    newTemp.setCreateTime(new Date());
                    newTemp.setUpdateTime(new Date());
                    newTemp.setSourceType("otherAttachment");
                    newAttachmentEntities.add(newTemp);
                }
               saveBatch(newAttachmentEntities);

            }
        }
    }

    @Override
    public void attachmentFileWithFileType(String sourceFileType, Long sourceBizId, String sourceBillType, String targetFileType,Long targetBizId, String targetBillType) {
        logger.info("sourceFileType={},sourceBizId={},sourceBillType={},targetFileType={},targetBizId={},targetBillType={}",
                 sourceFileType,  sourceBizId,  sourceBillType,  targetFileType, targetBizId, targetBillType);
        QueryWrapper<AttachmentEntity> where = new QueryWrapper<AttachmentEntity>();
        where.lambda()
                .eq(AttachmentEntity::getSourceId,sourceBizId)
                .eq(AttachmentEntity::getSourceType,sourceFileType)
                .eq(AttachmentEntity::getBillType,sourceBillType);
        List<AttachmentEntity> attachmentEntities = attachmentMapper.selectList(where);
        synchronized (AttachmentServiceImpl.class){
            Long attachmentMax = attachmentMapper.getAttachmentMax();
            if (ToolUtil.isNotEmpty(attachmentEntities)){
                if (null == attachmentMax){
                    attachmentMax = 0L;
                }
                List<AttachmentEntity> newAttachmentEntities = new ArrayList<>();
                for (int i = 0; i < attachmentEntities.size(); i++) {
                    attachmentMax ++ ;
                    AttachmentEntity e =  attachmentEntities.get(i);
                    AttachmentEntity newTemp = BeanMapper.map(e, AttachmentEntity.class);
                    newTemp.setId(attachmentMax);
                    newTemp.setSourceId(targetBizId);
                    newTemp.setBillType(targetBillType);
                    newTemp.setCreateTime(new Date());
                    newTemp.setUpdateTime(new Date());
                    newTemp.setSourceType(targetFileType);
                    newAttachmentEntities.add(newTemp);
                }
//                newAttachmentEntities.stream().forEach(System.out::println);
                saveBatch(newAttachmentEntities);
                logger.info("SAVE={}", JSONObject.toJSON(newAttachmentEntities));
            }
        }
    }
}
