package com.ejianc.business.dc.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.dc.bean.DcLssueAddressBookDetailEntity;
/**
 * 签发通讯录
 * 
 * @author generator
 * 
 */
 @TableName("dc_lssue_address_book")
public class DcLssueAddressBookEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="address_book_name")
    private String addressBookName; // 签发通讯录名称
    @TableField(value="address_book_type")
    private String addressBookType; // 签发通讯录类型--字典lssue_address_book_type
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="dcLssueAddressBookDetailService", pidName = "addressBookId")
    private List<DcLssueAddressBookDetailEntity> dcLssueAddressBookDetailList = new ArrayList<>(); // 签发通讯录-明细
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getAddressBookName() {
        return addressBookName;
    }

    public void setAddressBookName(String addressBookName) {
        this.addressBookName = addressBookName;
    }
    public String getAddressBookType() {
        return addressBookType;
    }

    public void setAddressBookType(String addressBookType) {
        this.addressBookType = addressBookType;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<DcLssueAddressBookDetailEntity> getDcLssueAddressBookDetailList() {
        return dcLssueAddressBookDetailList;
    }

    public void setDcLssueAddressBookDetailList(List<DcLssueAddressBookDetailEntity> dcLssueAddressBookDetailList) {
        this.dcLssueAddressBookDetailList = dcLssueAddressBookDetailList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
