package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrawinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcDrawInfoMapper;
import com.ejianc.business.dc.mapper.DcDrawdistributeInfoMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrawinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 图纸分发
 *
 * @author generator
 */
@Service("dcDrawdistributeInfoService")
public class DcDrawdistributeInfoServiceImpl extends BaseServiceImpl<DcDrawdistributeInfoMapper, DcDrawdistributeInfoEntity> implements IDcDrawdistributeInfoService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;

    @Override
    public void printDataDispose(List<Long> drwgrpIds) {
        if(ToolUtil.isEmpty(drwgrpIds)){
            throw new RuntimeException("请至少勾选一条数据");
        }
        for (Long drwgrpId : drwgrpIds) {
            // 查询图纸签发，根据卷册ID
            DcDrawdistributeInfoEntity dcDrawdistributeInfo = getOne(
                    new QueryWrapper<DcDrawdistributeInfoEntity>().lambda()
                            .eq(DcDrawdistributeInfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawdistributeInfoEntity::getDr, "0")
            );
            /*
             * 设置分发单号
             */
            if(ToolUtil.isEmpty(dcDrawdistributeInfo.getDistCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(DcDrawdistributeInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(dcDrawdistributeInfo, DcDrawdistributeInfoVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    /*
                     * 图纸签发设置分发单号
                     */
                    // 更新图纸签发的分发单号，根据图纸签发ID
                    update(
                            new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                                    .eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfo.getId())
                                    .set(DcDrawdistributeInfoEntity::getDistCode, billCode.getData())
                    );
                } else {
                    throw new RuntimeException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            // 更新图纸库中的图纸信息为已打印
            dcDrawInfoService.update(
                    new UpdateWrapper<DcDrawInfoEntity>().lambda()
                            .set(DcDrawInfoEntity::getPrintStatus, PrintStatusEnum.NOT_PRINT.getCode())
                            .eq(DcDrawInfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawInfoEntity::getDr, "0")
            );
            // 更新图纸签发中的图纸信息为已打印
            dcDrawdistributeDrawinfoService.update(
                    new UpdateWrapper<DcDrawdistributeDrawinfoEntity>().lambda()
                            .set(DcDrawdistributeDrawinfoEntity::getPrintStatus, PrintStatusEnum.NOT_PRINT.getCode())
                            .eq(DcDrawdistributeDrawinfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawdistributeDrawinfoEntity::getDr, "0")
            );
        }
    }
}
