package com.ejianc.business.dc.enumUtils;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签发状态
 *
 * @author: swb
 * @date: 2023/05/11
 **/
public enum IssueStsEnum {
    ISSUE("0", "未签发"),
    NOT_ISSUE("1", "已签发");

    private final String code;
    private final String name;
    private static Map<String, IssueStsEnum> enumMap = new HashMap();

    private IssueStsEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static IssueStsEnum getEnumByCode(String code) {
        return (IssueStsEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(IssueStsEnum.class).stream().collect(Collectors.toMap(IssueStsEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
