package com.ejianc.business.dc.enumUtils;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 是否标识
 *
 * @author: swb
 * @date: 2023/05/11
 **/
public enum YesOrNoEnum {
    Y("Y", "是"),
    N("N", "否");

    private final String code;
    private final String name;
    private static Map<String, YesOrNoEnum> enumMap = new HashMap();

    private YesOrNoEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static YesOrNoEnum getEnumByCode(String code) {
        return (YesOrNoEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(YesOrNoEnum.class).stream().collect(Collectors.toMap(YesOrNoEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
