package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawdistributeRecordController;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcLssueAddressBookController;
import com.ejianc.business.dc.enumUtils.*;
import com.ejianc.business.dc.service.*;
import com.ejianc.business.dc.util.MessageUtil;
import com.ejianc.business.dc.vo.DcDrawdistributeRecordVO;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("dcDrawdistributeInfo")
public class DcDrawdistributeInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    ActRuTaskService actRuTaskService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private DcDrawdistributeRecordController dcDrawdistributeRecordController;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private DcLssueAddressBookController dcLssueAddressBookController;

    @Value("${common.env.base-host}")
    private String baseHost;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交完回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        // 修改流程状态为“待签发”
        dcDrawdistributeInfoService.update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.THREE.getCode())
                        .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.THREE.getName())
        );
        /*
         * 1.生成签发信息，根据项目和签发通讯录类型为“图纸签发”查询签发通讯录中的明细
         */
        // 1.1 查询图纸签发信息，根据主键ID
        DcDrawdistributeInfoEntity dcDrawdistributeInfo = dcDrawdistributeInfoService.getOne(
                new QueryWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
        );
        /*
         * 1.2 查询签发通讯录信息，根据图纸签发信息的项目ID和签发通讯录类型为“图纸签发”
         */
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", dcDrawdistributeInfo.getProjectId());
        jsonObject.put("addressBookType", AddressBookTypeEnum.ONE.getCode());
        CommonResponse<IPage<DcLssueAddressBookVO>> commonResponse = dcLssueAddressBookController.refDcLssueAddressBookData(1, 1, jsonObject.toString(), null, null);
        /*
         * 1.3 转换签发通讯录明细类型为图纸签发的签发信息类型
         */
        if (commonResponse.isSuccess() && ToolUtil.isNotEmpty(commonResponse.getData()) && ToolUtil.isNotEmpty(commonResponse.getData().getRecords())) {
            List<DcLssueAddressBookVO> dcLssueAddressBookList = commonResponse.getData().getRecords();
            List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList = dcLssueAddressBookList.get(0).getDcLssueAddressBookDetailList();
            List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoList = BeanMapper.mapList(dcLssueAddressBookDetailList, DcDrawdistributeDrwgrpinfoEntity.class);
            dcDrawdistributeInfo.setDcDrawdistributeDrwgrpinfoEntityList(dcDrawdistributeDrwgrpinfoList);
        }
        // 1.4 保存图纸签发的签发信息
        dcDrawdistributeInfoService.saveOrUpdate(dcDrawdistributeInfo);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        logger.info("有审批流的撤回后回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        // 修改流程状态为“待申请签发”
        dcDrawdistributeInfoService.update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("审批节点审批中时节点审批后回调-----------billId:{}, state:{}, billTypeCode:{}, taskId:{}, isEnd:{}, sign:{}, other:{}, nodeType:{}"
                , billId, state, billTypeCode, taskId, isEnd, sign, other, nodeType);
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_a".equals(nodeType)) {
                //更新图纸签发主表签发信息
                dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getIssueDate, new Date())
                        .set(DcDrawdistributeInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawdistributeInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
                //更新卷册签发信息
                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getIssueDate, new Date())
                        .set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
            }
            if ("3".equals(sign)) {
                // 修改流程状态为“待分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, billId)
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FOUR.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FOUR.getName())
                );
            } else if ("4".equals(sign)) {
                // 修改流程状态为“已分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, billId)
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("终审审核完回调-----------billId:{}, state:{}, billTypeCode:{}, nodeType:{}"
                , billId, state, billTypeCode, nodeType);
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_b".equals(nodeType)) {
                List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoService.list(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, billId)
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, 0));
                //签发流程结束后，数据添加到签发记录表（如果用户已持有该卷册，不增加数据。）
                //更新图纸签发主表分发信息
                dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getDistDate, new Date())
                        .set(DcDrawdistributeInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawdistributeInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName()));
                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode()));
                DcDrwgrpInfoEntity dcDrwgrpInfoEntity = dcDrwgrpInfoService.getById(entity.getDrwgrpId());
                //判断是否有签发信息,如果存在签发信息，判断总的签发份数是否大于库存数；如果不存在签发信息不允许签发
                if (dcDrawdistributeDrwgrpinfoEntityList.size() > 0) {
                    if (null != dcDrwgrpInfoEntity && dcDrwgrpInfoEntity.getSurplusNum() > 0) {
                        int i = dcDrawdistributeDrwgrpinfoEntityList.stream()
                                .filter(e -> YesOrNoEnum.Y.getCode().equals(e.getPaperFlag()) && e.getNum() != null)
                                .mapToInt(DcDrawdistributeDrwgrpinfoEntity::getNum).sum();
                        if (BigDecimal.valueOf(dcDrwgrpInfoEntity.getSurplusNum()).compareTo(BigDecimal.valueOf(i)) >= 0) {
                            dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                                    .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                                    .set(DcDrwgrpInfoEntity::getSurplusNum, dcDrwgrpInfoEntity.getSurplusNum() - i));
                        } else {
                            return CommonResponse.error("您签发的卷册号为【" + entity.getDrwgrpCode() + "】的总份数【" + i + "】大于该卷册库存量【" + dcDrwgrpInfoEntity.getSurplusNum() + "】!");
                        }
                    }
                } else {
                    return CommonResponse.error("没有添加签发信息不允许签发!");
                }
                dcDrawdistributeDrwgrpinfoEntityList.forEach(dcDrawdistributeDrwgrpinfoEntity -> {
                    DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity = dcDrawdistributeRecordService.getOne(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                            .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrawdistributeDrwgrpinfoEntity.getDrwgrpId())
                            .eq(DcDrawdistributeRecordEntity::getReceiveUserCode, dcDrawdistributeDrwgrpinfoEntity.getReceiveUserCode())
                            .eq(DcDrawdistributeRecordEntity::getDr, 0));
                    if (dcDrawdistributeRecordEntity == null) {
                        DcDrawdistributeRecordEntity drawdistributeRecordEntity = BeanMapper.map(dcDrawdistributeDrwgrpinfoEntity, DcDrawdistributeRecordEntity.class);
                        drawdistributeRecordEntity.setId(null);
                        drawdistributeRecordEntity.setIssueDate(entity.getIssueDate());
                        drawdistributeRecordEntity.setIssueUserCode(entity.getIssueUserCode());
                        drawdistributeRecordEntity.setIssueUserName(entity.getIssueUserName());
                        drawdistributeRecordEntity.setSourceUnitid(entity.getSourceUnitid());
                        drawdistributeRecordEntity.setSourceUnitname(entity.getSourceUnitname());
                        drawdistributeRecordEntity.setSys(entity.getSys());
                        drawdistributeRecordEntity.setDrawArriveDate(entity.getDrawArriveDate());
                        drawdistributeRecordEntity.setTenantId(null);
                        drawdistributeRecordEntity.setCreateTime(null);
                        drawdistributeRecordEntity.setCreateUserCode(null);
                        drawdistributeRecordEntity.setUpdateTime(null);
                        drawdistributeRecordEntity.setUpdateUserCode(null);
                        dcDrawdistributeRecordController.saveOrUpdate(BeanMapper.map(drawdistributeRecordEntity, DcDrawdistributeRecordVO.class));
                    }
                });
                // 修改流程状态为“已分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, billId)
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
                /*
                 * 对签发信息中的人员信息发送系统消息
                 */
                String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};
                String[] receivers = dcDrawdistributeDrwgrpinfoEntityList.stream().map(a -> a.getReceiveUserId().toString()).toArray(String[]::new);
                String msgType = "bpmcc";
                String subject = "【图纸签发----卷册编号：" + entity.getDrwgrpCode() + "，卷册名称：" + entity.getDrwgrpName() + "，卷册版本：" + entity.getDrwgrpVsn() + "】，已分发";
                String content = "【图纸签发----卷册编号：" + entity.getDrwgrpCode() + "，卷册名称：" + entity.getDrwgrpName() + "，卷册版本：" + entity.getDrwgrpVsn() + "】，已分发";
                String pcUrl = baseHost + "ejc-ztpcdc-frontend/#/dcDrawdistributeInfo/card?id=" + entity.getId();
                String tenantId = InvocationInfoProxy.getTenantid().toString();
                Long sendUserId = InvocationInfoProxy.getUserid();
                PushMsgParameter msgParameter = MessageUtil.getPushMsgParameter(channel, receivers, msgType, subject, content, pcUrl, tenantId, sendUserId);
                pushMessageApi.pushMessage(msgParameter);
            }
        }

        /*
         * modify by XXX start
         * 1.补充图纸签发-图纸信息没有的图纸信息
         * 2.图纸信息回收
         */
        /*
         * 获取图纸签发-图纸信息数据
         */
        List<DcDrawdistributeDrawinfoEntity> dcDrawdistributeDrawinfoList = dcDrawdistributeDrawinfoService.list(new QueryWrapper<DcDrawdistributeDrawinfoEntity>()
                .lambda()
                .eq(DcDrawdistributeDrawinfoEntity::getDr, "0")
                .eq(DcDrawdistributeDrawinfoEntity::getPid, billId));
        /*
         * 获取图纸库-图纸信息数据
         */
        List<DcDrawInfoEntity> dcDrawInfoList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                .lambda()
                .eq(DcDrawInfoEntity::getDr, "0")
                .eq(DcDrawInfoEntity::getDrwgrpId, entity.getDrwgrpId()));
        // 把图纸库-图纸信息对象类型转换为图纸签发-图纸信息对象类型
        List<DcDrawdistributeDrawinfoEntity> allDcDrawdistributeDrawinfoList = BeanMapper.mapList(dcDrawInfoList, DcDrawdistributeDrawinfoEntity.class);
        /*
         * 获取图纸库-图纸信息在图纸签发-图纸信息中没有的图纸信息
         */
        List<DcDrawdistributeDrawinfoEntity> newDcDrawdistributeDrawinfoList = allDcDrawdistributeDrawinfoList.stream().filter(
                a -> dcDrawdistributeDrawinfoList.stream().noneMatch(
                        b -> a.getDrawCode().equals(b.getDrawCode())
                )
        ).peek(a -> {
            a.setId(null);
            a.setPid(billId);
        }).collect(Collectors.toList());
        // 保存到图纸签发-图纸信息表中
        dcDrawdistributeDrawinfoService.saveBatch(newDcDrawdistributeDrawinfoList);

        /*
         * 图纸信息回收
         */
        // 获取新的图纸库信息
        DcDrwgrpInfoEntity newDcDrwgrpInfo = dcDrwgrpInfoService.getById(entity.getDrwgrpId());
        // 获取旧的图纸库信息
        DcDrwgrpInfoEntity oldDcDrwgrpInfo = dcDrwgrpInfoService.getOne(
                new QueryWrapper<DcDrwgrpInfoEntity>()
                        .lambda()
                        .eq(DcDrwgrpInfoEntity::getDrwgrpCode, entity.getDrwgrpCode())
                        .ne(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .orderByDesc(DcDrwgrpInfoEntity::getCreateTime).last("limit 1")
        );
        if (ToolUtil.isEmpty(oldDcDrwgrpInfo)) {
            return CommonResponse.success();
        }
        // 获取新的图纸库-图纸信息
        List<DcDrawInfoEntity> newDcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                .eq(DcDrawInfoEntity::getDrwgrpId, newDcDrwgrpInfo.getId())
                .eq(DcDrawInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode())
                .eq(DcDrawInfoEntity::getDr, 0));
        // 获取旧的图纸库-图纸信息
        List<DcDrawInfoEntity> oldDcDrawInfoList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                .lambda()
                .eq(DcDrawInfoEntity::getDr, "0")
                .eq(DcDrawInfoEntity::getDrwgrpId, oldDcDrwgrpInfo.getId()));

        //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
        List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                .eq(DcDrawdistributeRecordEntity::getDrwgrpId, oldDcDrwgrpInfo.getId())
                .eq(DcDrawdistributeRecordEntity::getDr, 0)
                .eq(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.N.getCode()));

        if (dcDrawdistributeRecordEntityList.size() > 0) {
            // 图纸回收-回收信息
            List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = new ArrayList<>();
            for (DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity : dcDrawdistributeRecordEntityList) {
                if (RecycleEnum.N.getCode().equals(dcDrawdistributeRecordEntity.getRecycleSts())) {
                    DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = BeanMapper.map(dcDrawdistributeRecordEntity, DcDrawrecycleDrwgrpinfoEntity.class);
                    dcDrawrecycleDrwgrpinfoEntity.setId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setDrawdistributeDrwgrpinfoId(dcDrawdistributeRecordEntity.getId());
                    dcDrawrecycleDrwgrpinfoEntity.setTenantId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateTime(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateUserCode(null);
                    dcDrawrecycleDrwgrpinfoEntity.setUpdateTime(null);
                    dcDrawrecycleDrwgrpinfoEntity.setUpdateUserCode(null);
                    dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
                }
            }
            // 图纸回收-图纸信息
            List<DcDrawrecycleDrawinfoEntity> dcDrawrecycleDrawinfoEntityList = new ArrayList<>();
            // 只回收更新图纸版本的图纸信息
            List<DcDrawInfoEntity> recycleDcDrawInfoEntityList = oldDcDrawInfoList.stream()
                    .filter(
                            a -> newDcDrawInfoEntityList.stream().noneMatch(b -> b.getDrawCode().equals(a.getDrawCode()) && b.getDrawVsn().equals(a.getDrawVsn()))
                    ).collect(Collectors.toList());
            /*
             * 循环设置回收的图纸信息数据值
             */
            for (DcDrawInfoEntity dcDrawInfoEntity : recycleDcDrawInfoEntityList) {
                DcDrawrecycleDrawinfoEntity dcDrawrecycleDrawinfoEntity = BeanMapper.map(dcDrawInfoEntity, DcDrawrecycleDrawinfoEntity.class);
                dcDrawrecycleDrawinfoEntity.setId(null);
                dcDrawrecycleDrawinfoEntity.setTenantId(null);
                dcDrawrecycleDrawinfoEntity.setCreateDeptId(null);
                dcDrawrecycleDrawinfoEntity.setCreateTime(null);
                dcDrawrecycleDrawinfoEntity.setCreateUserCode(null);
                dcDrawrecycleDrawinfoEntity.setUpdateTime(null);
                dcDrawrecycleDrawinfoEntity.setUpdateUserCode(null);
                dcDrawrecycleDrawinfoEntityList.add(dcDrawrecycleDrawinfoEntity);
            }
            // 设置图纸回收数据值
            DcDrawrecycleInfoEntity dcDrawrecycleInfoEntity = new DcDrawrecycleInfoEntity();
            dcDrawrecycleInfoEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            dcDrawrecycleInfoEntity.setDrwgrpCode(oldDcDrwgrpInfo.getDrwgrpCode());
            dcDrawrecycleInfoEntity.setDrwgrpName(oldDcDrwgrpInfo.getDrwgrpName());
            dcDrawrecycleInfoEntity.setDrwgrpVsn(oldDcDrwgrpInfo.getDrwgrpVsn());
            dcDrawrecycleInfoEntity.setDrwgrpType(oldDcDrwgrpInfo.getDrwgrpType());
            dcDrawrecycleInfoEntity.setSourceUnitid(oldDcDrwgrpInfo.getSourceUnitid());
            dcDrawrecycleInfoEntity.setSourceUnitname(oldDcDrwgrpInfo.getSourceUnitname());
            dcDrawrecycleInfoEntity.setMgrp(oldDcDrwgrpInfo.getMgrp());
            dcDrawrecycleInfoEntity.setSpecialty(oldDcDrwgrpInfo.getSpecialty());
            dcDrawrecycleInfoEntity.setSys(oldDcDrwgrpInfo.getSys());
            dcDrawrecycleInfoEntity.setDrawArriveDate(oldDcDrwgrpInfo.getDrawArriveDate());
            dcDrawrecycleInfoEntity.setIssueUserCode(oldDcDrwgrpInfo.getIssueUserCode());
            dcDrawrecycleInfoEntity.setIssueUserName(oldDcDrwgrpInfo.getIssueUserName());
            dcDrawrecycleInfoEntity.setIssueDate(oldDcDrwgrpInfo.getIssueDate());
            dcDrawrecycleInfoEntity.setOrgCode(oldDcDrwgrpInfo.getOrgCode());
            dcDrawrecycleInfoEntity.setOrgId(oldDcDrwgrpInfo.getOrgId());
            dcDrawrecycleInfoEntity.setOrgName(oldDcDrwgrpInfo.getOrgName());
            dcDrawrecycleInfoEntity.setParentOrgId(oldDcDrwgrpInfo.getParentOrgId());
            dcDrawrecycleInfoEntity.setParentOrgCode(oldDcDrwgrpInfo.getParentOrgCode());
            dcDrawrecycleInfoEntity.setParentOrgName(oldDcDrwgrpInfo.getParentOrgName());
            dcDrawrecycleInfoEntity.setProjectCode(oldDcDrwgrpInfo.getProjectCode());
            dcDrawrecycleInfoEntity.setProjectId(oldDcDrwgrpInfo.getProjectId());
            dcDrawrecycleInfoEntity.setProjectName(oldDcDrwgrpInfo.getProjectName());
            dcDrawrecycleInfoEntity.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
            dcDrawrecycleInfoEntity.setDcDrawrecycleDrawinfoList(dcDrawrecycleDrawinfoEntityList);
            dcDrawrecycleInfoEntity.setTenantId(null);
            dcDrawrecycleInfoEntity.setCreateDeptId(null);
            dcDrawrecycleInfoEntity.setCreateTime(null);
            dcDrawrecycleInfoEntity.setCreateUserCode(null);
            dcDrawrecycleInfoEntity.setUpdateTime(null);
            dcDrawrecycleInfoEntity.setUpdateUserCode(null);
            // 转换对象类型
            DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(dcDrawrecycleInfoEntity, DcDrawrecycleInfoVO.class);
            // 保存
            dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
            // 循环更新图纸库-图纸签发信息的是否回收字段为“已回收”
            dcDrawrecycleDrwgrpinfoEntityList.forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                    .eq(DcDrawdistributeRecordEntity::getId, dcDrawrecycleDrwgrpinfoEntity.getDrawdistributeDrwgrpinfoId())
                    .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode())));
        }
        /*
         * modify by XXX end
         */
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        logger.info("弃审后事件回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        // 修改流程状态为“待申请签发”
        dcDrawdistributeInfoService.update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        return CommonResponse.success();
    }

}
