/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcLssueAddressBookEntity;
import com.ejianc.business.dc.service.IDcLssueAddressBookDetailService;
import com.ejianc.business.dc.service.IDcLssueAddressBookService;
import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcLssueAddressBook"})
public class DcLssueAddressBookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDcLssueAddressBookService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcLssueAddressBookDetailService dcLssueAddressBookDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcLssueAddressBookVO> saveOrUpdate(@RequestBody DcLssueAddressBookVO saveOrUpdateVO) {
        DcLssueAddressBookEntity entity = (DcLssueAddressBookEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcLssueAddressBookEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter("eq", (Object)"0"));
        param.getParams().put("project_id", new Parameter("eq", (Object)saveOrUpdateVO.getProjectId()));
        param.getParams().put("address_book_type_code", new Parameter("eq", (Object)saveOrUpdateVO.getAddressBookTypeCode()));
        ComplexParam complexParam = new ComplexParam();
        complexParam.setLogic("or");
        complexParam.getParams().put("dr", new Parameter("eq", (Object)"0"));
        complexParam.getParams().put("address_book_name", new Parameter("eq", (Object)saveOrUpdateVO.getAddressBookName()));
        param.getComplexParams().add(complexParam);
        List dcLssueAddressBookList = this.service.queryList(param);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            OrgVO orgVO = (OrgVO)this.getRespData(this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            if (ToolUtil.isNotEmpty(orgVO)) {
                entity.setOrgId(orgVO.getId());
                entity.setOrgCode(orgVO.getCode());
                entity.setOrgName(orgVO.getName());
            }
            if (ToolUtil.isEmpty(dcLssueAddressBookList) || dcLssueAddressBookList.size() > 0) {
                return CommonResponse.error((String)"\u7b7e\u53d1\u901a\u8baf\u5f55\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u201c\u9879\u76ee\u540d\u79f0\u201d\uff0c\u201c\u7b7e\u53d1\u901a\u8baf\u5f55\u540d\u79f0\u201d\uff0c\u201c\u7b7e\u53d1\u901a\u8baf\u5f55\u7c7b\u578b\u201d");
            }
        } else if (ToolUtil.isNotEmpty(dcLssueAddressBookList) && dcLssueAddressBookList.size() > 1) {
            return CommonResponse.error((String)"\u7b7e\u53d1\u901a\u8baf\u5f55\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u201c\u9879\u76ee\u540d\u79f0\u201d\uff0c\u201c\u7b7e\u53d1\u901a\u8baf\u5f55\u540d\u79f0\u201d\uff0c\u201c\u7b7e\u53d1\u901a\u8baf\u5f55\u7c7b\u578b\u201d");
        }
        this.service.saveOrUpdate((Object)entity, false);
        DcLssueAddressBookVO vo = (DcLssueAddressBookVO)((Object)BeanMapper.map((Object)((Object)entity), DcLssueAddressBookVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcLssueAddressBookVO> queryDetail(Long id) {
        DcLssueAddressBookEntity entity = (DcLssueAddressBookEntity)((Object)this.service.selectById(id));
        DcLssueAddressBookVO vo = (DcLssueAddressBookVO)((Object)BeanMapper.map((Object)((Object)entity), DcLssueAddressBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcLssueAddressBookVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcLssueAddressBookVO dcLssueAddressBookVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcLssueAddressBookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("addressBookName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcLssueAddressBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcLssueAddressBook-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcLssueAddressBookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcLssueAddressBookVO>> refDcLssueAddressBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (ToolUtil.isNotEmpty(_con.get((Object)"projectId"))) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (ToolUtil.isNotEmpty(_con.get((Object)"addressBookType"))) {
                param.getParams().put("addressBookTypeCode", new Parameter("eq", _con.get((Object)"addressBookType")));
            }
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcLssueAddressBookVO.class));
        pageData.getRecords().forEach(a -> {
            QueryParam param1 = new QueryParam();
            param1.getParams().put("addressBookId", new Parameter("eq", (Object)a.getId()));
            List dcLssueAddressBookDetailList = this.dcLssueAddressBookDetailService.queryList(param1);
            dcLssueAddressBookDetailList = ToolUtil.isNotEmpty(dcLssueAddressBookDetailList) ? dcLssueAddressBookDetailList : Lists.newArrayList();
            List dcLssueAddressBookDetailVOS = BeanMapper.mapList((Iterable)dcLssueAddressBookDetailList, DcLssueAddressBookDetailVO.class);
            a.setDcLssueAddressBookDetailList(dcLssueAddressBookDetailVOS);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

