/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.dc.bean.DcDrawrecycleInfoEntity;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.service.IDcDrawrecycleInfoService;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcDrawrecycleInfo"})
public class DcDrawrecycleInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IAttachmentService iAttachmentService;
    public static final String BILL_CODE = "DC_DRAWRECYCLE_CODE";
    @Autowired
    private IDcDrawrecycleInfoService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrawrecycleInfoVO> saveOrUpdate(@RequestBody DcDrawrecycleInfoVO saveOrUpdateVO) {
        DcDrawrecycleInfoEntity entity = (DcDrawrecycleInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcDrawrecycleInfoEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setRecycleSts(RecycleEnum.N.getCode());
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
        }
        entity.getDcDrawrecycleDrwgrpinfoList().forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(entity.getCreateDeptId()));
        entity.getDcDrawrecycleDrawinfoList().forEach(dcDrawrecycleDrawinfoEntity -> dcDrawrecycleDrawinfoEntity.setCreateDeptId(entity.getCreateDeptId()));
        this.service.saveOrUpdate((Object)entity, false);
        entity.getDcDrawrecycleDrawinfoList().forEach(dcDrawrecycleDrawinfoEntity -> this.iAttachmentService.attachmentFile(dcDrawrecycleDrawinfoEntity.getDrawId(), "BT230602000000005", dcDrawrecycleDrawinfoEntity.getId(), "BT230602000000003"));
        DcDrawrecycleInfoVO vo = (DcDrawrecycleInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrawrecycleInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcDrawrecycleInfoVO> queryDetail(Long id) {
        DcDrawrecycleInfoEntity entity = (DcDrawrecycleInfoEntity)((Object)this.service.selectById(id));
        DcDrawrecycleInfoVO vo = (DcDrawrecycleInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrawrecycleInfoVO.class));
        vo.setRecycleStsCn(RecycleEnum.getEnumByCode(vo.getRecycleSts()).getName());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/recycle"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> recycle(@RequestBody List<DcDrawrecycleInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            this.service.recycle(vos);
        }
        return CommonResponse.success((String)"\u56fe\u7eb8\u56de\u6536\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrawrecycleInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcDrawrecycleInfoVO dcDrawrecycleInfoVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcDrawrecycleInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("drwgrpCode");
        fuzzyFields.add("drwgrpVsn");
        fuzzyFields.add("drwgrpName");
        fuzzyFields.add("issueUserName");
        fuzzyFields.add("recycleCode");
        fuzzyFields.add("recycleUserName");
        fuzzyFields.add("recycleDate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrawrecycleInfoVO.class));
        pageData.getRecords().forEach(e -> e.setRecycleStsCn(StringUtils.isBlank((CharSequence)e.getRecycleSts()) ? "" : RecycleEnum.getEnumByCode(e.getRecycleSts()).getName()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrawrecycleInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcDrawrecycleInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcDrawrecycleInfoVO>> refDcDrawrecycleInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrawrecycleInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

