package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcLssueAddressBookDetailEntity;
import com.ejianc.business.dc.bean.DcLssueAddressBookEntity;
import com.ejianc.business.dc.service.IDcLssueAddressBookDetailService;
import com.ejianc.business.dc.service.IDcLssueAddressBookService;
import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签发通讯录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcLssueAddressBook")
public class DcLssueAddressBookController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDcLssueAddressBookService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDcLssueAddressBookDetailService dcLssueAddressBookDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcLssueAddressBookVO> saveOrUpdate(@RequestBody DcLssueAddressBookVO saveOrUpdateVO) {
    	DcLssueAddressBookEntity entity = BeanMapper.map(saveOrUpdateVO, DcLssueAddressBookEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        param.getParams().put("project_id", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        param.getParams().put("address_book_type_code", new Parameter(QueryParam.EQ, saveOrUpdateVO.getAddressBookTypeCode()));
        ComplexParam complexParam = new ComplexParam();
        complexParam.setLogic(ComplexParam.OR);
        complexParam.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        complexParam.getParams().put("address_book_name", new Parameter(QueryParam.EQ, saveOrUpdateVO.getAddressBookName()));
        param.getComplexParams().add(complexParam);
        List<DcLssueAddressBookEntity> dcLssueAddressBookList = service.queryList(param);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            OrgVO orgVO = (OrgVO) getRespData(iOrgApi.getOneById(InvocationInfoProxy.getOrgId()), true, "查询失败，获取组织信息失败。");
            if (ToolUtil.isNotEmpty(orgVO)) {
                entity.setOrgId(orgVO.getId());
                entity.setOrgCode(orgVO.getCode());
                entity.setOrgName(orgVO.getName());
            }
            if (ToolUtil.isNotEmpty(dcLssueAddressBookList) || dcLssueAddressBookList.size() > 0) {
                return CommonResponse.error("签发通讯录重复！请检查“项目名称”，“签发通讯录名称”，“签发通讯录类型”");
            }
        } else {
            if (ToolUtil.isNotEmpty(dcLssueAddressBookList) && dcLssueAddressBookList.size() > 1) {
                return CommonResponse.error("签发通讯录重复！请检查“项目名称”，“签发通讯录名称”，“签发通讯录类型”");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DcLssueAddressBookVO vo = BeanMapper.map(entity, DcLssueAddressBookVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcLssueAddressBookVO> queryDetail(Long id) {
    	DcLssueAddressBookEntity entity = service.selectById(id);
    	DcLssueAddressBookVO vo = BeanMapper.map(entity, DcLssueAddressBookVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcLssueAddressBookVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DcLssueAddressBookVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DcLssueAddressBookVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcLssueAddressBookVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("addressBookName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        /** 要求主表有orgId字段，保存单据所属组织 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcLssueAddressBookEntity> page = service.queryPage(param,false);
        IPage<DcLssueAddressBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcLssueAddressBookVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcLssueAddressBookEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcLssueAddressBook-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDcLssueAddressBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcLssueAddressBookVO>> refDcLssueAddressBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (ToolUtil.isNotEmpty(_con.get("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            // 签发通讯录类型-图纸签发（0）
            if (ToolUtil.isNotEmpty(_con.get("addressBookType"))) {
                param.getParams().put("addressBookTypeCode", new Parameter(QueryParam.EQ, _con.get("addressBookType")));
            }
        }
        /*
         * 组织过滤数据
         */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.forEach(org -> commonOrgIds.add(org.getId()));
        /** 要求主表有orgId字段，保存单据所属组织 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));

        IPage<DcLssueAddressBookEntity> page = service.queryPage(param,false);
        IPage<DcLssueAddressBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcLssueAddressBookVO.class));

        pageData.getRecords().forEach(a -> {
            QueryParam param1 = new QueryParam();
            param1.getParams().put("addressBookId", new Parameter(QueryParam.EQ, a.getId()));
            List<DcLssueAddressBookDetailEntity> dcLssueAddressBookDetailList = dcLssueAddressBookDetailService.queryList(param1);
            dcLssueAddressBookDetailList = ToolUtil.isNotEmpty(dcLssueAddressBookDetailList) ? dcLssueAddressBookDetailList : Lists.newArrayList();
            List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailVOS = BeanMapper.mapList(dcLssueAddressBookDetailList, DcLssueAddressBookDetailVO.class);
            a.setDcLssueAddressBookDetailList(dcLssueAddressBookDetailVOS);
        });
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
