package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.enumUtils.YesOrNoEnum;
import com.ejianc.business.dc.service.*;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcDrawrecycleInfoMapper;

import java.util.Date;
import java.util.List;

/**
 * 图纸回收
 * 
 * @author generator
 * 
 */
@Service("dcDrawrecycleInfoService")
public class DcDrawrecycleInfoServiceImpl extends BaseServiceImpl<DcDrawrecycleInfoMapper, DcDrawrecycleInfoEntity> implements IDcDrawrecycleInfoService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawrecycleDrwgrpinfoService dcDrawrecycleDrwgrpinfoService;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;

    @Override
    public void recycle(List<DcDrawrecycleInfoVO> vos) {
        for (DcDrawrecycleInfoVO vo : vos) {
            BillCodeParam billCodeParam = BillCodeParam.build(DcDrawrecycleInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(), vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess() && ToolUtil.isEmpty(vo.getRecycleCode())) {
                update(new UpdateWrapper<DcDrawrecycleInfoEntity>().lambda()
                        .eq(DcDrawrecycleInfoEntity::getId, vo.getId())
                        .set(DcDrawrecycleInfoEntity::getRecycleSts, RecycleEnum.Y.getCode())
                        .set(DcDrawrecycleInfoEntity::getRecycleCode, billCode.getData())
                        .set(DcDrawrecycleInfoEntity::getRecycleDate, new Date())
                        .set(DcDrawrecycleInfoEntity::getRecycleUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawrecycleInfoEntity::getRecycleUserName, sessionManager.getUserContext().getUserName()));

                /*
                 * modify by XXX start
                 *  卷册套数和库存量增减，根据图纸库-图纸信息中的图纸类型为目录的图纸类型判断
                 * 图纸为纸质版，回收后增加库存量
                 * 图纸为电子版，回收后减少卷册套数
                 */
                //
                List<DcDrawInfoEntity> dcDrawdistributeDrawinfoList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                        .lambda()
                        .eq(DcDrawInfoEntity::getDr, 0)
                        .eq(DcDrawInfoEntity::getDrwgrpId, vo.getDrwgrpId()));
                // 图纸库-图纸信息数据是否为纸质版
                boolean paperFlag = dcDrawdistributeDrawinfoList.stream().anyMatch(a -> {
                    try {
                        JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                        return
                                DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"))
                                        && PaperFlagEnum.ARE.getCode().equals(a.getPaperFlag());
                    } catch (Exception e) {
                        return false;
                    }
                });
                if (paperFlag) {
                    /*
                     * 纸质版
                     */
                    // 图纸回收-签发信息（一共签发的份数从这个里面计算）
                    List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoList = dcDrawrecycleDrwgrpinfoService.list(new QueryWrapper<DcDrawrecycleDrwgrpinfoEntity>().lambda()
                            .eq(DcDrawrecycleDrwgrpinfoEntity::getPid, vo.getId())
                            .eq(DcDrawrecycleDrwgrpinfoEntity::getDr, 0)
                            .isNotNull(DcDrawrecycleDrwgrpinfoEntity::getNum));
                    // 签发份数
                    int num = dcDrawrecycleDrwgrpinfoList.stream().mapToInt(DcDrawrecycleDrwgrpinfoEntity::getNum).sum();
                    // 更新图纸库的卷册套数
                    dcDrwgrpInfoService.update(
                            new UpdateWrapper<DcDrwgrpInfoEntity>()
                                    .lambda()
                                    .eq(DcDrwgrpInfoEntity::getId, vo.getDrwgrpId())
                                    .eq(DcDrwgrpInfoEntity::getDr, 0)
                                    .setSql("surplus_num = surplus_num + " + num)
                    );
                } else {
                    // 图纸库信息
                    DcDrwgrpInfoEntity dcDrwgrpInfo = dcDrwgrpInfoService.getOne(
                            new QueryWrapper<DcDrwgrpInfoEntity>().lambda()
                                    .eq(DcDrwgrpInfoEntity::getDr, 0)
                                    .eq(DcDrwgrpInfoEntity::getId, vo.getDrwgrpId())
                                    .last("LIMIT 1")
                    );
                    // 图纸回收-签发信息（一共签发的份数从这个里面计算）
                    List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoList = dcDrawrecycleDrwgrpinfoService.list(new QueryWrapper<DcDrawrecycleDrwgrpinfoEntity>().lambda()
                            .eq(DcDrawrecycleDrwgrpinfoEntity::getPid, vo.getId())
                            .eq(DcDrawrecycleDrwgrpinfoEntity::getDr, 0)
                            .isNotNull(DcDrawrecycleDrwgrpinfoEntity::getNum));
                    // 签发份数
                    int num = dcDrawrecycleDrwgrpinfoList.stream().mapToInt(DcDrawrecycleDrwgrpinfoEntity::getNum).sum();
                    // 之前的卷册套数
                    int drwgrpNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getDrwgrpNum()) ? dcDrwgrpInfo.getDrwgrpNum() : 0;
                    if (drwgrpNum < num) {
                        CommonResponse.error(String.format("图纸回收失败！该卷册卷册数量小于回收数量；卷册数量[{%s}],回收数量[%s]", drwgrpNum, num));
                    }
                    // 卷册套数=之前的卷册套数-签发份数
                    drwgrpNum = drwgrpNum - num;
                    // 更新图纸库的卷册套数
                    dcDrwgrpInfoService.update(
                            new UpdateWrapper<DcDrwgrpInfoEntity>()
                                    .lambda()
                                    .set(DcDrwgrpInfoEntity::getDrwgrpNum, drwgrpNum)
                                    .eq(DcDrwgrpInfoEntity::getId, vo.getDrwgrpId())
                                    .eq(DcDrwgrpInfoEntity::getDr, 0)
                    );
                }
                /*
                 * modify by XXX end
                 */
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    }
}
