package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.basem.service.ISystemService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcExcelMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.util.DetailIndexExcelReader;
import com.ejianc.business.dc.util.EJCDateUtil;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.ejianc.business.pro.ref.api.IRefApi;


import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.business.dc.util.ToolUtil.isInteger;

/**
 * 劳务分包档案
 *
 * @author generator
 */
@Service("labsubItemService")
public class ExcelItemServiceImpl implements IExcelItemService {

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRefApi iRefApi;

    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;

    @Autowired
    private IDcDrawInfoService dcDrawInfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DcExcelMapper mapper;


    @Override
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {



        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrwgrpInfoImportVO> successList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> errorList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> rtErrorList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> success500TmpList = new ArrayList<>(500);


        Map<String, DcDrwgrpInfoImportVO> selfCheckDcDrwgrp = new HashMap<>();
        Map<String, Integer> selfCheck = new HashMap<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                    }
                    Map<String, Map<String,Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("projectId")), Function.identity(),(e1,e2)->e2)
                    );
                    Map<String, Map<String,Object>> dcDrwgrpTypeDataMap = mapper.queryBigType().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );
                    Map<String, Map<String,Object>> sourceUnitnameDataMap = mapper.queryMapSource().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );
                    Map<String, Map<String,Object>> projDataMap = mapper.queryMapProjLocal().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );



                    for (int i = 0; i < result.size(); i++) {
                        Boolean flag = true;
                        List<String> datas = result.get(i);
                        DcDrwgrpInfoImportVO dcDrwgrpInfoVO = new DcDrwgrpInfoImportVO();
                        StringBuilder errorMessage = new StringBuilder("");
                        dcDrwgrpInfoVO.setId(IdWorker.getId());

                        // projectName
                        String projectName = datas.get(0);
                        if (ToolUtil.isNotEmpty(projectName)) {
                            Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                            if (ToolUtil.isNotEmpty(projectNameMap)) {
                                dcDrwgrpInfoVO.setProjectName((String) projectNameMap.get("name"));
                                dcDrwgrpInfoVO.setProjectCode((String) projectNameMap.get("code"));
                                Object id = projectNameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setProjectId(Long.parseLong((String) id));
                                } else {
                                    dcDrwgrpInfoVO.setProjectId((Long) id);
                                }
                            } else {
                                errorMessage.append("[项目名称]" + projectName + ":错误参照无法获取;");
                                flag = false;
                            }
                        }
                        // drwgrpCode
                        String drwgrpCode = datas.get(1);
                        if (ToolUtil.isEmpty(drwgrpCode)) {
                            errorMessage.append("[卷册编号]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpCode(drwgrpCode);
                        // drwgrpName
                        String drwgrpName = datas.get(2);
                        if (ToolUtil.isEmpty(drwgrpName)) {
                            errorMessage.append("[卷册名称]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpName(drwgrpName);
                        // drwgrpVsn
                        String drwgrpVsn = datas.get(3);
                        if (ToolUtil.isEmpty(drwgrpVsn)) {
                            errorMessage.append("[卷册版本]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpVsn(drwgrpVsn);
                        // drwgrpTypeName
                        String drwgrpTypeName = datas.get(4);
                        if (ToolUtil.isNotEmpty(drwgrpTypeName)) {
                            Map<String, Object> drwgrpTypeNameMap = (Map<String, Object>) dcDrwgrpTypeDataMap.get(drwgrpTypeName);
                            if (ToolUtil.isNotEmpty(drwgrpTypeNameMap)) {
                                Object id = drwgrpTypeNameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setDrwgrpType(Long.parseLong((String) id));
                                } else {
                                    dcDrwgrpInfoVO.setDrwgrpType((Long) id);
                                }
                            } else {
                                errorMessage.append("[图纸类别]" + drwgrpTypeName + ":自定义档案错误;");
                                flag = false;
                            }
                        }
                        // TransferCode
                        dcDrwgrpInfoVO.setTransferCode(datas.get(5));
                        // drawArriveDateStr
                        String drawArriveDateStr = datas.get(6);
                        if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                            Date parse = EJCDateUtil.parseDate(drawArriveDateStr, EJCDateUtil.DATE);
                            if (ToolUtil.isNotEmpty(parse)) {
                                dcDrwgrpInfoVO.setDrawArriveDate(parse);
                            } else {
                                errorMessage.append("[到图日期]" + drawArriveDateStr + ":格式错误");
                                flag = false;
                            }
                        } else {
                            errorMessage.append("[到图日期]为空;");
                            flag = false;
                        }
                        // sourceUnitname
                        String sourceUnitname = datas.get(7);
                        if (ToolUtil.isNotEmpty(sourceUnitname)) {
                            Map<String, Object> sourceUnitnameMap = (Map<String, Object>) sourceUnitnameDataMap.get(sourceUnitname);
                            if (ToolUtil.isNotEmpty(sourceUnitnameMap)) {
                                dcDrwgrpInfoVO.setSourceUnitname((String) sourceUnitnameMap.get("name"));
                                Object id = sourceUnitnameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setSourceUnitid(Long.parseLong((String) sourceUnitnameMap.get("id")));
                                } else {
                                    dcDrwgrpInfoVO.setSourceUnitid((Long) sourceUnitnameMap.get("id"));
                                }

                            } else {
                                errorMessage.append("[设计单位]" + sourceUnitname + ":参照错误;");
                                flag = false;
                            }
                        } else {
                            errorMessage.append("[设计单位]为空;");
                            flag = false;
                        }
                        // drwgrpNum
                        String drwgrpNum = datas.get(8);
                        if (ToolUtil.isNotEmpty(drwgrpNum)) {
                            if (!isInteger(drwgrpNum)) {
                                errorMessage.append("[卷册套数]" + drwgrpNum + ":为非数字;");
                                flag = false;
                            } else {
                                int i1 = Integer.parseInt(drwgrpNum);
                                dcDrwgrpInfoVO.setDrwgrpNum(i1);
                                dcDrwgrpInfoVO.setSurplusNum(i1);
                            }
                        } else {
                            dcDrwgrpInfoVO.setDrwgrpNum(0);
                            dcDrwgrpInfoVO.setSurplusNum(0);
                        }
//                        // surplusNum
//                        String surplusNum = datas.get(9);
//                        if (ToolUtil.isNotEmpty(surplusNum)) {
//                            if (!isInteger(surplusNum)) {
//                                errorMessage.append("[库存量]" + surplusNum + ":为非数字;");
//                                flag = false;
//                            } else {
//                                dcDrwgrpInfoVO.setSurplusNum(Integer.parseInt(surplusNum));
//                            }
//                        } else {
//                            dcDrwgrpInfoVO.setDrwgrpNum(0);
//                        }
//                    Remarks
                        dcDrwgrpInfoVO.setRemarks(datas.get(9));
                        dcDrwgrpInfoVO.setRowIndex((i + 2));
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(dcDrwgrpInfoVO.getProjectId()));
                        dcDrwgrpInfoVO.setOrgId((Long) stringStringMap.get("orgId"));
                        dcDrwgrpInfoVO.setOrgCode((String) stringStringMap.get("orgCode"));
                        dcDrwgrpInfoVO.setOrgName((String)stringStringMap.get("orgName"));
                        dcDrwgrpInfoVO.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        dcDrwgrpInfoVO.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                        dcDrwgrpInfoVO.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                        Integer integer = selfCheck.get(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isNotEmpty(integer)) {
                            errorMessage.append("excel中已存在该数据与第" + integer + "行重复;");
                            flag = false;
                        } else {
                            selfCheck.put(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn(), (i + 2));
                        }
                        if (flag) {
                            success500TmpList.add(dcDrwgrpInfoVO);
                            if (success500TmpList.size() == 500) {
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                                if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                                    dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                        DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                        selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                                    });
                                }
                                success500TmpList.stream().forEach(el -> {
                                    DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                                        errorMessage.append("数据库中已存在该数据;");
                                        el.setErrorMessage(errorMessage.toString());
                                        errorList.add(el);
                                    } else {
                                        successList.add(el);
                                    }
                                });
                                success500TmpList = new ArrayList<DcDrwgrpInfoImportVO>(500);
                            }
                        } else {
                            dcDrwgrpInfoVO.setErrorMessage(errorMessage.toString());
                            errorList.add(dcDrwgrpInfoVO);
                        }
                    }
                    if (ToolUtil.isNotEmpty(success500TmpList)) {
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                        if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                            dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                            });
                        }
                        success500TmpList.stream().forEach(el -> {
                            DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                            if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                                el.setErrorMessage("数据库中已存在该数据;");
                                errorList.add(el);
                            } else {
                                successList.add(el);
                            }
                        });
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrwgrpInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        return success;
    }
    @Override
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrawInfoImportVO> successList = new ArrayList<>();
        List<DcDrawInfoImportVO> errorList = new ArrayList<>();
        List<DcDrawInfoImportVO> rtErrorList = new ArrayList<>();
        List<DcDrawInfoImportVO> success500TmpList = new ArrayList<>(500);
        Map<String, Integer> selfCheck = new HashMap<>();
        Map<String, DcDrwgrpInfoEntity> selfCheckDb = new HashMap<>();
        List<DcDrwgrpInfoEntity> selfCheckDbList = new ArrayList<>();
        Map<String, Long> dcDrwgrpMap = new HashMap<String, Long>();
        StringBuilder comStr = new StringBuilder();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                }
                Map<String, Map<String,Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("projectId")), Function.identity(),(e1,e2)->e2)
                );
                Map<String, Map<String,Object>> drawTypeDataMap = mapper.querySmallType().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );
                Map<String, Map<String,Object>> projDataMap = mapper.queryMapProjLocal().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );
                for (int i = 0; i < result.size(); i++) {
                    Boolean flag = true;
                    List<String> datas = result.get(i);
                    DcDrawInfoImportVO dcDrawInfoVO = new DcDrawInfoImportVO();
                    StringBuilder errorMessage = new StringBuilder("");
                    dcDrawInfoVO.setId(IdWorker.getId());
                    // 打印状态：默认未打印
                    dcDrawInfoVO.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                    // projectName
                    String projectName = datas.get(0);
                    if (ToolUtil.isNotEmpty(projectName)) {
                        Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                        if (ToolUtil.isNotEmpty(projectNameMap)) {
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                dcDrawInfoVO.setProjectId(Long.parseLong((String) id));
                            } else {
                                dcDrawInfoVO.setProjectId((Long) id);
                            }
                            dcDrawInfoVO.setProjectCode((String) projectNameMap.get("code"));
                            dcDrawInfoVO.setProjectName((String) projectNameMap.get("name"));
                        } else {
                            errorMessage.append("[项目名称]" + projectName + ":错误参照无法获取;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[项目名称]为空;");
                        flag = false;
                    }
                    // drawCode
                    String drawCode = datas.get(1);
                    if (ToolUtil.isEmpty(drawCode)) {
                        errorMessage.append("[图纸编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawCode(drawCode);

                    // drawName
                    String drawName = datas.get(2);
                    if (ToolUtil.isEmpty(drawName)) {
                        errorMessage.append("[图纸名称]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawName(drawName);
                    // drawVsn
                    String drawVsn = datas.get(3);
                    if (ToolUtil.isEmpty(drawVsn)) {
                        errorMessage.append("[图纸版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawVsn(drawVsn);
                    // drwgrpCode
                    String drwgrpCode = datas.get(4);
                    if (ToolUtil.isEmpty(drwgrpCode)) {
                        errorMessage.append("[卷册编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpCode(drwgrpCode);
                    // drwgrpVsn
                    String drwgrpVsn = datas.get(5);
                    if (ToolUtil.isEmpty(drwgrpVsn)) {
                        errorMessage.append("[卷册版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpVsn(drwgrpVsn);
                    // TransferCode
                    dcDrawInfoVO.setTransferCode(datas.get(6));
                    // paperFlag
                    String paperFlag = datas.get(7);
                    if (ToolUtil.isEmpty(paperFlag)) {
                        errorMessage.append("[是否纸质版]为空;");
                        flag = false;
                    } else if (ToolUtil.isEmpty(PaperFlagEnum.getEnumByName(paperFlag))) {
                        errorMessage.append("[是否纸质版]必须为“是”或“否”;");
                        flag = false;
                    }
                    dcDrawInfoVO.setPaperFlag(PaperFlagEnum.getEnumByName(paperFlag).getCode());
                    // drawArriveDateStr
                    String drawArriveDateStr = datas.get(8);
                    if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                        Date parse = EJCDateUtil.parseDate(drawArriveDateStr, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            dcDrawInfoVO.setDrawArriveDate(parse);
                        } else {
                            errorMessage.append("[到图日期]" + drawArriveDateStr + ":格式错误;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[到图日期]为空;");
                        flag = false;
                    }
                    // drawTypeName
                    String drawTypeName = datas.get(9);
                    if (ToolUtil.isNotEmpty(drawTypeName)) {
                        Map<String, Object> drawTypeMap = (Map<String, Object>) drawTypeDataMap.get(drawTypeName);
                        if (ToolUtil.isNotEmpty(drawTypeMap)) {
                            Object id = drawTypeMap.get("id");
                            if (id instanceof String) {
                                dcDrawInfoVO.setDrawType(Long.parseLong((String) id));
                            } else {
                                dcDrawInfoVO.setDrawType((Long) id);
                            }
                        } else {
                            errorMessage.append("[图纸类型]" + drawTypeName + ":自定义档案错误;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[图纸类型]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setRowIndex((i + 2));
                    if (ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpCode()) && ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpVsn())) {
                        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = selfCheckDb.get(dcDrawInfoVO.getProjectId()+dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(dcDrwgrpInfoEntity)) {
                            DcDrwgrpInfoEntity dcDrwgrpInfoEntityTemp = new DcDrwgrpInfoEntity();
                            dcDrwgrpInfoEntityTemp.setProjectId(dcDrawInfoVO.getProjectId());
                            dcDrwgrpInfoEntityTemp.setDrwgrpCode(dcDrawInfoVO.getDrwgrpCode());
                            dcDrwgrpInfoEntityTemp.setDrwgrpVsn(dcDrawInfoVO.getDrwgrpVsn());
                            selfCheckDb.put(dcDrawInfoVO.getProjectId()+dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(), dcDrwgrpInfoEntityTemp);
                            selfCheckDbList.add(dcDrwgrpInfoEntityTemp);
                        }
                    }
                    Integer integer = selfCheck.get(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn());
                    if (ToolUtil.isNotEmpty(integer)) {
                        errorMessage.append("excel中已存在该数据与第" + integer + "行重复;");
                        flag = false;
                    } else {
                        selfCheck.put(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn(), (i + 2));
                    }
                    if (flag) {
                        success500TmpList.add(dcDrawInfoVO);
                        if (success500TmpList.size() == 500) {
                            Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                            if (ToolUtil.isNotEmpty(selfCheckDbList)){
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                                selfCheckDbList = new ArrayList<>();
                                dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> {
                                    dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId());
                                });
                            }
                            List<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                            success500TmpList.stream().forEach(es -> {
                                Long aLong = dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                                if (ToolUtil.isEmpty(aLong)) {
                                    es.setErrorMessage("该图纸无卷册信息;");
                                } else {
                                    es.setDrwgrpId(aLong);
                                    Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(es.getProjectId()));
                                    es.setOrgId((Long) stringStringMap.get("orgId"));
                                    es.setOrgCode((String) stringStringMap.get("orgCode"));
                                    es.setOrgName((String)stringStringMap.get("orgName"));
                                    es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                                    es.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                                    es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                                    dcDrawInfoEntityList.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                                }
                            });
                            if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                                List<DcDrawInfoEntity> dcDrawInfoEntityListDb = dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                                dcDrawInfoEntityListDb.stream().forEach(ce -> {
                                    dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1);
                                });
                            }
                            success500TmpList.stream().forEach(ce -> {
                                if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                                    if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                        ce.setErrorMessage("数据库中已存在该数据;");
                                        errorList.add(ce);
                                    } else {
                                        successList.add(ce);
                                    }
                                } else {
                                    errorList.add(ce);
                                }
                            });
                            success500TmpList = new ArrayList<>(500);
                        }
                    } else {
                        dcDrawInfoVO.setErrorMessage(errorMessage.toString());
                        errorList.add(dcDrawInfoVO);
                    }
                }
                if (ToolUtil.isNotEmpty(success500TmpList)) {
                    Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                    if (ToolUtil.isNotEmpty(selfCheckDbList)){
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                        dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> {
                            dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId());
                        });
                    }
                    List<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                    success500TmpList.stream().forEach(es -> {
                        Long aLong = dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(aLong)) {
                            es.setErrorMessage("该图纸无卷册信息;");
                        } else {
                            es.setDrwgrpId(aLong);
                            Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(es.getProjectId()));
                            es.setOrgId((Long) stringStringMap.get("orgId"));
                            es.setOrgCode((String) stringStringMap.get("orgCode"));
                            es.setOrgName((String)  stringStringMap.get("orgName"));
                            es.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                            es.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                            es.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                            dcDrawInfoEntityList.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                        }
                    });
                    if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)){
                        List<DcDrawInfoEntity> dcDrawInfoEntityListDb = dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                        dcDrawInfoEntityListDb.stream().forEach(ce -> {
                            dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1);
                        });
                    }
                    success500TmpList.stream().forEach(ce -> {
                        if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                            if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                ce.setErrorMessage("数据库中已存在该数据;");
                                errorList.add(ce);
                            } else {
                                successList.add(ce);
                            }
                        } else {
                            errorList.add(ce);
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrawInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        success.setMsg(comStr.toString());
        return success;
    }
}
