package com.ejianc.business.dc.util;

import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

/**
 * @author: swb
 * @date: 2023/05/15
 **/
@Controller
@RequestMapping("deleteCache")
public class DeleteCache {

    @RequestMapping(value = "/deleteCache", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> deleteCache(@RequestBody Map<String,Object> params) {
        String referCode = (String) params.get("referCode");
        String key = (String) params.get("key");
        RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
        String cacheKey = referCode + ":" + key;
        redisTemplate.delete(cacheKey);
        return CommonResponse.success("清理缓存成功！");
    }
}
