package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @description: 发文管理
 * @author: chengminggao
 * @date: 2023/4/21 15:31
 **/
@Controller
@RequestMapping("dcSendFile")
public class DcSendFileController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";//此处需要根据实际修改
    @Autowired
    private IDcSendFileService service;

    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;//取号规则api
    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcSendFileVO> saveOrUpdate(@RequestBody DcSendFileVO saveOrUpdateVO) {
        CommonResponse<DcSendFileVO> response = service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }
/**
 * @description:文件升版接口
 * @author: chengminggao
 * @date: 2023/6/1 10:22
 * @param: [saveOrUpdateVO]
 * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.dc.vo.DcSendFileVO>
 **/
    @RequestMapping(value = "/upgrade", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcSendFileVO> upgrade(@RequestBody DcSendFileVO voEntity) {
        DcSendFileEntity entity = BeanMapper.map(voEntity, DcSendFileEntity.class);
        // 旧版数据ID
        long oldId = entity.getId();
        //先更新
        service.upgradeFileSts(entity);
        //再新增一条数据
        entity.setId(IdWorker.getId());
        entity.setFileSts("N");
        entity.setFlowState(FwFlowStateEnum.ZERO.getCode());
        entity.setFlowStateName(FwFlowStateEnum.ZERO.getName());
        entity.setBillState(null);
        entity.setCreateTime(null);
        entity.setSendDate(new Date());
        entity.setParentId(oldId);
        service.saveOrUpdate(entity, false);
        DcSendFileVO vo = BeanMapper.map(entity, DcSendFileVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcSendFileVO> queryDetail(Long id) {
    	DcSendFileEntity entity = service.selectById(id);
    	DcSendFileVO vo = BeanMapper.map(entity, DcSendFileVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcSendFileVO> vos) {
        CommonResponse<String> response = service.delete(vos);
        return response;
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcSendFileVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcSendFileEntity> page = service.queryPage(param,false);
        IPage<DcSendFileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcSendFileVO.class));
        pageData.getRecords().stream().forEach(e->{
            e.setFileStsCn(DrwgrpStsEnum.getEnumByCode(e.getFileSts()).getName());
        });

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcSendFileEntity> list = service.queryList(param);
        List<DcSendFileVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, DcSendFileVO.class);
            voList.forEach(vo -> {
                vo.setFileStsCn(DrwgrpStsEnum.getEnumByCode(vo.getFileSts()).getName());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcSendFile-export.xlsx", beans, response);
    }

/**
 * @description: 参照
 * @author: chengminggao
 * @date: 2023/4/21 15:28
 * @param: [pageNumber, pageSize, condition, searchObject, searchText]
 * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.dc.vo.DcSendFileVO>>
 **/
    @RequestMapping(value = "/refDcSendFileData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcSendFileVO>> refDcSendFileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcSendFileEntity> page = service.queryPage(param,false);
        IPage<DcSendFileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcSendFileVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 作废
     *
     * @param ids 主键ID
     * @return 返回对象
     */
    @PostMapping("/abolish")
    @ResponseBody
    public CommonResponse<Void> abolish(@RequestBody List<Long> ids) {
        for (Long id : ids) {
            // 发文管理-修改文件状态为“作废”
            service.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFileSts, "S")
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, id)
            );
            // 文件分发中心-修改文件状态为“作废”
            dcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFileSts, "S")
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getSourceId, id)
            );
        }
        return CommonResponse.success("作废成功！");
    }
}
