package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName TzFlowStateEnum
 * @Description 发文流程状态枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum FwFlowStateEnum {
    // 草稿状态
    ZERO("0", "草稿状态"),
    // 部门主任审核中
    ONE("1", "部门主任审核中"),
    // 部门主任退回
    TWO("2", "部门主任退回"),
    // 技术组长审核中
    THREE("3", "技术组长审核中"),
    // 技术组长退回
    FOUR("4", "技术组长退回"),
    // 会签中
    FIVE("5", "会签中"),
    // 会签退回
    SIX("6", "会签退回"),
    // 分管领导审核中
    SEVEN("7", "分管领导审核中"),
    // 分管领导退回
    EIGHT("8", "分管领导退回"),
    // 项目经理审核中
    NINE("9", "项目经理审核中"),
    // 项目经理退回
    TEN("10", "项目经理退回"),
    // 文档审核中
    ELEVEN("11", "文档审核中"),
    // 文档退回
    TWELVE("12", "文档退回"),
    // 报审中
    THIRTEEN("13", "报审中"),
    // 报备中
    FOURTEEN("14", "报备中"),
    // 内部发文中
    FIFTEEN("15", "内部发文中"),
    // 待上游回复
    SIXTEEN("16", "待上游回复"),
    // 待签发
    SEVENTEEN("17", "待签发"),
    // 待分发
    EIGHTEEN("18", "待分发"),
    // 已分发
    NINETEEN("19", "已分发"),
    // 审批驳回
    TWENTY("20", "审批驳回"),
    // 待升版
    TWENTY_ONE("21", "待升版"),
    // 已升版
    TWENTY_TWO("22", "已升版");

    private final String code;
    private final String name;
    private static Map<String, FwFlowStateEnum> enumMap = new HashMap();

    private FwFlowStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static FwFlowStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(FwFlowStateEnum.class).stream().collect(Collectors.toMap(FwFlowStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
