package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrawinfoMapper;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.mapper.DcDrawdistributeInfoMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrawinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 图纸分发
 *
 * @author generator
 */
@Service("dcDrawdistributeInfoService")
public class DcDrawdistributeInfoServiceImpl extends BaseServiceImpl<DcDrawdistributeInfoMapper, DcDrawdistributeInfoEntity> implements IDcDrawdistributeInfoService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private DcDrawdistributeInfoMapper dcDrawdistributeInfoMapper;
    @Autowired
    private DcDrawdistributeDrawinfoMapper dcDrawdistributeDrawinfoMapper;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private DcDrawdistributeDrwgrpinfoMapper dcDrawdistributeDrwgrpinfoMapper;

    @Override
    public void printDataDispose(List<Long> drwgrpIds) {
        if(ToolUtil.isEmpty(drwgrpIds)){
            throw new RuntimeException("请至少勾选一条数据");
        }
        for (Long drwgrpId : drwgrpIds) {
            // 查询图纸签发，根据卷册ID
            List<DcDrawdistributeInfoEntity> dcDrawdistributeInfoList = dcDrawdistributeInfoMapper.selectList(
                    new QueryWrapper<DcDrawdistributeInfoEntity>()
                            .lambda()
                            .eq(DcDrawdistributeInfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawdistributeInfoEntity::getDr, 0)
                            .orderByDesc(DcDrawdistributeInfoEntity::getCreateTime)
            );
            if (ToolUtil.isEmpty(dcDrawdistributeInfoList)) {
                throw new RuntimeException("请至少勾选一条数据");
            }
            // 是否第一次分发单号
            boolean sign = dcDrawdistributeInfoList.stream().allMatch(a -> ToolUtil.isEmpty(a.getDistCode()));
            DcDrawdistributeInfoEntity dcDrawdistributeInfo = dcDrawdistributeInfoList.get(0);
            if(ToolUtil.isEmpty(dcDrawdistributeInfo.getDistCode())){
                /*
                 * 1.设置分发单号
                 */
                BillCodeParam billCodeParam = BillCodeParam.build(DcDrawdistributeInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(dcDrawdistributeInfo, DcDrawdistributeInfoVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    /*
                     * 图纸签发设置分发单号
                     */
                    // 更新图纸签发的分发单号，根据图纸签发ID
                    update(
                            new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                                    .eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfo.getId())
                                    .set(DcDrawdistributeInfoEntity::getDistCode, billCode.getData())
                    );
                } else {
                    throw new RuntimeException("网络异常， 编码生成失败， 请稍后再试");
                }
                /*
                 * 2.减少库存量，只有图纸信息为纸质版的才能减少库存
                 *
                 */
                // 第一次打印（sign）
                if (sign) {
                    // 图纸签发-图纸信息
                    List<DcDrawdistributeDrawinfoEntity> dcDrawdistributeDrawinfoList = dcDrawdistributeDrawinfoMapper.selectList(
                            new QueryWrapper<DcDrawdistributeDrawinfoEntity>()
                                    .lambda()
                                    .eq(DcDrawdistributeDrawinfoEntity::getPid, dcDrawdistributeInfo.getId())
                                    .eq(DcDrawdistributeDrawinfoEntity::getDr, 0)
                    );
                    // 图纸签发-图纸信息数据是否为纸质版
                    boolean paperFlag = dcDrawdistributeDrawinfoList.stream().anyMatch(a -> {
                        try {
                            JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                            return
                                    DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"))
                                            && PaperFlagEnum.ARE.getCode().equals(a.getPaperFlag());
                        } catch (Exception e) {
                            return false;
                        }
                    });
                    // 图纸为纸质版（paperFlag）
                    if (paperFlag) {
                        // 减少库存量
                        reduceInventory(drwgrpId, dcDrawdistributeInfo.getId());
                    }
                }
            }
            // 更新图纸库中的图纸信息为已打印
            dcDrawInfoService.update(
                    new UpdateWrapper<DcDrawInfoEntity>().lambda()
                            .set(DcDrawInfoEntity::getPrintStatus, PrintStatusEnum.NOT_PRINT.getCode())
                            .eq(DcDrawInfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawInfoEntity::getDr, "0")
            );
            // 更新图纸签发中的图纸信息为已打印
            dcDrawdistributeDrawinfoService.update(
                    new UpdateWrapper<DcDrawdistributeDrawinfoEntity>().lambda()
                            .set(DcDrawdistributeDrawinfoEntity::getPrintStatus, PrintStatusEnum.NOT_PRINT.getCode())
                            .eq(DcDrawdistributeDrawinfoEntity::getDrwgrpId, drwgrpId)
                            .eq(DcDrawdistributeDrawinfoEntity::getDr, "0")
            );
        }
    }

    /**
     * 减少库存量
     *
     * @param drwgrpId         卷册ID
     * @param drawdistributeId 图纸签发ID
     */
    private void reduceInventory(Long drwgrpId, Long drawdistributeId) {
        /*
         * 减少库存量，根据图纸签发的签发信息的份数
         */
        // 图纸库信息
        DcDrwgrpInfoEntity dcDrwgrpInfo = dcDrwgrpInfoService.getOne(
                new QueryWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getDr, 0)
                        .eq(DcDrwgrpInfoEntity::getId, drwgrpId)
                        .last("LIMIT 1")
        );
        // 图纸签发-签发信息（一共签发的份数从这个里面计算）
        List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoList = dcDrawdistributeDrwgrpinfoMapper.selectList(
                new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, 0)
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, drawdistributeId)
        );
        // 签发份数
        int num = dcDrawdistributeDrwgrpinfoList.stream().mapToInt(DcDrawdistributeDrwgrpinfoEntity::getNum).sum();
        // 之前的库存量
        int surplusNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getSurplusNum()) ? dcDrwgrpInfo.getSurplusNum() : 0;
        if (surplusNum < num) {
            throw new RuntimeException("库存量不足，请控制签发份数");
        }
        // 库存量=之前的库存量-签发份数
        surplusNum = surplusNum - num;
        // 更新图纸库的库存量
        dcDrwgrpInfoService.update(
                new UpdateWrapper<DcDrwgrpInfoEntity>()
                        .lambda()
                        .set(DcDrwgrpInfoEntity::getSurplusNum, surplusNum)
                        .eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfo.getId())
                        .eq(DcDrwgrpInfoEntity::getDr, 0)
        );
        // 更新图纸签发的库存量
        update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .set(DcDrawdistributeInfoEntity::getSurplusNum, surplusNum)
                        .eq(DcDrawdistributeInfoEntity::getId, drawdistributeId)
                        .eq(DcDrawdistributeInfoEntity::getDr, 0)
        );
    }
}
