package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawingApplyForController;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpDrawMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForMapper;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawingApplyForService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.business.dc.vo.DcDrawingApplyForVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 图纸申请
 *
 * @author generator
 */
@Service("dcDrawingApplyForService")
public class DcDrawingApplyForServiceImpl extends BaseServiceImpl<DcDrawingApplyForMapper, DcDrawingApplyForEntity> implements IDcDrawingApplyForService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DcDrawingApplyForMapper dcDrawingApplyForMapper;
    @Autowired
    private DcDrawingApplyForDrwgrpDrawMapper dcDrawingApplyForDrwgrpDrawMapper;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private DcDrawingApplyForDrwgrpMapper dcDrawingApplyForDrwgrpMapper;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;

    @Override
    public void printDataDispose(List<Long> ids) {
        if (ToolUtil.isEmpty(ids)) {
            return;
        }
        for (Long id : ids) {
            DcDrawingApplyForEntity drawingApplyFor = getById(id);
            if (ToolUtil.isEmpty(drawingApplyFor.getDistCode())) {
                /*
                 * 减少库存量
                 */
                reduceInventory(drawingApplyFor);
                /*
                 * 生成分发单号
                 */
                BillCodeParam billCodeParam = BillCodeParam.build(DcDrawingApplyForController.BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(drawingApplyFor, DcDrawingApplyForVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    update(
                            new UpdateWrapper<DcDrawingApplyForEntity>().lambda()
                                    .eq(DcDrawingApplyForEntity::getId, id)
                                    .set(DcDrawingApplyForEntity::getDistCode, billCode.getData())
                                    .set(DcDrawingApplyForEntity::getDistUserCode, sessionManager.getUserContext().getUserId())
                                    .set(DcDrawingApplyForEntity::getDistUserName, sessionManager.getUserContext().getUserName())
                                    .set(DcDrawingApplyForEntity::getDistDate, new Date())
                    );
                } else {
                    throw new RuntimeException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
    }

    /**
     * 减少库存量
     *
     * @param drawingApplyFor 图纸申请信息
     */
    private void reduceInventory(DcDrawingApplyForEntity drawingApplyFor) {
        // 查询相同单据编码并且分发单号不为空的申请单
        List<DcDrawingApplyForEntity> drawingApplyForList = dcDrawingApplyForMapper.selectList(
                new QueryWrapper<DcDrawingApplyForEntity>()
                        .lambda()
                        .eq(DcDrawingApplyForEntity::getDr, 0)
                        .eq(DcDrawingApplyForEntity::getCode, drawingApplyFor.getCode())
                        .isNotNull(DcDrawingApplyForEntity::getDistCode)
        );
        if (ToolUtil.isNotEmpty(drawingApplyForList)) {
            return;
        }
        // 获取图纸申请-图纸卷册信息
        List<DcDrawingApplyForDrwgrpEntity> drwgrpList = dcDrawingApplyForDrwgrpMapper.selectList(
                new QueryWrapper<DcDrawingApplyForDrwgrpEntity>()
                        .lambda()
                        .eq(DcDrawingApplyForDrwgrpEntity::getDr, 0)
                        .eq(DcDrawingApplyForDrwgrpEntity::getPid, drawingApplyFor.getId())
        );
        if (ToolUtil.isEmpty(drwgrpList)) {
            return;
        }
        /*
         * 循环增加卷册的电子版图纸卷册套数
         */
        for (DcDrawingApplyForDrwgrpEntity drwgrp : drwgrpList) {
            // 获取图纸申请-图纸卷册-图纸信息
            List<DcDrawingApplyForDrwgrpDrawEntity> drawList = dcDrawingApplyForDrwgrpDrawMapper.selectList(
                    new QueryWrapper<DcDrawingApplyForDrwgrpDrawEntity>()
                            .lambda()
                            .eq(DcDrawingApplyForDrwgrpDrawEntity::getDr, 0)
                            .eq(DcDrawingApplyForDrwgrpDrawEntity::getPid, drwgrp.getId())
            );
            // 图纸签发-图纸信息数据是否为纸质版
            boolean paperFlag = drawList.stream().anyMatch(a -> {
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                    return
                            DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"))
                                    && PaperFlagEnum.ARE.getCode().equals(a.getPaperFlag());
                } catch (Exception e) {
                    return false;
                }
            });
            // 图纸为纸质版（paperFlag）
            if (paperFlag) {
                // 图纸库信息
                DcDrwgrpInfoEntity dcDrwgrpInfo = dcDrwgrpInfoService.getOne(
                        new QueryWrapper<DcDrwgrpInfoEntity>().lambda()
                                .eq(DcDrwgrpInfoEntity::getDr, 0)
                                .eq(DcDrwgrpInfoEntity::getId, drwgrp.getDrwgrpId())
                                .last("LIMIT 1")
                );
                // 申请份数
                int num = drawingApplyFor.getNum();
                // 之前的库存量
                int surplusNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getSurplusNum()) ? dcDrwgrpInfo.getSurplusNum() : 0;
                if (surplusNum < num) {
                    throw new RuntimeException("库存量不足，请控制签发份数");
                }
                // 库存量=之前的库存量-签发份数
                surplusNum = surplusNum - num;
                // 更新图纸库的库存量
                dcDrwgrpInfoService.update(
                        new UpdateWrapper<DcDrwgrpInfoEntity>()
                                .lambda()
                                .set(DcDrwgrpInfoEntity::getSurplusNum, surplusNum)
                                .eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfo.getId())
                                .eq(DcDrwgrpInfoEntity::getDr, 0)
                );
                // 更新图纸签发的库存量
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .set(DcDrawdistributeInfoEntity::getSurplusNum, surplusNum)
                                .eq(DcDrawdistributeInfoEntity::getDrwgrpId, dcDrwgrpInfo.getId())
                                .eq(DcDrawdistributeInfoEntity::getDr, 0)
                );
            }
        }
    }
}
