package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcFileissueRecordEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.controller.DcLssueAddressBookController;
import com.ejianc.business.dc.enumUtils.AddressBookTypeEnum;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.enumUtils.SubmitTypeEnum;
import com.ejianc.business.dc.mapper.DcFileissueRecordMapper;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcFileissueRecordService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.util.MessageUtil;
import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("dcFiledistributeCenter")
public class DcFiledistributeCenterBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    ActRuTaskService actRuTaskService;
    @Autowired
    IDcFiledistributeCenterService iDcFiledistributeCenterService;
    @Autowired
    IDcSendFileService iDcSendFileService;
    @Autowired
    IAttachmentService iAttachmentService;
    @Autowired
    private DcLssueAddressBookController dcLssueAddressBookController;
    @Autowired
    private IDcFileissueRecordService dcFileissueRecordService;
    @Autowired
    private DcFileissueRecordMapper dcFileissueRecordMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("beforeSubmitProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("afterSubmitProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        DcFiledistributeCenterEntity entity = iDcFiledistributeCenterService.selectById(billId);
        /*
         * 1.生成签发信息，根据项目和签发通讯录类型为“发文签发”查询签发通讯录中的明细
         */
        /*
         * 1.2 查询签发通讯录信息，根据图纸签发信息的项目ID和签发通讯录类型为“发文签发”
         */
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", entity.getProjectId());
        jsonObject.put("addressBookType", AddressBookTypeEnum.TWO.getCode());
        CommonResponse<IPage<DcLssueAddressBookVO>> commonResponse = dcLssueAddressBookController.refDcLssueAddressBookData(1, 1, jsonObject.toString(), null, null);
        /*
         * 1.3 转换签发通讯录明细类型为文件分发中心的签发信息对象类型
         */
        if (commonResponse.isSuccess() && ToolUtil.isNotEmpty(commonResponse.getData()) && ToolUtil.isNotEmpty(commonResponse.getData().getRecords())) {
            List<DcLssueAddressBookVO> dcLssueAddressBookList = commonResponse.getData().getRecords();
            List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList = dcLssueAddressBookList.get(0).getDcLssueAddressBookDetailList();
            List<DcFileissueRecordEntity> dcDrawdistributeDrwgrpinfoList = BeanMapper.mapList(dcLssueAddressBookDetailList, DcFileissueRecordEntity.class);
            /*
             * 签发列表去重，根据数据库旧数据
             */
            List<DcFileissueRecordEntity> oldDcDrawdistributeDrwgrpinfoList = dcFileissueRecordMapper.selectList(
                    new QueryWrapper<DcFileissueRecordEntity>()
                            .lambda()
                            .eq(DcFileissueRecordEntity::getDr, "0")
                            .eq(DcFileissueRecordEntity::getCenterId, entity.getId())
            );
            List<Long> receiveUserIdList = Lists.newArrayList();
            if (ToolUtil.isNotEmpty(oldDcDrawdistributeDrwgrpinfoList)) {
                receiveUserIdList = oldDcDrawdistributeDrwgrpinfoList.stream().map(DcFileissueRecordEntity::getReceiveUserId).collect(Collectors.toList());
            }
            List<DcFileissueRecordEntity> newDcDrawdistributeDrwgrpinfoList = Lists.newArrayList();
            for (DcFileissueRecordEntity dcFileissueRecord : dcDrawdistributeDrwgrpinfoList) {
                if (receiveUserIdList.contains(dcFileissueRecord.getReceiveUserId())) {
                    continue;
                }
                dcFileissueRecord.setId(null);
                dcFileissueRecord.setCenterId(entity.getId());
                newDcDrawdistributeDrwgrpinfoList.add(dcFileissueRecord);
            }
            // 保存文件分发中心的签发信息
            dcFileissueRecordService.saveBatch(newDcDrawdistributeDrwgrpinfoList);
        }
        /*
         * 2.根据外报类型更改不同的流程状态
         */
        if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
            // 文件分发中心-修改流程状态为“待上游回复”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.SIXTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.SIXTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待上游回复”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SIXTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SIXTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else if (SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
            // 文件分发中心-修改流程状态为“待签发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待签发”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
            // 文件分发中心-修改流程状态为“待签发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待签发”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else if (SubmitTypeEnum.D.getCode().equals(entity.getSubmitTypeCode())) {
            // 文件分发中心-修改流程状态为“待签发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待签发”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        }
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("beforeHasBpmBack，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("afterHasBpmBack，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        DcFiledistributeCenterEntity entity = iDcFiledistributeCenterService.selectById(billId);
        if ("node_c".equals(nodeType)) {
            // 文件分发中心-修改流程状态为“待升版”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.TWENTY_ONE.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.TWENTY_ONE.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待升版”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TWENTY_ONE.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TWENTY_ONE.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else {
            // 文件分发中心-修改流程状态为“审批驳回”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.TWENTY.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.TWENTY.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“审批驳回”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TWENTY.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TWENTY.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        }
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("beforeInApprovalBack，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId	//单据id
     * @param state		//单据状态
     * @param billTypeCode		//单据类型code
     * @param taskId		//该流程id
     * @param isEnd		//该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("afterInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode+"    taskId:"+taskId+"    isEnd:"+isEnd+"    sign:"+sign+"    other:"+other);
        DcFiledistributeCenterEntity entity = iDcFiledistributeCenterService.selectById(billId);
        if ("node_a".equals(nodeType)) {
            // 文件分发中心-修改流程状态为“待分发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.EIGHTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.EIGHTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待分发”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.EIGHTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.EIGHTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else if ("node_c".equals(nodeType)) {
            // 文件分发中心-修改流程状态为“待签发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“待签发”
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVENTEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVENTEEN.getName())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("beforeApprovalProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);

        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("afterApprovalProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        DcFiledistributeCenterEntity entity = iDcFiledistributeCenterService.selectById(billId);
        if ("node_b".equals(nodeType)) {
            // 文件分发中心-修改流程状态为“已分发”
            iDcFiledistributeCenterService.update(
                    new UpdateWrapper<DcFiledistributeCenterEntity>()
                            .lambda()
                            .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.NINETEEN.getCode())
                            .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.NINETEEN.getName())
                            .eq(DcFiledistributeCenterEntity::getDr, 0)
                            .eq(DcFiledistributeCenterEntity::getId, entity.getId())
            );
            // 发文管理-修改流程状态为“已分发”, 并回填发文管理的回复相关信息
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            // 流程状态
                            .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.NINETEEN.getCode())
                            .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.NINETEEN.getName())
                            // 上游回复信息
                            .set(DcSendFileEntity::getReplyDate, entity.getReplyDate())
                            .set(DcSendFileEntity::getReplyOpinion, entity.getReplyOpinion())
                            .set(DcSendFileEntity::getReplyAttachment, entity.getReplyAttachment())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        } else {
            // 回填发文管理的回复相关信息
            iDcSendFileService.update(
                    new UpdateWrapper<DcSendFileEntity>()
                            .lambda()
                            .set(DcSendFileEntity::getReplyDate, entity.getReplyDate())
                            .set(DcSendFileEntity::getReplyOpinion, entity.getReplyOpinion())
                            .set(DcSendFileEntity::getReplyAttachment, entity.getReplyAttachment())
                            .eq(DcSendFileEntity::getDr, 0)
                            .eq(DcSendFileEntity::getId, entity.getSourceId())
            );
        }
        /*
         * 对签发信息中的人员信息发送系统消息
         */
        // 文件分发中心-签发信息
        List<DcFileissueRecordEntity> oldDcDrawdistributeDrwgrpinfoList = dcFileissueRecordMapper.selectList(
                new QueryWrapper<DcFileissueRecordEntity>()
                        .lambda()
                        .eq(DcFileissueRecordEntity::getDr, "0")
                        .eq(DcFileissueRecordEntity::getCenterId, entity.getId())
        );
        String name = "";
        String path = "";
        if(SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
            name = "文件报审管理";
            path = "auditManage";
        } else if(SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
            name = "文件报备管理";
            path = "report";
        } else if(SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
            name = "内部文件管理";
            path = "innerDoc";
        } else if(SubmitTypeEnum.D.getCode().equals(entity.getSubmitTypeCode())) {
            name = "收文管理";
            path = "receipt";
        }

        String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};
        String[] receivers = oldDcDrawdistributeDrwgrpinfoList.stream().map(a -> a.getReceiveUserId().toString()).toArray(String[]::new);
        String msgType = "bpmcc";
        String subject = name + "----内部编号：" + entity.getFileInternalCode() + "，单据编号：~，外部编号：" + entity.getFileCode() + "，文件名称：" + entity.getFileName() + "】，已分发";
        String content = name + "----内部编号：" + entity.getFileInternalCode() + "，单据编号：~，外部编号：" + entity.getFileCode() + "，文件名称：" + entity.getFileName() + "】，已分发";
        String pcUrl = baseHost + "ejc-ztpcdc-frontend/#/" + path + "/card?id=" + entity.getId();
        String tenantId = InvocationInfoProxy.getTenantid().toString();
        Long sendUserId = InvocationInfoProxy.getUserid();
        PushMsgParameter msgParameter = MessageUtil.getPushMsgParameter(channel, receivers, msgType, subject, content, pcUrl, tenantId, sendUserId);
        pushMessageApi.pushMessage(msgParameter);

        DcSendFileEntity dcSendFile = iDcSendFileService.selectById(entity.getSourceId());
        if (ToolUtil.isEmpty(dcSendFile)) {
            return CommonResponse.success();
        }
        dcSendFile = iDcSendFileService.selectById(dcSendFile.getParentId());
        if (ToolUtil.isEmpty(dcSendFile)) {
            return CommonResponse.success();
        }
        // 发文管理-修改文件状态为“无效”
        iDcSendFileService.update(
                new UpdateWrapper<DcSendFileEntity>()
                        .lambda()
                        .set(DcSendFileEntity::getFileSts, "N")
                        .eq(DcSendFileEntity::getDr, 0)
                        .eq(DcSendFileEntity::getId, dcSendFile.getId())
        );
        // 文件分发中心-修改文件状态为“无效”
        iDcFiledistributeCenterService.update(
                new UpdateWrapper<DcFiledistributeCenterEntity>()
                        .lambda()
                        .set(DcFiledistributeCenterEntity::getFileSts, "N")
                        .eq(DcFiledistributeCenterEntity::getDr, 0)
                        .eq(DcFiledistributeCenterEntity::getSourceId, dcSendFile.getId())
        );
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("beforeAbstainingProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        logger.info("afterAbstainingProcessor，开始回写状态，nodeType:" + nodeType + "    billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }


}
