package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.bean.ActRuTaskPo;
import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.enumUtils.SubmitTypeEnum;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("dcSendFile") 
public class DcSendFileBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SessionManager sessionManager;

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IDcSendFileService iDcSendFileService;

	@Autowired
	private IDcFiledistributeCenterService iDcFiledistributeCenterService;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	IAttachmentService iAttachmentService;
	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
		} else {
			nodeType = "ERROR";
		}
		logger.info("afterSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcSendFileEntity entity = iDcSendFileService.selectById(billId);
		if (ToolUtil.isEmpty(entity)) {
			return CommonResponse.error("单据不存在！");
		}
		// 1.更新流程状态
		updateFlowStateSubmit(entity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
		} else {
			nodeType = "ERROR";
		}
		logger.info("afterHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcSendFileEntity entity = iDcSendFileService.selectById(billId);
		if (ToolUtil.isEmpty(entity)) {
			return CommonResponse.error("单据不存在！");
		}
		// 1.更新流程状态
		updateFlowStateCancel(nodeType, entity);
		return CommonResponse.success();
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 */
	@Override
	public  CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		int nodeNum;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
			nodeNum = actRuTaskPos.size();
		} else {
			nodeType = "ERROR";
			nodeNum = 0;
		}
		logger.info("afterInApprovalBack，开始回写状态，nodeType:"+nodeType+"		nodeNum"+nodeNum +"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode+"    taskId:"+taskId+"    isEnd:"+isEnd+"    sign:"+sign+"    other:"+other);
		DcSendFileEntity entity = iDcSendFileService.selectById(billId);
		if (ToolUtil.isEmpty(entity)) {
			return CommonResponse.error("单据不存在！");
		}
		// 1.更新流程状态
		updateFlowStateInApproval(nodeNum, nodeType, entity);
		return CommonResponse.success();
	}

	;
	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
		} else {
			nodeType = "ERROR";
		}
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		// 1.更新发文管理数据的文件状态为“有效”
		iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
				.eq(DcSendFileEntity::getId,billId)
				.set(DcSendFileEntity::getFileSts,"Y"));
		DcSendFileEntity dcSendFileEntity = iDcSendFileService.selectById(billId);
		logger.info(">>>>>DEBUG-STEP-1<<<<<，判断 ValidateUtil.isNotEmpty(dcSendFileEntity) :"+ValidateUtil.isNotEmpty(dcSendFileEntity));
		if (ValidateUtil.isNotEmpty(dcSendFileEntity) ) {
			logger.info(">>>>>DEBUG-STEP-2<<<<<，进入业务处理，ValidateUtil.isNotEmpty(dcSendFileEntity) :TRUE ");
			/*
			 * 2.生产文件分发中心数据
			 */
			long newId = IdWorker.getId();
			UserContext userContextCache =sessionManager.getUserContext();
			DcFiledistributeCenterEntity dcFiledistributeCenterEntity = new DcFiledistributeCenterEntity();
			dcFiledistributeCenterEntity.setId(newId);
			dcFiledistributeCenterEntity.setBidsection(dcSendFileEntity.getBidsection());
			dcFiledistributeCenterEntity.setContractId(dcSendFileEntity.getContractId());
			dcFiledistributeCenterEntity.setBillState(0);
			dcFiledistributeCenterEntity.setAttribute(dcSendFileEntity.getAttribute());
			dcFiledistributeCenterEntity.setFiletype(dcSendFileEntity.getFiletype());
			dcFiledistributeCenterEntity.setContractCode(dcSendFileEntity.getContractCode());
			dcFiledistributeCenterEntity.setContractName(dcSendFileEntity.getContractName());
			dcFiledistributeCenterEntity.setFileCode(dcSendFileEntity.getFileCode());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCostFlag(dcSendFileEntity.getCostFlag());
			dcFiledistributeCenterEntity.setSubmitType(dcSendFileEntity.getSubmitType());
			dcFiledistributeCenterEntity.setSubmitTypeCode(dcSendFileEntity.getSubmitTypeCode());
			dcFiledistributeCenterEntity.setCreateTime(new Date());
			dcFiledistributeCenterEntity.setCreateDeptId(userContextCache.getDeptId());
			dcFiledistributeCenterEntity.setCreateUserCode(userContextCache.getUserCode());
			dcFiledistributeCenterEntity.setSyncEsFlag(dcSendFileEntity.getSyncEsFlag());
			dcFiledistributeCenterEntity.setFileInternalCode(dcSendFileEntity.getFileInternalCode());
			dcFiledistributeCenterEntity.setFileSts(dcSendFileEntity.getFileSts());
			dcFiledistributeCenterEntity.setFileName(dcSendFileEntity.getFileName());
			dcFiledistributeCenterEntity.setFileVsn(dcSendFileEntity.getFileVsn());
			dcFiledistributeCenterEntity.setMgrp(dcSendFileEntity.getMgrp());
			dcFiledistributeCenterEntity.setMaterialType(dcSendFileEntity.getMaterialType());
			dcFiledistributeCenterEntity.setProjectCode(dcSendFileEntity.getProjectCode());
			dcFiledistributeCenterEntity.setOrgCode(dcSendFileEntity.getOrgCode());
			dcFiledistributeCenterEntity.setOrgId(dcSendFileEntity.getOrgId());
			dcFiledistributeCenterEntity.setSpecialty(dcSendFileEntity.getSpecialty());
			dcFiledistributeCenterEntity.setSys(dcSendFileEntity.getSys());
			dcFiledistributeCenterEntity.setSubItem(dcSendFileEntity.getSubItem());
			dcFiledistributeCenterEntity.setUnitProjCode(dcSendFileEntity.getUnitProjCode());
			dcFiledistributeCenterEntity.setUnitProjName(dcSendFileEntity.getUnitProjName());
			dcFiledistributeCenterEntity.setProjectName(dcSendFileEntity.getProjectName());
			dcFiledistributeCenterEntity.setProjectId(dcSendFileEntity.getProjectId());
			dcFiledistributeCenterEntity.setOrgName(dcSendFileEntity.getOrgName());
			dcFiledistributeCenterEntity.setParentOrgCode(dcSendFileEntity.getParentOrgCode());
			dcFiledistributeCenterEntity.setParentOrgId(dcSendFileEntity.getParentOrgId());
			dcFiledistributeCenterEntity.setParentOrgName(dcSendFileEntity.getParentOrgName());
			dcFiledistributeCenterEntity.setSubmitOrgId(dcSendFileEntity.getSubmitOrgId());
			dcFiledistributeCenterEntity.setSubmitOrgCode(dcSendFileEntity.getSubmitOrgCode());
			dcFiledistributeCenterEntity.setCenterId(dcSendFileEntity.getCenterId());
			dcFiledistributeCenterEntity.setAsBillState("N");
			dcFiledistributeCenterEntity.setSubmitOrgName(dcSendFileEntity.getSubmitOrgName());
			dcFiledistributeCenterEntity.setCopyOrgId(dcSendFileEntity.getCopyOrgId());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCopyOrgName(dcSendFileEntity.getCopyOrgName());
			dcFiledistributeCenterEntity.setFileDate(dcSendFileEntity.getSendDate());
			dcFiledistributeCenterEntity.setNeedReplyFlag(dcSendFileEntity.getNeedReplyFlag());
			dcFiledistributeCenterEntity.setNeedReplyDate(dcSendFileEntity.getNeedReplyDate());
			dcFiledistributeCenterEntity.setSecretFlag(dcSendFileEntity.getSecretFlag());
			dcFiledistributeCenterEntity.setSourceTable("dc_send_file");
			dcFiledistributeCenterEntity.setSourceId(dcSendFileEntity.getId());
			dcFiledistributeCenterEntity.setReceiveFileCode(dcSendFileEntity.getReceiveFileCode());
			dcFiledistributeCenterEntity.setCenterId(dcFiledistributeCenterEntity.getCenterId());
			dcFiledistributeCenterEntity.setDeptId(dcSendFileEntity.getDeptId());
			dcFiledistributeCenterEntity.setDeptShortName(dcSendFileEntity.getDeptShortName());
			logger.info(">>>>>DEBUG-STEP-3<<<<<，进入业务处理，dcSendFileEntity.getSubmitType() :"+dcSendFileEntity.getSubmitType());
			// 3.更新流程状态
			updateStateFinish(dcSendFileEntity, dcFiledistributeCenterEntity);
			// 2.1 保存
			iDcFiledistributeCenterService.save(dcFiledistributeCenterEntity);
			/*
			 * 4.复制附件到文件分发中心
			 */
			attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT230411000000004", "otherAttachment", String.valueOf(newId), "BT230411000000007", "otherAttachment");
		}else {
			return CommonResponse.error("未查询到对象，无法同步到分发中心");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 *  更新流程状态（提交回调方法）
	 * @param entity 发文管理数据
	 */
	private void updateFlowStateSubmit(DcSendFileEntity entity) {
		String fileTypeName = "";
		try {
			JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(entity.getFiletype() + "", "contractCategory");
			fileTypeName = ((JSONObject) specialtyReferValue.get(0)).getString("name");
		} catch (Exception e) {
			logger.error("文件类型 获取对应的参照数据失败！");
		}
		/*
		 * 根据文件类型流转不同审批分支
		 */
		if ("公司程序".equals(fileTypeName)) {
			// 修改流程状态为“部门主任审核中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ONE.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ONE.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("项目制度".equals(fileTypeName)) {
			// 修改流程状态为“技术组长审核中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.THREE.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.THREE.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("强制性条文实施计划".equals(fileTypeName)) {
			// 修改流程状态为“部门主任审核中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ONE.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ONE.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		}
	}

	/**
	 * 更新流程状态（审批中回调方法）
	 *
	 * @param nodeNum  审批节点数量
	 * @param nodeType 审批节点说明
	 * @param entity   发文管理数据
	 */
	private void updateFlowStateInApproval(int nodeNum, String nodeType, DcSendFileEntity entity) {
		String fileTypeName = "";
		try {
			JSONArray fileTypeRefer = ReferObjectUtil.getReferEntityValue(entity.getFiletype() + "", "contractCategory");
			fileTypeName = ((JSONObject) fileTypeRefer.get(0)).getString("name");
		} catch (Exception e) {
			logger.error("文件类型 获取对应的参照数据失败！");
		}
		/*
		 * 根据文件类型流转不同审批分支
		 */
		if ("公司程序".equals(fileTypeName)) {
			/*
			 * 根据流程节点说明 修改流程状态
			 */
			if ("a_dept_director".equals(nodeType)) {
				// 部门主任-审批
				// 修改流程状态为“会签中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIVE.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIVE.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("a_countersign".equals(nodeType) && nodeNum == 1) {
				// 审批(会签)-审批
				// 修改流程状态为“分管领导审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("a_branch_director".equals(nodeType)) {
				// 分管领导-审批
				// 修改流程状态为“文档审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ELEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ELEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("a_document".equals(nodeType)) {
				// 文档审核-审批
				/*
				 * 根据外报类型更改不同的流程状态
				 */
				if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报审中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.THIRTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.THIRTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报备中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FOURTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FOURTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“内部发文中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIFTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIFTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				}
			}
		} else if ("项目制度".equals(fileTypeName)) {
			/*
			 * 根据流程节点说明 修改流程状态
			 */
			if ("b_skill_director".equals(nodeType)) {
				// 技术组长-审批
				// 修改流程状态为“部门主任审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ONE.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ONE.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("b_dept_director".equals(nodeType)) {
				// 部门主任-审批
				// 修改流程状态为“会签中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIVE.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIVE.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("b_countersign".equals(nodeType) && nodeNum == 1) {
				// 审批(会签)-审批
				// 修改流程状态为“分管领导审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("b_branch_director".equals(nodeType)) {
				// 分管领导-审批
				// 修改流程状态为“文档审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ELEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ELEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("b_document".equals(nodeType)) {
				// 文档审核-审批
				/*
				 * 根据外报类型更改不同的流程状态
				 */
				if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报审中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.THIRTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.THIRTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报备中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FOURTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FOURTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“内部发文中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIFTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIFTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				}
			}
		} else if ("强制性条文实施计划".equals(fileTypeName)) {
			/*
			 * 根据流程节点说明 修改流程状态
			 */
			if ("c_dept_director".equals(nodeType)) {
				// 部门主任-审批
				// 修改流程状态为“分管领导审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("c_branch_director".equals(nodeType)) {
				// 分管领导-审批
				// 修改流程状态为“项目经理审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.NINE.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.NINE.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("c_project_director".equals(nodeType)) {
				// 项目经理-审批
				// 修改流程状态为“文档审核中”
				iDcSendFileService.update(
						new UpdateWrapper<DcSendFileEntity>()
								.lambda()
								.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.ELEVEN.getCode())
								.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.ELEVEN.getName())
								.eq(DcSendFileEntity::getId, entity.getId())
				);
			} else if ("c_document".equals(nodeType)) {
				// 文档审核-审批
				/*
				 * 根据外报类型更改不同的流程状态
				 */
				if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报审中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.THIRTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.THIRTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“报备中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FOURTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FOURTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				} else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
					// 修改流程状态为“内部发文中”
					iDcSendFileService.update(
							new UpdateWrapper<DcSendFileEntity>()
									.lambda()
									.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIFTEEN.getCode())
									.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIFTEEN.getName())
									.eq(DcSendFileEntity::getId, entity.getId())
					);
				}
			}
		}
	}

	/**
	 * 更新流程状态（撤回回调方法）
	 * @param nodeType 审批节点说明
	 * @param entity 发文管理数据
	 */
	private void updateFlowStateCancel(String nodeType, DcSendFileEntity entity) {
		/*
		 * 根据审批节点说明 更改流程状态
		 */
		if ("b_skill_director".equals(nodeType)) {
			// 修改流程状态为“技术组长退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FOUR.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FOUR.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("a_dept_director".equals(nodeType) || "b_dept_director".equals(nodeType)
				|| "c_dept_director".equals(nodeType)) {
			// 修改流程状态为“部门主任退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TWO.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TWO.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("a_countersign".equals(nodeType) || "b_countersign".equals(nodeType)) {
			// 修改流程状态为“会签退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.SIX.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.SIX.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("a_branch_director".equals(nodeType) || "b_branch_director".equals(nodeType)
				|| "c_branch_director".equals(nodeType)) {
			// 修改流程状态为“分管领导退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.EIGHT.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.EIGHT.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("c_project_director".equals(nodeType)) {
			// 修改流程状态为“项目经理退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TEN.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TEN.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		} else if ("a_document".equals(nodeType) || "b_document".equals(nodeType)
				|| "c_document".equals(nodeType)) {
			// 修改流程状态为“文档退回”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TWELVE.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TWELVE.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
		}
	}

	/**
	 * 更新流程状态（终审回调方法）
	 *
	 * @param entity 发文管理数据
	 */
	private void updateStateFinish(DcSendFileEntity entity, DcFiledistributeCenterEntity dcFiledistributeCenterEntity) {
		/*
		 * 根据外报类型更改不同的流程状态
		 */
		if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode())) {
			// 修改流程状态为“报审中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.THIRTEEN.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.THIRTEEN.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
			dcFiledistributeCenterEntity.setFlowState(FwFlowStateEnum.THIRTEEN.getCode());
			dcFiledistributeCenterEntity.setFlowStateName(FwFlowStateEnum.THIRTEEN.getName());
		} else if (SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
			// 修改流程状态为“报备中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FOURTEEN.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FOURTEEN.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
			dcFiledistributeCenterEntity.setFlowState(FwFlowStateEnum.FOURTEEN.getCode());
			dcFiledistributeCenterEntity.setFlowStateName(FwFlowStateEnum.FOURTEEN.getName());
		} else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
			// 修改流程状态为“内部发文中”
			iDcSendFileService.update(
					new UpdateWrapper<DcSendFileEntity>()
							.lambda()
							.set(DcSendFileEntity::getFlowState, FwFlowStateEnum.FIFTEEN.getCode())
							.set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.FIFTEEN.getName())
							.eq(DcSendFileEntity::getId, entity.getId())
			);
			dcFiledistributeCenterEntity.setFlowState(FwFlowStateEnum.FIFTEEN.getCode());
			dcFiledistributeCenterEntity.setFlowStateName(FwFlowStateEnum.FIFTEEN.getName());
		}
	}
}
