package com.ejianc.business.dc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.dc.bean.DcFileissueRecordEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 文件分发中心
 *
 * @author generator
 */
public class DcFiledistributeCenterVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String sourceTable; // 数据来源数据库表（收文界面不适用）
    private Long sourceId; // 数据来源数据库表主键id（收文界面不适用）
    private String fileCode; // 外部编码
    private String fileInternalCode; // 内部编码
    private String fileName; // 文件名称
    private String fileVsn; // 版本
    private String fileSts; // 文件状态
    private String fileStsCn; // 文件状态中文
    private Long fileSource; // 文件来源
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fileDate; // 文件日期（收文时为收文日期，发文时为发文日期）
    private Long submitType; // 外报类型
    private String submitOrgId; // 主送单位/部门id
    private String submitOrgCode; // 主送单位/部门编号
    private String submitOrgName; // 主送单位/部门
    private String copyOrgId; // 抄送单位/部门id
    private String copyOrgCode; // 抄送单位/部门编号
    private String copyOrgName; // 抄送单位/部门
    private Boolean needReplyFlag; // 是否需回复
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date needReplyDate; // 需回复日期
    private Boolean secretFlag; // 是否保密
    private Long bidsection; // 标段--字典pub_bidsection_code
    private Long mgrp; // 机组--字典pub_mgrp_code
    private Long specialty; // 专业--字典pub_specialty_code
    private Long sys; // 系统--字典pub_system_code
    private Long subItem; // 子项--字典pub_sub_item
    private Long materialType; // 材料类型--字典pub_material_type
    private String unitProjCode; // 单位工程代码
    private String unitProjName; // 单位工程名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Boolean costFlag; // 是否涉费
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date replyDate; // 回复日期
    private String replyOpinion; // 回复意见
    private String replyAttachment; // 回复附件
    private String fileAttachment; // 在线编辑自动生成的文件附件
    private String otherAttachment; // 其他附件
    private Long createDeptId; // 创建部门id
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Integer billState; // 单据状态
    private Long filetype; //文件类型
    private Long deptId; // 部门ID
    private String deptShortName; // 部门简称

    private Long attribute;  //文件属性

    private Long issueDeptId; // 签发部门

    private String receiveFileCode;//回复收文编号

    private String replyFileCode;//回复文件编号

    private Long centerId;//回复收文编号在分发中心表的主键id

    private String asBillState;//模拟流程结束
    private String flowState; // 流程状态
    private String flowStateName; // 流程状态名称
    private Long upstream; // 审批节点人员-上游回复
    private Long leadership; // 审批节点人员-领导签发
    private Long document; // 审批节点人员-文档分发
    private String submitTypeCode; // 外报类型编号

    private List<DcFileissueRecordVO> dcFileissueRecordList = new ArrayList<>(); // 文件签发信息

    public String getSubmitOrgId() {
        return submitOrgId;
    }

    @ReferDeserialTransfer
    public void setSubmitOrgId(String submitOrgId) {
        this.submitOrgId = submitOrgId;
    }

    public String getCopyOrgId() {
        return copyOrgId;
    }

    @ReferDeserialTransfer
    public void setCopyOrgId(String copyOrgId) {
        this.copyOrgId = copyOrgId;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSourceTable() {
        return sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getFileCode() {
        return fileCode;
    }

    public void setFileCode(String fileCode) {
        this.fileCode = fileCode;
    }

    public String getFileInternalCode() {
        return fileInternalCode;
    }

    public void setFileInternalCode(String fileInternalCode) {
        this.fileInternalCode = fileInternalCode;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileVsn() {
        return fileVsn;
    }

    public void setFileVsn(String fileVsn) {
        this.fileVsn = fileVsn;
    }

    public String getFileSts() {
        return fileSts;
    }

    public void setFileSts(String fileSts) {
        this.fileSts = fileSts;
    }


    public Date getFileDate() {
        return fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSubmitType() {
        return submitType;
    }

    @ReferDeserialTransfer
    public void setSubmitType(Long submitType) {
        this.submitType = submitType;
    }

    public String getSubmitOrgCode() {
        return submitOrgCode;
    }

    public void setSubmitOrgCode(String submitOrgCode) {
        this.submitOrgCode = submitOrgCode;
    }

    public String getSubmitOrgName() {
        return submitOrgName;
    }

    public void setSubmitOrgName(String submitOrgName) {
        this.submitOrgName = submitOrgName;
    }

    public String getCopyOrgCode() {
        return copyOrgCode;
    }

    public void setCopyOrgCode(String copyOrgCode) {
        this.copyOrgCode = copyOrgCode;
    }

    public String getCopyOrgName() {
        return copyOrgName;
    }

    public void setCopyOrgName(String copyOrgName) {
        this.copyOrgName = copyOrgName;
    }

    public Date getNeedReplyDate() {
        return needReplyDate;
    }

    public void setNeedReplyDate(Date needReplyDate) {
        this.needReplyDate = needReplyDate;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getBidsection() {
        return bidsection;
    }

    @ReferDeserialTransfer
    public void setBidsection(Long bidsection) {
        this.bidsection = bidsection;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSys() {
        return sys;
    }

    @ReferDeserialTransfer
    public void setSys(Long sys) {
        this.sys = sys;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSubItem() {
        return subItem;
    }

    @ReferDeserialTransfer
    public void setSubItem(Long subItem) {
        this.subItem = subItem;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMaterialType() {
        return materialType;
    }

    @ReferDeserialTransfer
    public void setMaterialType(Long materialType) {
        this.materialType = materialType;
    }

    public String getUnitProjCode() {
        return unitProjCode;
    }

    public void setUnitProjCode(String unitProjCode) {
        this.unitProjCode = unitProjCode;
    }

    public String getUnitProjName() {
        return unitProjName;
    }

    public void setUnitProjName(String unitProjName) {
        this.unitProjName = unitProjName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Boolean getNeedReplyFlag() {
        return needReplyFlag;
    }

    public void setNeedReplyFlag(Boolean needReplyFlag) {
        this.needReplyFlag = needReplyFlag;
    }

    public Boolean getSecretFlag() {
        return secretFlag;
    }

    public void setSecretFlag(Boolean secretFlag) {
        this.secretFlag = secretFlag;
    }

    public Boolean getCostFlag() {
        return costFlag;
    }

    public void setCostFlag(Boolean costFlag) {
        this.costFlag = costFlag;
    }

    public Date getReplyDate() {
        return replyDate;
    }

    public void setReplyDate(Date replyDate) {
        this.replyDate = replyDate;
    }

    public String getReplyOpinion() {
        return replyOpinion;
    }

    public void setReplyOpinion(String replyOpinion) {
        this.replyOpinion = replyOpinion;
    }

    public String getReplyAttachment() {
        return replyAttachment;
    }

    public void setReplyAttachment(String replyAttachment) {
        this.replyAttachment = replyAttachment;
    }

    public String getFileAttachment() {
        return fileAttachment;
    }

    public void setFileAttachment(String fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    public String getOtherAttachment() {
        return otherAttachment;
    }

    public void setOtherAttachment(String otherAttachment) {
        this.otherAttachment = otherAttachment;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCreateDeptId() {
        return createDeptId;
    }

    @ReferDeserialTransfer
    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "contractCategory")
    public Long getFiletype() {
        return filetype;
    }

    @ReferDeserialTransfer
    public void setFiletype(Long filetype) {
        this.filetype = filetype;
    }


    @ReferSerialTransfer(referCode = "contractCategory")
    public Long getAttribute() {
        return attribute;
    }

    @ReferDeserialTransfer
    public void setAttribute(Long attribute) {
        this.attribute = attribute;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getIssueDeptId() {
        return issueDeptId;
    }

    @ReferDeserialTransfer
    public void setIssueDeptId(Long issueDeptId) {
        this.issueDeptId = issueDeptId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getReceiveFileCode() {
        return receiveFileCode;
    }

    public void setReceiveFileCode(String receiveFileCode) {
        this.receiveFileCode = receiveFileCode;
    }
    @ReferSerialTransfer(referCode = "dc_filedistribute_center_ref")
    public Long getCenterId() {
        return centerId;
    }
    @ReferDeserialTransfer
    public void setCenterId(Long centerId) {
        this.centerId = centerId;
    }
    @ReferSerialTransfer(referCode = "Dc-drawSourceMaintenance-Menu-Refer")
    public Long getFileSource() {
        return fileSource;
    }
    @ReferDeserialTransfer
    public void setFileSource(Long fileSource) {
        this.fileSource = fileSource;
    }

    public String getReplyFileCode() {
        return replyFileCode;
    }

    public void setReplyFileCode(String replyFileCode) {
        this.replyFileCode = replyFileCode;
    }

    public List<DcFileissueRecordVO> getDcFileissueRecordList() {
        return dcFileissueRecordList;
    }

    public void setDcFileissueRecordList(List<DcFileissueRecordVO> dcFileissueRecordList) {
        this.dcFileissueRecordList = dcFileissueRecordList;
    }

    public String getFileStsCn() {
        return fileStsCn;
    }

    public void setFileStsCn(String fileStsCn) {
        this.fileStsCn = fileStsCn;
    }

    public String getAsBillState() {
        return asBillState;
    }

    public void setAsBillState(String asBillState) {
        this.asBillState = asBillState;
    }

    public String getFlowState() {
        return flowState;
    }

    public void setFlowState(String flowState) {
        this.flowState = flowState;
    }

    public String getFlowStateName() {
        return flowStateName;
    }

    public void setFlowStateName(String flowStateName) {
        this.flowStateName = flowStateName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getUpstream() {
        return upstream;
    }

    @ReferDeserialTransfer
    public void setUpstream(Long upstream) {
        this.upstream = upstream;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getLeadership() {
        return leadership;
    }

    @ReferDeserialTransfer
    public void setLeadership(Long leadership) {
        this.leadership = leadership;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDocument() {
        return document;
    }

    @ReferDeserialTransfer
    public void setDocument(Long document) {
        this.document = document;
    }

    public String getSubmitTypeCode() {
        return submitTypeCode;
    }

    public void setSubmitTypeCode(String submitTypeCode) {
        this.submitTypeCode = submitTypeCode;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptShortName() {
        return deptShortName;
    }

    public void setDeptShortName(String deptShortName) {
        this.deptShortName = deptShortName;
    }
}
