package com.ejianc.business.dc.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 文件分发中心
 *
 * @author generator
 */
@TableName("dc_filedistribute_center")
public class DcFiledistributeCenterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "source_table")
    private String sourceTable; // 数据来源数据库表（收文界面不适用）
    @TableField(value = "source_id")
    private Long sourceId; // 数据来源数据库表主键id（收文界面不适用）
    @TableField(value = "file_code")
    private String fileCode; // 外部编码
    @TableField(value = "file_internal_code")
    private String fileInternalCode; // 内部编码
    @TableField(value = "file_name")
    private String fileName; // 文件名称
    @TableField(value = "file_vsn")
    private String fileVsn; // 版本
    @TableField(value = "file_sts")
    private String fileSts; // 文件状态

    @TableField(value = "file_source")
    private Long fileSource; // 文件来源
    @TableField(value = "file_date")
    private Date fileDate; // 文件日期（收文时为收文日期，发文时为发文日期）
    @TableField(value = "bill_state")
    private Integer billState;
    @TableField(value = "submit_type")
    private Long submitType; // 外报类型
    @TableField(value = "submit_org_id")
    private String submitOrgId; // 主送单位/部门id
    @TableField(value = "submit_org_code")
    private String submitOrgCode; // 主送单位/部门编号
    @TableField(value = "submit_org_name")
    private String submitOrgName; // 主送单位/部门
    @TableField(value = "copy_org_id")
    private String copyOrgId; // 抄送单位/部门id
    @TableField(value = "copy_org_code")
    private String copyOrgCode; // 抄送单位/部门编号
    @TableField(value = "copy_org_name")
    private String copyOrgName; // 抄送单位/部门
    @TableField(value = "need_reply_flag")
    private Boolean needReplyFlag; // 是否需回复
    @TableField(value = "need_reply_date")
    private Date needReplyDate; // 需回复日期
    @TableField(value = "secret_flag")
    private Boolean secretFlag; // 是否保密
    @TableField(value = "bidsection")
    private Long bidsection; // 标段--字典pub_bidsection_code
    @TableField(value = "mgrp")
    private Long mgrp; // 机组--字典pub_mgrp_code
    @TableField(value = "specialty")
    private Long specialty; // 专业--字典pub_specialty_code
    @TableField(value = "sys")
    private Long sys; // 系统--字典pub_system_code
    @TableField(value = "sub_item")
    private Long subItem; // 子项--字典pub_sub_item
    @TableField(value = "material_type")
    private Long materialType; // 材料类型--字典pub_material_type
    @TableField(value = "unit_proj_code")
    private String unitProjCode; // 单位工程代码
    @TableField(value = "unit_proj_name")
    private String unitProjName; // 单位工程名称
    @TableField(value = "contract_id")
    private Long contractId; // 合同ID
    @TableField(value = "contract_code")
    private String contractCode; // 合同编号
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "cost_flag")
    private Boolean costFlag; // 是否涉费
    @TableField(value = "reply_date")
    private Date replyDate; // 回复日期
    @TableField(value = "reply_opinion")
    private String replyOpinion; // 回复意见
    @TableField(value = "reply_attachment")
    private String replyAttachment; // 回复附件
    @TableField(value = "file_attachment")
    private String fileAttachment; // 在线编辑自动生成的文件附件
    @TableField(value = "other_attachment")
    private String otherAttachment; // 其他附件
    @TableField(value = "create_dept_id")
    private Long createDeptId; // 创建部门id
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 所属组织id
    @TableField(value = "org_code")
    private String orgCode; // 组织编码
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value = "filetype")
    private Long filetype;
    @TableField(value = "attribute")
    private Long attribute;

    @TableField(value = "issue_dept_id")
    private Long issueDeptId;
    @TableField(value = "receive_file_code")
    private String receiveFileCode;//回复收文编号
    @TableField(value = "center_id")
    private Long centerId;//回复收文编号在分发中心表的主键id
    @TableField(value = "reply_file_code")
    private String replyFileCode;//回复文件编号
    @TableField(value = "as_bill_state")
    private String asBillState;//模拟流程结束
    @TableField(value="flow_state")
    private String flowState; // 流程状态
    @TableField(value="flow_state_name")
    private String flowStateName; // 流程状态名称
    @TableField(value="upstream")
    private Long upstream; // 审批节点人员-上游回复
    @TableField(value="leadership")
    private Long leadership; // 审批节点人员-领导签发
    @TableField(value="document")
    private Long document; // 审批节点人员-文档分发
    @TableField(value="submit_type_code")
    private String submitTypeCode; // 外报类型编号
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_short_name")
    private String deptShortName; // 部门简称
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类别
    @TableField(value="upgrade_state")
    private Long upgradeState; // 升版状态--字典dc_fw_upgrade_state
    @TableField(value="dist_user_code")
    private String distUserCode; // 分发人账号
    @TableField(value="dist_user_name")
    private String distUserName; // 分发人姓名
    @TableField(value="dist_time")
    private Date distTime; // 分发时间


    @TableField(exist = false)
    @SubEntity(serviceName = "dcFileissueRecordService", pidName = "centerId")
    private List<DcFileissueRecordEntity> dcFileissueRecordList = new ArrayList<>(); // 文件签发信息


    public String getSubmitOrgId() {
        return submitOrgId;
    }

    public void setSubmitOrgId(String submitOrgId) {
        this.submitOrgId = submitOrgId;
    }

    public String getCopyOrgId() {
        return copyOrgId;
    }

    public void setCopyOrgId(String copyOrgId) {
        this.copyOrgId = copyOrgId;
    }

    public String getSourceTable() {
        return sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getFileCode() {
        return fileCode;
    }

    public void setFileCode(String fileCode) {
        this.fileCode = fileCode;
    }

    public String getFileInternalCode() {
        return fileInternalCode;
    }

    public void setFileInternalCode(String fileInternalCode) {
        this.fileInternalCode = fileInternalCode;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileVsn() {
        return fileVsn;
    }

    public void setFileVsn(String fileVsn) {
        this.fileVsn = fileVsn;
    }

    public String getFileSts() {
        return fileSts;
    }

    public void setFileSts(String fileSts) {
        this.fileSts = fileSts;
    }


    public Date getFileDate() {
        return fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }


    public Long getSubmitType() {
        return submitType;
    }

    public void setSubmitType(Long submitType) {
        this.submitType = submitType;
    }

    public String getSubmitOrgCode() {
        return submitOrgCode;
    }

    public void setSubmitOrgCode(String submitOrgCode) {
        this.submitOrgCode = submitOrgCode;
    }

    public String getSubmitOrgName() {
        return submitOrgName;
    }

    public void setSubmitOrgName(String submitOrgName) {
        this.submitOrgName = submitOrgName;
    }

    public String getCopyOrgCode() {
        return copyOrgCode;
    }

    public void setCopyOrgCode(String copyOrgCode) {
        this.copyOrgCode = copyOrgCode;
    }

    public String getCopyOrgName() {
        return copyOrgName;
    }

    public void setCopyOrgName(String copyOrgName) {
        this.copyOrgName = copyOrgName;
    }

    public Boolean getNeedReplyFlag() {
        return needReplyFlag;
    }

    public void setNeedReplyFlag(Boolean needReplyFlag) {
        this.needReplyFlag = needReplyFlag;
    }

    public Boolean getSecretFlag() {
        return secretFlag;
    }

    public void setSecretFlag(Boolean secretFlag) {
        this.secretFlag = secretFlag;
    }

    public Boolean getCostFlag() {
        return costFlag;
    }

    public void setCostFlag(Boolean costFlag) {
        this.costFlag = costFlag;
    }

    public Date getNeedReplyDate() {
        return needReplyDate;
    }

    public void setNeedReplyDate(Date needReplyDate) {
        this.needReplyDate = needReplyDate;
    }

    public Long getBidsection() {
        return bidsection;
    }

    public void setBidsection(Long bidsection) {
        this.bidsection = bidsection;
    }

    public Long getMgrp() {
        return mgrp;
    }

    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    public Long getSpecialty() {
        return specialty;
    }

    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    public Long getSys() {
        return sys;
    }

    public void setSys(Long sys) {
        this.sys = sys;
    }

    public Long getSubItem() {
        return subItem;
    }

    public void setSubItem(Long subItem) {
        this.subItem = subItem;
    }

    public Long getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Long materialType) {
        this.materialType = materialType;
    }

    public String getUnitProjCode() {
        return unitProjCode;
    }

    public void setUnitProjCode(String unitProjCode) {
        this.unitProjCode = unitProjCode;
    }

    public String getUnitProjName() {
        return unitProjName;
    }

    public void setUnitProjName(String unitProjName) {
        this.unitProjName = unitProjName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Date getReplyDate() {
        return replyDate;
    }

    public void setReplyDate(Date replyDate) {
        this.replyDate = replyDate;
    }

    public String getReplyOpinion() {
        return replyOpinion;
    }

    public void setReplyOpinion(String replyOpinion) {
        this.replyOpinion = replyOpinion;
    }

    public String getReplyAttachment() {
        return replyAttachment;
    }

    public void setReplyAttachment(String replyAttachment) {
        this.replyAttachment = replyAttachment;
    }

    public String getFileAttachment() {
        return fileAttachment;
    }

    public void setFileAttachment(String fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    public String getOtherAttachment() {
        return otherAttachment;
    }

    public void setOtherAttachment(String otherAttachment) {
        this.otherAttachment = otherAttachment;
    }

    public Long getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }


    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getIssueDeptId() {
        return issueDeptId;
    }

    public void setIssueDeptId(Long issueDeptId) {
        this.issueDeptId = issueDeptId;
    }

    public Long getFiletype() {
        return filetype;
    }

    public void setFiletype(Long filetype) {
        this.filetype = filetype;
    }

    public Long getAttribute() {
        return attribute;
    }

    public void setAttribute(Long attribute) {
        this.attribute = attribute;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getReceiveFileCode() {
        return receiveFileCode;
    }

    public void setReceiveFileCode(String receiveFileCode) {
        this.receiveFileCode = receiveFileCode;
    }

    public Long getCenterId() {
        return centerId;
    }

    public void setCenterId(Long centerId) {
        this.centerId = centerId;
    }

    public String getReplyFileCode() {
        return replyFileCode;
    }

    public Long getFileSource() {
        return fileSource;
    }

    public void setFileSource(Long fileSource) {
        this.fileSource = fileSource;
    }

    public String getAsBillState() {
        return asBillState;
    }

    public void setAsBillState(String asBillState) {
        this.asBillState = asBillState;
    }

    public void setReplyFileCode(String replyFileCode) {
        this.replyFileCode = replyFileCode;
    }

    public List<DcFileissueRecordEntity> getDcFileissueRecordList() {
        return dcFileissueRecordList;
    }

    public void setDcFileissueRecordList(List<DcFileissueRecordEntity> dcFileissueRecordList) {
        this.dcFileissueRecordList = dcFileissueRecordList;
    }

    public String getFlowState() {
        return flowState;
    }

    public void setFlowState(String flowState) {
        this.flowState = flowState;
    }

    public String getFlowStateName() {
        return flowStateName;
    }

    public void setFlowStateName(String flowStateName) {
        this.flowStateName = flowStateName;
    }

    public Long getUpstream() {
        return upstream;
    }

    public void setUpstream(Long upstream) {
        this.upstream = upstream;
    }

    public Long getLeadership() {
        return leadership;
    }

    public void setLeadership(Long leadership) {
        this.leadership = leadership;
    }

    public Long getDocument() {
        return document;
    }

    public void setDocument(Long document) {
        this.document = document;
    }

    public String getSubmitTypeCode() {
        return submitTypeCode;
    }

    public void setSubmitTypeCode(String submitTypeCode) {
        this.submitTypeCode = submitTypeCode;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptShortName() {
        return deptShortName;
    }

    public void setDeptShortName(String deptShortName) {
        this.deptShortName = deptShortName;
    }

    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    public Long getUpgradeState() {
        return upgradeState;
    }

    public void setUpgradeState(Long upgradeState) {
        this.upgradeState = upgradeState;
    }

    public String getDistUserCode() {
        return distUserCode;
    }

    public void setDistUserCode(String distUserCode) {
        this.distUserCode = distUserCode;
    }

    public String getDistUserName() {
        return distUserName;
    }

    public void setDistUserName(String distUserName) {
        this.distUserName = distUserName;
    }

    public Date getDistTime() {
        return distTime;
    }

    public void setDistTime(Date distTime) {
        this.distTime = distTime;
    }
}
