package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName PrintStatusEnum
 * @Description 是否纸质版枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum PaperFlagEnum {
    // 是
    ARE("Y", "是"),
    // 否
    NO("N", "否");

    private final String code;
    private final String name;
    private static Map<String, PaperFlagEnum> enumMap = new HashMap();
    private static Map<String, PaperFlagEnum> enumNameMap = new HashMap();

    private PaperFlagEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static PaperFlagEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static PaperFlagEnum getEnumByName(String name) {
        return enumNameMap.get(name);
    }

    static {
        enumMap = EnumSet.allOf(PaperFlagEnum.class).stream().collect(Collectors.toMap(PaperFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
        enumNameMap = EnumSet.allOf(PaperFlagEnum.class).stream().collect(Collectors.toMap(PaperFlagEnum::getName, Function.identity(), (k1, k2) -> k2));
    }
}
