package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName SubmitTypeEnum
 * @Description 外报类型
 * @Author WC
 * @Date 2023/8/28 10:39
 * @Version 1.0
 **/
public enum SubmitTypeEnum {
    /**
     * 报审
     */
    A("A", "报审"),
    /**
     * 报备
     */
    B("B", "报备"),
    /**
     * 内部发布
     */
    C("C", "内部发布"),
    /**
     * 收文
     */
    D("D", "收文");

    private final String code;
    private final String name;
    private static final Map<String, SubmitTypeEnum> enumMap;

    SubmitTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SubmitTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(SubmitTypeEnum.class).stream().collect(Collectors.toMap(SubmitTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
