/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcSendFile"})
public class DcSendFileController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";
    @Autowired
    private IDcSendFileService service;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;
    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcSendFileVO> saveOrUpdate(@RequestBody DcSendFileVO saveOrUpdateVO) {
        CommonResponse<DcSendFileVO> response = this.service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/upgrade"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcSendFileVO> upgrade(@RequestBody DcSendFileVO voEntity) {
        DcSendFileEntity entity = (DcSendFileEntity)((Object)BeanMapper.map((Object)((Object)voEntity), DcSendFileEntity.class));
        long oldId = entity.getId();
        this.service.upgradeFileSts(entity);
        entity.setId(IdWorker.getId());
        entity.setFileSts("N");
        entity.setFlowState(FwFlowStateEnum.ZERO.getCode());
        entity.setFlowStateName(FwFlowStateEnum.ZERO.getName());
        entity.setBillState(null);
        entity.setCreateTime(null);
        entity.setSendDate(new Date());
        entity.setParentId(oldId);
        this.service.saveOrUpdate((Object)entity, false);
        DcSendFileVO vo = (DcSendFileVO)((Object)BeanMapper.map((Object)((Object)entity), DcSendFileVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcSendFileVO> queryDetail(Long id) {
        DcSendFileEntity entity = (DcSendFileEntity)((Object)this.service.selectById(id));
        DcSendFileVO vo = (DcSendFileVO)((Object)BeanMapper.map((Object)((Object)entity), DcSendFileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcSendFileVO> vos) {
        CommonResponse<String> response = this.service.delete(vos);
        return response;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcSendFileVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcSendFileVO.class));
        pageData.getRecords().stream().forEach(e -> e.setFileStsCn(DrwgrpStsEnum.getEnumByCode(e.getFileSts()).getName()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, DcSendFileVO.class);
            voList.forEach(vo -> vo.setFileStsCn(DrwgrpStsEnum.getEnumByCode(vo.getFileSts()).getName()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcSendFile-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcSendFileData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcSendFileVO>> refDcSendFileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcSendFileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/abolish"})
    @ResponseBody
    public CommonResponse<Void> abolish(@RequestBody List<Long> ids) {
        for (Long id : ids) {
            this.service.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcSendFileEntity::getFileSts, (Object)"S")).eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)id));
            this.dcFiledistributeCenterService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcFiledistributeCenterEntity::getFileSts, (Object)"S")).eq(BaseEntity::getDr, (Object)0)).eq(DcFiledistributeCenterEntity::getSourceId, (Object)id));
        }
        return CommonResponse.success((String)"\u4f5c\u5e9f\u6210\u529f\uff01");
    }
}

