/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.enumUtils.RuleElemType;
import com.ejianc.business.dc.enumUtils.SubmitTypeEnum;
import com.ejianc.business.dc.mapper.DcSendFileMapper;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dcSendFileService")
public class DcSendFileServiceImpl
extends BaseServiceImpl<DcSendFileMapper, DcSendFileEntity>
implements IDcSendFileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";
    @Autowired
    private IDcSendFileService service;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;
    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;

    @Override
    public boolean upgradeFileSts(DcSendFileEntity entity) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcSendFileEntity::getFlowState, (Object)FwFlowStateEnum.TWENTY_TWO.getCode())).set(DcSendFileEntity::getFlowStateName, (Object)FwFlowStateEnum.TWENTY_TWO.getName())).eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)entity.getId()));
        this.dcFiledistributeCenterService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcFiledistributeCenterEntity::getFlowState, (Object)FwFlowStateEnum.TWENTY_TWO.getCode())).set(DcFiledistributeCenterEntity::getFlowStateName, (Object)FwFlowStateEnum.TWENTY_TWO.getName())).eq(BaseEntity::getDr, (Object)0)).eq(DcFiledistributeCenterEntity::getSourceId, (Object)entity.getId()));
        return true;
    }

    @Override
    public CommonResponse<DcSendFileVO> saveOrUpdate(DcSendFileVO saveOrUpdateVO) {
        DcSendFileEntity entity = (DcSendFileEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcSendFileEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setId(IdWorker.getId());
        }
        if (ToolUtil.isEmpty(entity.getFlowState())) {
            entity.setFlowState(FwFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(FwFlowStateEnum.ZERO.getName());
        }
        BillCodeApiVO apiVO = new BillCodeApiVO();
        apiVO.setProjectId(entity.getProjectId());
        apiVO.setProjectCode(entity.getProjectCode());
        apiVO.setProjectName(entity.getProjectName());
        apiVO.setCategoryId(entity.getFiletype());
        ArrayList<BillCodeRuleSNVO> snVoList = new ArrayList<BillCodeRuleSNVO>();
        BillCodeRuleSNVO outSnVO = new BillCodeRuleSNVO();
        outSnVO.setSourcePid(entity.getId());
        outSnVO.setSourceCode(entity.getBillCode());
        outSnVO.setSourceType("BT230411000000004");
        outSnVO.setSourceTypeName("\u53d1\u6587\u7ba1\u7406");
        boolean wbSign = true;
        boolean nbSign = true;
        if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode()) || SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
            CommonResponse billCodeRule = this.billCodeRuleApi.getBillCodeRule(entity.getProjectId(), entity.getFiletype(), RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode());
            if (billCodeRule.isSuccess() && ToolUtil.isNotEmpty(billCodeRule.getData()) && ToolUtil.isNotEmpty(((BillCodeRuleVO)billCodeRule.getData()).getBillCodeRuleAttrList())) {
                AtomicInteger count = new AtomicInteger();
                List billCodeRuleAttrList = ((BillCodeRuleVO)billCodeRule.getData()).getBillCodeRuleAttrList().stream().filter(a -> {
                    if (RuleElemType.\u81ea\u5b9a\u4e49\u6d41\u6c34\u4f9d\u636e.getCode().equals(a.getRuleElemType())) {
                        count.getAndIncrement();
                        try {
                            return ToolUtil.isNotEmpty(this.getRuleElemValue(entity, a.getRuleElemCode()));
                        }
                        catch (Exception e) {
                            throw new BusinessException("\u53d6\u53f7\u9519\u8bef\uff1b\u8bf7\u68c0\u67e5\u53d6\u53f7\u89c4\u5219\u914d\u7f6e");
                        }
                    }
                    return false;
                }).collect(Collectors.toList());
                if (ToolUtil.isEmpty(billCodeRuleAttrList) || count.get() != billCodeRuleAttrList.size()) {
                    nbSign = false;
                }
            } else {
                nbSign = false;
            }
        } else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
            wbSign = false;
        }
        try {
            JSONArray referEntityValue;
            JSONObject specialtyRef;
            if (entity.getSpecialty() != null) {
                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSpecialty() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)specialtyReferValue.get(0);
                outSnVO.setRule05(specialtyRef.getString("code"));
            }
            if (entity.getMgrp() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMgrp() + ""), (String)"data-dictionary");
                JSONObject mgrpSpecialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule07(mgrpSpecialtyRef.getString("code"));
            }
            if (entity.getDeptShortName() != null) {
                outSnVO.setRule08(entity.getDeptShortName());
            }
            if (entity.getMainActivities() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMainActivities() + ""), (String)"data-dictionary-category");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule11(specialtyRef.getString("code"));
            }
            if (entity.getSubentryActivities() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSubentryActivities() + ""), (String)"data-dictionary-category");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule10(specialtyRef.getString("code"));
            }
            if (entity.getPrincipalItem() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getPrincipalItem() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule15(specialtyRef.getString("code"));
            }
            if (entity.getCmitTypeCode() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getCmitTypeCode() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule09(specialtyRef.getString("code"));
            }
            if (entity.getReceiverCmitCode() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getReceiverCmitCode() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule13(specialtyRef.getString("code"));
            }
            if (entity.getSys() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSys() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule14(specialtyRef.getString("code"));
            }
            if (entity.getSubItem() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSubItem() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule16(specialtyRef.getString("code"));
            }
            if (entity.getMaterialType() != null) {
                referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMaterialType() + ""), (String)"data-dictionary");
                specialtyRef = (JSONObject)referEntityValue.get(0);
                outSnVO.setRule17(specialtyRef.getString("code"));
            }
            if (wbSign) {
                outSnVO.setRuleType(RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode());
                snVoList.add(outSnVO);
            }
            if (nbSign) {
                BillCodeRuleSNVO outSnNb = (BillCodeRuleSNVO)BeanMapper.map((Object)outSnVO, BillCodeRuleSNVO.class);
                outSnNb.setRuleType(RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode());
                snVoList.add(outSnNb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("referCode:data-dictionary id\uff1a" + entity.getSpecialty() + "\u8f6c\u6362\u51fa\u9519");
        }
        apiVO.setSnList(snVoList);
        CommonResponse snCommonResponse = this.billCodeRuleApi.generateBillCode(apiVO);
        if (!snCommonResponse.isSuccess()) {
            return CommonResponse.error((String)snCommonResponse.getMsg());
        }
        List snList = ((BillCodeApiVO)snCommonResponse.getData()).getSnList();
        for (BillCodeRuleSNVO codeSnVO : snList) {
            if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) {
                entity.setFileCode(codeSnVO.getGenerateBillCode());
                continue;
            }
            if (!RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) continue;
            entity.setFileInternalCode(codeSnVO.getGenerateBillCode());
        }
        boolean b = this.service.saveOrUpdate((Object)entity, false);
        if (b) {
            BillCodeApiVO responseData = (BillCodeApiVO)snCommonResponse.getData();
            this.billCodeRuleApi.commitBillCode(responseData);
        }
        DcSendFileVO vo = (DcSendFileVO)((Object)BeanMapper.map((Object)((Object)entity), DcSendFileVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> delete(List<DcSendFileVO> vos) {
        HashMap sourceIds = new HashMap();
        ArrayList<Long> idList = new ArrayList<Long>();
        if (ListUtil.isNotEmpty(vos)) {
            for (DcSendFileVO vo : vos) {
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids", idList);
        CommonResponse commonResponse = this.billCodeRuleApi.releaseBillCode(sourceIds);
        if (commonResponse.isSuccess()) {
            this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    private Object getRuleElemValue(DcSendFileEntity entity, String ruleElemCode) throws Exception {
        Object value = null;
        if ("rule05".equals(ruleElemCode)) {
            value = entity.getSpecialty();
        } else if ("rule07".equals(ruleElemCode)) {
            value = entity.getMgrp();
        } else if ("rule08".equals(ruleElemCode)) {
            value = entity.getDeptShortName();
        } else if ("rule11".equals(ruleElemCode)) {
            value = entity.getMainActivities();
        } else if ("rule10".equals(ruleElemCode)) {
            value = entity.getSubentryActivities();
        } else if ("rule15".equals(ruleElemCode)) {
            value = entity.getPrincipalItem();
        } else if ("rule09".equals(ruleElemCode)) {
            value = entity.getCmitTypeCode();
        } else if ("rule13".equals(ruleElemCode)) {
            value = entity.getReceiverCmitCode();
        } else if ("rule14".equals(ruleElemCode)) {
            value = entity.getSys();
        } else if ("rule16".equals(ruleElemCode)) {
            value = entity.getSubItem();
        } else if ("rule17".equals(ruleElemCode)) {
            value = entity.getMaterialType();
        }
        return value;
    }
}

