/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcExcelMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.util.DetailIndexExcelReader;
import com.ejianc.business.dc.util.EJCDateUtil;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="labsubItemService")
public class ExcelItemServiceImpl
implements IExcelItemService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRefApi iRefApi;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DcExcelMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IExternalApi iExternalApi;

    @Override
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<DcDrwgrpInfoImportVO> errorList = new ArrayList<DcDrwgrpInfoImportVO>();
        List<Object> rtErrorList = new ArrayList();
        ArrayList<DcDrwgrpInfoImportVO> success500TmpList = new ArrayList<DcDrwgrpInfoImportVO>(500);
        HashMap selfCheckDcDrwgrp = new HashMap();
        HashMap<String, Integer> selfCheck = new HashMap<String, Integer>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            Map sourceUnitnameDataMap = this.mapper.queryMapSource().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                String drwgrpCode;
                Boolean flag = true;
                List datas = (List)result.get(i);
                DcDrwgrpInfoImportVO dcDrwgrpInfoVO = new DcDrwgrpInfoImportVO();
                StringBuilder errorMessage = new StringBuilder("");
                dcDrwgrpInfoVO.setId(IdWorker.getId());
                String projectName = (String)datas.get(0);
                if (ToolUtil.isNotEmpty(projectName)) {
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (ToolUtil.isNotEmpty(projectNameMap)) {
                        dcDrwgrpInfoVO.setProjectName((String)projectNameMap.get("name"));
                        dcDrwgrpInfoVO.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            dcDrwgrpInfoVO.setProjectId(Long.parseLong((String)id));
                        } else {
                            dcDrwgrpInfoVO.setProjectId((Long)id);
                        }
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            dcDrwgrpInfoVO.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                        } else {
                            dcDrwgrpInfoVO.setEngineeringTypeId((Long)engineeringTypeId);
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]" + projectName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                }
                if (ToolUtil.isEmpty(drwgrpCode = (String)datas.get(1))) {
                    errorMessage.append("[\u5377\u518c\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpCode(drwgrpCode);
                String drwgrpName = (String)datas.get(2);
                if (ToolUtil.isEmpty(drwgrpName)) {
                    errorMessage.append("[\u5377\u518c\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpName(drwgrpName);
                String drwgrpVsn = (String)datas.get(3);
                if (ToolUtil.isEmpty(drwgrpVsn)) {
                    errorMessage.append("[\u5377\u518c\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpVsn(drwgrpVsn);
                String drwgrpTypeName = (String)datas.get(4);
                CommonResponse drwgrpTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("dc_drwgrp_type");
                if (StringUtils.isBlank((CharSequence)drwgrpTypeName)) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u522b]").append(drwgrpTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else if (!drwgrpTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)drwgrpTypeDefdoc.getData()))) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u522b]").append(drwgrpTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)drwgrpTypeDefdoc.getData()).stream().filter(a -> drwgrpTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    dcDrwgrpInfoVO.setDrwgrpType(defdocDetailId);
                }
                dcDrwgrpInfoVO.setTransferCode((String)datas.get(5));
                String drawArriveDateStr = (String)datas.get(6);
                if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                    Date parse = EJCDateUtil.parseDate(drawArriveDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcDrwgrpInfoVO.setDrawArriveDate(parse);
                    } else {
                        errorMessage.append("[\u5230\u56fe\u65e5\u671f]" + drawArriveDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u5230\u56fe\u65e5\u671f]\u4e3a\u7a7a;");
                    flag = false;
                }
                String sourceUnitname = (String)datas.get(7);
                if (ToolUtil.isNotEmpty(sourceUnitname)) {
                    Map sourceUnitnameMap = (Map)sourceUnitnameDataMap.get(sourceUnitname);
                    if (ToolUtil.isNotEmpty(sourceUnitnameMap)) {
                        dcDrwgrpInfoVO.setSourceUnitname((String)sourceUnitnameMap.get("name"));
                        Object id = sourceUnitnameMap.get("id");
                        if (id instanceof String) {
                            dcDrwgrpInfoVO.setSourceUnitid(Long.parseLong((String)sourceUnitnameMap.get("id")));
                        } else {
                            dcDrwgrpInfoVO.setSourceUnitid((Long)sourceUnitnameMap.get("id"));
                        }
                    } else {
                        errorMessage.append("[\u8bbe\u8ba1\u5355\u4f4d]" + sourceUnitname + ":\u53c2\u7167\u9519\u8bef;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u8bbe\u8ba1\u5355\u4f4d]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drwgrpNum = (String)datas.get(8);
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(dcDrwgrpInfoVO.getEngineeringTypeId() + ""), (String)"support-defdoc");
                    if ("\u706b\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name")) && ToolUtil.isNotEmpty(drwgrpNum)) {
                        int i1 = Integer.parseInt(drwgrpNum);
                        dcDrwgrpInfoVO.setDrwgrpNum(i1);
                        dcDrwgrpInfoVO.setSurplusNum(i1);
                    } else if ("\u6838\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name"))) {
                        dcDrwgrpInfoVO.setDrwgrpNum(0);
                        dcDrwgrpInfoVO.setSurplusNum(0);
                    }
                }
                catch (Exception e3) {
                    errorMessage.append("[\u5377\u518c\u5957\u6570]").append(sourceUnitname).append(":\u6821\u9a8c\u662f\u5426\u706b\u7535\u6216\u6838\u7535 \u53c2\u7167\u9519\u8bef;");
                }
                dcDrwgrpInfoVO.setRemarks((String)datas.get(9));
                dcDrwgrpInfoVO.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(dcDrwgrpInfoVO.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                dcDrwgrpInfoVO.setOrgId((Long)stringStringMap.get("orgId"));
                dcDrwgrpInfoVO.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                dcDrwgrpInfoVO.setOrgName(((OrgVO)orgVO.getData()).getName());
                dcDrwgrpInfoVO.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                dcDrwgrpInfoVO.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                Integer integer = (Integer)selfCheck.get(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn());
                if (ToolUtil.isNotEmpty(integer)) {
                    errorMessage.append("excel\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e\u4e0e\u7b2c" + integer + "\u884c\u91cd\u590d;");
                    flag = false;
                } else {
                    selfCheck.put(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn(), i + 2);
                }
                if (flag.booleanValue()) {
                    success500TmpList.add(dcDrwgrpInfoVO);
                    if (success500TmpList.size() != 500) continue;
                    List dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                    List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = this.dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                        dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                            DcDrwgrpInfoImportVO map = (DcDrwgrpInfoImportVO)BeanMapper.map((Object)el, DcDrwgrpInfoImportVO.class);
                            selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                        });
                    }
                    success500TmpList.stream().forEach(el -> {
                        DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = (DcDrwgrpInfoImportVO)selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                        if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                            errorMessage.append("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                            el.setErrorMessage(errorMessage.toString());
                            errorList.add((DcDrwgrpInfoImportVO)el);
                        } else {
                            successList.add(el);
                        }
                    });
                    success500TmpList = new ArrayList(500);
                    continue;
                }
                dcDrwgrpInfoVO.setErrorMessage(errorMessage.toString());
                errorList.add(dcDrwgrpInfoVO);
            }
            if (ToolUtil.isNotEmpty(success500TmpList)) {
                List dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = this.dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                    dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                        DcDrwgrpInfoImportVO map = (DcDrwgrpInfoImportVO)BeanMapper.map((Object)el, DcDrwgrpInfoImportVO.class);
                        selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                    });
                }
                success500TmpList.stream().forEach(el -> {
                    DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = (DcDrwgrpInfoImportVO)selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                        el.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                        errorList.add((DcDrwgrpInfoImportVO)el);
                    } else {
                        successList.add(el);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrwgrpInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        return success;
    }

    @Override
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<DcDrawInfoImportVO> errorList = new ArrayList<DcDrawInfoImportVO>();
        List<Object> rtErrorList = new ArrayList();
        ArrayList<DcDrawInfoImportVO> success500TmpList = new ArrayList<DcDrawInfoImportVO>(500);
        HashMap<String, Integer> selfCheck = new HashMap<String, Integer>();
        HashMap<String, DcDrwgrpInfoEntity> selfCheckDb = new HashMap<String, DcDrwgrpInfoEntity>();
        ArrayList<DcDrwgrpInfoEntity> selfCheckDbList = new ArrayList<DcDrwgrpInfoEntity>();
        HashMap dcDrwgrpMap = new HashMap();
        StringBuilder comStr = new StringBuilder();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                Integer integer;
                DcDrwgrpInfoEntity dcDrwgrpInfoEntity;
                Boolean flag = true;
                List datas = (List)result.get(i);
                DcDrawInfoImportVO dcDrawInfoVO = new DcDrawInfoImportVO();
                StringBuilder errorMessage = new StringBuilder("");
                dcDrawInfoVO.setId(IdWorker.getId());
                dcDrawInfoVO.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                String projectName = (String)datas.get(0);
                if (ToolUtil.isNotEmpty(projectName)) {
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (ToolUtil.isNotEmpty(projectNameMap)) {
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            dcDrawInfoVO.setProjectId(Long.parseLong((String)id));
                        } else {
                            dcDrawInfoVO.setProjectId((Long)id);
                        }
                        dcDrawInfoVO.setProjectCode((String)projectNameMap.get("code"));
                        dcDrawInfoVO.setProjectName((String)projectNameMap.get("name"));
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]" + projectName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u9879\u76ee\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drawCode = (String)datas.get(1);
                if (ToolUtil.isEmpty(drawCode)) {
                    errorMessage.append("[\u56fe\u7eb8\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawCode(drawCode);
                String drawName = (String)datas.get(2);
                if (ToolUtil.isEmpty(drawName)) {
                    errorMessage.append("[\u56fe\u7eb8\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawName(drawName);
                String drawVsn = (String)datas.get(3);
                if (ToolUtil.isEmpty(drawVsn)) {
                    errorMessage.append("[\u56fe\u7eb8\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawVsn(drawVsn);
                String drwgrpCode = (String)datas.get(4);
                if (ToolUtil.isEmpty(drwgrpCode)) {
                    errorMessage.append("[\u5377\u518c\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrwgrpCode(drwgrpCode);
                String drwgrpVsn = (String)datas.get(5);
                if (ToolUtil.isEmpty(drwgrpVsn)) {
                    errorMessage.append("[\u5377\u518c\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrwgrpVsn(drwgrpVsn);
                dcDrawInfoVO.setTransferCode((String)datas.get(6));
                String paperFlag = (String)datas.get(7);
                if (ToolUtil.isEmpty(paperFlag)) {
                    errorMessage.append("[\u662f\u5426\u7eb8\u8d28\u7248]\u4e3a\u7a7a;");
                    flag = false;
                } else if (ToolUtil.isEmpty((Object)PaperFlagEnum.getEnumByName(paperFlag))) {
                    errorMessage.append("[\u662f\u5426\u7eb8\u8d28\u7248]\u5fc5\u987b\u4e3a\u201c\u662f\u201d\u6216\u201c\u5426\u201d;");
                    flag = false;
                }
                dcDrawInfoVO.setPaperFlag(PaperFlagEnum.getEnumByName(paperFlag).getCode());
                String drawArriveDateStr = (String)datas.get(8);
                if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                    Date parse = EJCDateUtil.parseDate(drawArriveDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcDrawInfoVO.setDrawArriveDate(parse);
                    } else {
                        errorMessage.append("[\u5230\u56fe\u65e5\u671f]" + drawArriveDateStr + ":\u683c\u5f0f\u9519\u8bef;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u5230\u56fe\u65e5\u671f]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drawTypeName = (String)datas.get(9);
                CommonResponse drawTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("draw_type");
                if (StringUtils.isBlank((CharSequence)drawTypeName)) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u578b]").append(drawTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else if (!drawTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)drawTypeDefdoc.getData()))) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u578b]").append(drawTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)drawTypeDefdoc.getData()).stream().filter(a -> drawTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    dcDrawInfoVO.setDrawType(defdocDetailId);
                }
                dcDrawInfoVO.setRowIndex(i + 2);
                if (ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpCode()) && ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpVsn()) && ToolUtil.isEmpty((Object)(dcDrwgrpInfoEntity = (DcDrwgrpInfoEntity)((Object)selfCheckDb.get(dcDrawInfoVO.getProjectId() + dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn()))))) {
                    DcDrwgrpInfoEntity dcDrwgrpInfoEntityTemp = new DcDrwgrpInfoEntity();
                    dcDrwgrpInfoEntityTemp.setProjectId(dcDrawInfoVO.getProjectId());
                    dcDrwgrpInfoEntityTemp.setDrwgrpCode(dcDrawInfoVO.getDrwgrpCode());
                    dcDrwgrpInfoEntityTemp.setDrwgrpVsn(dcDrawInfoVO.getDrwgrpVsn());
                    selfCheckDb.put(dcDrawInfoVO.getProjectId() + dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(), dcDrwgrpInfoEntityTemp);
                    selfCheckDbList.add(dcDrwgrpInfoEntityTemp);
                }
                if (ToolUtil.isNotEmpty(integer = (Integer)selfCheck.get(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn()))) {
                    errorMessage.append("excel\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e\u4e0e\u7b2c" + integer + "\u884c\u91cd\u590d;");
                    flag = false;
                } else {
                    selfCheck.put(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn(), i + 2);
                }
                if (flag.booleanValue()) {
                    success500TmpList.add(dcDrawInfoVO);
                    if (success500TmpList.size() != 500) continue;
                    HashMap dcDrawExist = new HashMap();
                    if (ToolUtil.isNotEmpty(selfCheckDbList)) {
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = this.dcDrwgrpInfoService.checkExist(selfCheckDbList);
                        selfCheckDbList = new ArrayList();
                        dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId()));
                    }
                    ArrayList<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                    success500TmpList.stream().forEach(es -> {
                        Long aLong = (Long)dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(aLong)) {
                            es.setErrorMessage("\u8be5\u56fe\u7eb8\u65e0\u5377\u518c\u4fe1\u606f;");
                        } else {
                            es.setDrwgrpId(aLong);
                            Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(es.getProjectId()));
                            es.setOrgId((Long)stringStringMap.get("orgId"));
                            es.setOrgName((String)stringStringMap.get("orgName"));
                            es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                            es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                            dcDrawInfoEntityList.add((DcDrawInfoEntity)((Object)BeanMapper.map((Object)es, DcDrawInfoEntity.class)));
                        }
                    });
                    if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                        List<DcDrawInfoEntity> dcDrawInfoEntityListDb = this.dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                        dcDrawInfoEntityListDb.stream().forEach(ce -> dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1));
                    }
                    success500TmpList.stream().forEach(ce -> {
                        if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                            if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                ce.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                                errorList.add((DcDrawInfoImportVO)ce);
                            } else {
                                successList.add(ce);
                            }
                        } else {
                            errorList.add((DcDrawInfoImportVO)ce);
                        }
                    });
                    success500TmpList = new ArrayList(500);
                    continue;
                }
                dcDrawInfoVO.setErrorMessage(errorMessage.toString());
                errorList.add(dcDrawInfoVO);
            }
            if (ToolUtil.isNotEmpty(success500TmpList)) {
                HashMap dcDrawExist = new HashMap();
                if (ToolUtil.isNotEmpty(selfCheckDbList)) {
                    List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = this.dcDrwgrpInfoService.checkExist(selfCheckDbList);
                    dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId()));
                }
                ArrayList<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                success500TmpList.stream().forEach(es -> {
                    Long aLong = (Long)dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                    if (ToolUtil.isEmpty(aLong)) {
                        es.setErrorMessage("\u8be5\u56fe\u7eb8\u65e0\u5377\u518c\u4fe1\u606f;");
                    } else {
                        es.setDrwgrpId(aLong);
                        Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(es.getProjectId()));
                        es.setOrgId((Long)stringStringMap.get("orgId"));
                        es.setOrgCode((String)stringStringMap.get("orgCode"));
                        es.setOrgName((String)stringStringMap.get("orgName"));
                        es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                        es.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                        es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                        dcDrawInfoEntityList.add((DcDrawInfoEntity)((Object)BeanMapper.map((Object)es, DcDrawInfoEntity.class)));
                    }
                });
                if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                    List<DcDrawInfoEntity> dcDrawInfoEntityListDb = this.dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                    dcDrawInfoEntityListDb.stream().forEach(ce -> dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1));
                }
                success500TmpList.stream().forEach(ce -> {
                    if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                        if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                            ce.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                            errorList.add((DcDrawInfoImportVO)ce);
                        } else {
                            successList.add(ce);
                        }
                    } else {
                        errorList.add((DcDrawInfoImportVO)ce);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrawInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        success.setMsg(comStr.toString());
        return success;
    }
}

