package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeDrwgrpinfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 图纸分发
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcDrawdistributeInfo")
public class DcDrawdistributeInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    public static final String BILL_CODE = "DC_DRAWDISTRIBUTE_INFO";//此处需要根据实际修改

    @Autowired
    private IDcDrawdistributeInfoService service;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> saveOrUpdate(@RequestBody DcDrawdistributeInfoVO saveOrUpdateVO) {
    	DcDrawdistributeInfoEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrawdistributeInfoEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            entity.setFlowState(TzFlowStateEnum.TWO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.TWO.getName());
            dcDrawInfoService.update(new UpdateWrapper<DcDrawInfoEntity>().lambda()
                    .eq(DcDrawInfoEntity::getDrwgrpId, saveOrUpdateVO.getDrwgrpId())
                    .set(DcDrawInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode()));
            entity.getDcDrawdistributeDrawinfoList().forEach(dcDrawdistributeDrawinfoEntity -> {
                dcDrawdistributeDrawinfoEntity.setId(null);
                dcDrawdistributeDrawinfoEntity.setCreateDeptId(entity.getCreateDeptId());
            });
        }
        List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoEntityList = saveOrUpdateVO.getDcDrawdistributeDrwgrpinfoEntityList();
        List<DcDrawdistributeDrwgrpinfoEntity> entityList = BeanMapper.mapList(dcDrawdistributeDrwgrpinfoEntityList, DcDrawdistributeDrwgrpinfoEntity.class);
        if (entityList.size() > 0) {
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : entityList) {
                dcDrawdistributeDrwgrpinfoEntity.setPid(entity.getId());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpId(entity.getDrwgrpId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgId(entity.getOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setOrgName(entity.getOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setProjectId(entity.getProjectId());
                dcDrawdistributeDrwgrpinfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawdistributeDrwgrpinfoEntity.setProjectName(entity.getProjectName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpName(entity.getDrwgrpName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpType(entity.getDrwgrpType());
                dcDrawdistributeDrwgrpinfoEntity.setMgrp(entity.getMgrp());
                dcDrawdistributeDrwgrpinfoEntity.setSpecialty(entity.getSpecialty());
            }
        }
        entity.setDcDrawdistributeDrwgrpinfoEntityList(entityList);
        service.saveOrUpdate(entity, false);
        entity.getDcDrawdistributeDrawinfoList().forEach(dcDrawdistributeDrawinfoEntity -> iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(dcDrawdistributeDrawinfoEntity.getDrawId()),
                "BT230602000000005",
                "otherAttachment",
                        String.valueOf(dcDrawdistributeDrawinfoEntity.getId()),
                "BT230602000000002",
                "otherAttachment"));
    	DcDrawdistributeInfoVO vo = BeanMapper.map(entity, DcDrawdistributeInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description fill_issue 签发回填
     */
    @RequestMapping(value = "/fill_issue", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> fill_issue(@RequestBody DcDrawdistributeInfoVO saveOrUpdateVO) {
        String operateType;
        DcDrawdistributeInfoEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrawdistributeInfoEntity.class);
//        entity.
//        (BillStateEnum.COMMITED_STATE.getBillStateCode());
        if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setDistCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
            operateType = "add";
        }else {
            operateType = "edit";
        }

        List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoEntityList = saveOrUpdateVO.getDcDrawdistributeDrwgrpinfoEntityList();
        List<DcDrawdistributeDrwgrpinfoEntity> entityList = BeanMapper.mapList(dcDrawdistributeDrwgrpinfoEntityList, DcDrawdistributeDrwgrpinfoEntity.class);
        if (entityList.size() > 0) {
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : entityList) {
                dcDrawdistributeDrwgrpinfoEntity.setPid(entity.getId());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpId(entity.getDrwgrpId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgId(entity.getOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setOrgName(entity.getOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setProjectId(entity.getProjectId());
                dcDrawdistributeDrwgrpinfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawdistributeDrwgrpinfoEntity.setProjectName(entity.getProjectName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpName(entity.getDrwgrpName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpType(entity.getDrwgrpType());
                dcDrawdistributeDrwgrpinfoEntity.setMgrp(entity.getMgrp());
                dcDrawdistributeDrwgrpinfoEntity.setSpecialty(entity.getSpecialty());
            }
//            dcDrawdistributeDrwgrpinfoService.saveOrUpdateBatch(entityList, entityList.size(), false);
        }
        entity.setDcDrawdistributeDrwgrpinfoEntityList(entityList);
        service.saveOrUpdate(entity, false);
        DcDrawdistributeInfoVO vo = BeanMapper.map(entity, DcDrawdistributeInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> queryDetail(Long id) {
    	DcDrawdistributeInfoEntity entity = service.selectById(id);
    	DcDrawdistributeInfoVO vo = BeanMapper.map(entity, DcDrawdistributeInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrawdistributeInfoVO> vos) {
        List<Long> idList = vos.stream().map(DcDrawdistributeInfoVO::getId).collect(Collectors.toList());
        List<DcDrawdistributeInfoEntity> entityList = service.list(new QueryWrapper<DcDrawdistributeInfoEntity>().lambda()
                .in(DcDrawdistributeInfoEntity::getId, idList));
        service.removeByIds(idList,true);
        dcDrawInfoService.update(new UpdateWrapper<DcDrawInfoEntity>().lambda()
                .in(DcDrawInfoEntity::getDrwgrpId, entityList.stream().map(DcDrawdistributeInfoEntity::getDrwgrpId).collect(Collectors.toList()))
                .set(DcDrawInfoEntity::getIssueSts, IssueStsEnum.ISSUE.getCode()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("drwgrpCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("drwgrpVsn");
        param.getFuzzyFields().add("drwgrpName");
        param.getFuzzyFields().add("distCode");
        param.getFuzzyFields().add("distUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcDrawdistributeInfoEntity> page = service.queryPage(param,false);
        IPage<DcDrawdistributeInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawdistributeInfoVO.class));
        pageData.getRecords().forEach(e->{
            String drwgrpStsCn = ToolUtil.isNotEmpty(DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts())) ? DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts()).getName() : "";
            e.setDrwgrpStsCn(drwgrpStsCn);
        });

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcDrawdistributeInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrawdistributeInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDcDrawdistributeInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeInfoVO>> refDcDrawdistributeInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcDrawdistributeInfoEntity> page = service.queryPage(param,false);
        IPage<DcDrawdistributeInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawdistributeInfoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 打印数据处理
     *
     * @param drwgrpIds 卷册ID
     * @return 返回对象
     */
    @RequestMapping(value = "/printDataDispose", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> printDataDispose(@RequestBody List<Long> drwgrpIds) {
        try {
            service.printDataDispose(drwgrpIds);
        } catch (RuntimeException e) {
            logger.error("图纸签发-打印数据处理失败，错误信息:", e);
            return CommonResponse.error(e.getMessage());
        }
        return CommonResponse.success();
    }
}
