package com.ejianc.business.dc.controller.bpm;

import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @ClassName BpmController
 * @Description
 * @Author WC
 * @Date 2023/9/8 10:13
 * @Version 1.0
 **/
@Controller
@RequestMapping("bpm")
public class BpmController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBpmApi iBpmApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value = "/batchSubmit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> batchSubmit(@RequestBody BatchSubmitVO vo) {
        if (ToolUtil.isEmpty(vo) || ToolUtil.isEmpty(vo.getDetailList()) || ToolUtil.isEmpty(vo.getBillTypeCode())) {
            return CommonResponse.error("批量提交失败！参数错误");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                Map<String, Object> submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", baseHost + "/ejc-ztpcdc-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "图纸签发" + detail.getId() + DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse<String> result = iBpmApi.doSubmit(submitParam);
                if (!result.isSuccess()) {
                    return CommonResponse.error(result.getMsg());
                }
            }
            return CommonResponse.success("批量提交成功！");
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("批量提交失败！错误信息：", e);
            }
            return CommonResponse.error("批量提交失败！");
        }
    }
}
