package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName PrintStatusEnum
 * @Description 签发通讯录类型枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum AddressBookTypeEnum {
    // 图纸签发
    ONE("0", "图纸签发"),
    // 发文签发
    TWO("1", "发文签发");

    private final String code;
    private final String name;
    private static Map<String, AddressBookTypeEnum> enumMap = new HashMap();

    private AddressBookTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static AddressBookTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(AddressBookTypeEnum.class).stream().collect(Collectors.toMap(AddressBookTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
