package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName DrawTypeEnum
 * @Description 图纸类型枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum DrawTypeEnum {
    // 目录
    CATALOGUE("A", "目录"),
    // 图纸
    DRAWING("B", "图纸"),
    // 设计变更
    DESIGN_CHANGE("C", "设计变更"),
    // 设计文件
    DESIGN_DOCUMENT("D", "设计文件");

    private final String code;
    private final String name;
    private static Map<String, DrawTypeEnum> enumMap = new HashMap();

    private DrawTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static DrawTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(DrawTypeEnum.class).stream().collect(Collectors.toMap(DrawTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
