package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName PrintStatusEnum
 * @Description 打印状态枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum PrintStatusEnum {
    // 未打印
    PRINT("0", "未打印"),
    // 已打印
    NOT_PRINT("1", "已打印");

    private final String code;
    private final String name;
    private static Map<String, PrintStatusEnum> enumMap = new HashMap();

    private PrintStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static PrintStatusEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(PrintStatusEnum.class).stream().collect(Collectors.toMap(PrintStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
