package com.ejianc.business.dc.enumUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName TzFlowStateEnum
 * @Description 图纸流程状态枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum TzFlowStateEnum {
    // 自由态
    ZERO("0", "自由态"),
    // 待技术录入
    ONE("1", "待技术录入"),
    // 待申请签发
    TWO("2", "待申请签发"),
    // 待签发
    THREE("3", "待签发"),
    // 待分发
    FOUR("4", "待分发"),
    // 已分发
    FIVE("5", "已分发");

    private final String code;
    private final String name;
    private static Map<String, TzFlowStateEnum> enumMap = new HashMap();

    private TzFlowStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static TzFlowStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(TzFlowStateEnum.class).stream().collect(Collectors.toMap(TzFlowStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }
}
