package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpDrawMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpMapper;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawingApplyForDrwgrpService;
import com.ejianc.business.dc.service.IDcDrawingApplyForService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("dcDrawingApplyFor") 
public class DcDrawingApplyForBpmServiceImpl implements ICommonBusinessService {
	/**
	 * 日志对象
	 */
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IDcDrawingApplyForService service;
	@Autowired
	private ActRuTaskService actRuTaskService;
	@Autowired
	private DcDrawingApplyForDrwgrpMapper dcDrawingApplyForDrwgrpMapper;
	@Autowired
	private DcDrawingApplyForDrwgrpDrawMapper dcDrawingApplyForDrwgrpDrawMapper;
	@Autowired
	private IDcDrwgrpInfoService dcDrwgrpInfoService;
	@Autowired
	private IDcDrawdistributeInfoService dcDrawdistributeInfoService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		if (logger.isInfoEnabled()) {
			logger.info("图纸申请-提交完回调，[billId:{},state:{},billTypeCode:{}]", billId, state, billTypeCode);
		}
		// 修改图纸申请-流程状态为“待签发”
		service.update(
				new UpdateWrapper<DcDrawingApplyForEntity>()
						.lambda()
						.set(DcDrawingApplyForEntity::getFlowState, TzFlowStateEnum.THREE.getCode())
						.set(DcDrawingApplyForEntity::getFlowStateName, TzFlowStateEnum.THREE.getName())
						.eq(DcDrawingApplyForEntity::getDr, 0)
						.eq(DcDrawingApplyForEntity::getId, billId)
		);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		if (logger.isInfoEnabled()) {
			logger.info("图纸申请-有审批流的撤回后回调，[billId:{},state:{},billTypeCode:{}]", billId, state, billTypeCode);
		}
		// 修改图纸申请-流程状态为“自由态”
		service.update(
				new UpdateWrapper<DcDrawingApplyForEntity>()
						.lambda()
						.set(DcDrawingApplyForEntity::getFlowState, TzFlowStateEnum.ZERO.getCode())
						.set(DcDrawingApplyForEntity::getFlowStateName, TzFlowStateEnum.ZERO.getName())
						.eq(DcDrawingApplyForEntity::getDr, 0)
						.eq(DcDrawingApplyForEntity::getId, billId)
		);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		if (logger.isInfoEnabled()) {
			logger.info("图纸申请-审批节点审批中时节点审批后回调，[billId:{},state:{},billTypeCode:{},taskId:{},isEnd:{},sign:{},other:{}]", billId, state, billTypeCode, taskId, isEnd, sign, other);
		}
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		if ("pass_a".equals(nodeType)) {
			// 修改图纸申请-流程状态为“待分发”
			service.update(
					new UpdateWrapper<DcDrawingApplyForEntity>()
							.lambda()
							.set(DcDrawingApplyForEntity::getFlowState, TzFlowStateEnum.FOUR.getCode())
							.set(DcDrawingApplyForEntity::getFlowStateName, TzFlowStateEnum.FOUR.getName())
							.eq(DcDrawingApplyForEntity::getDr, 0)
							.eq(DcDrawingApplyForEntity::getId, billId)
			);
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (logger.isInfoEnabled()) {
			logger.info("图纸申请-终审审核完回调，[billId:{},state:{},billTypeCode:{}]", billId, state, billTypeCode);
		}
		// 修改图纸申请-流程状态为“已分发”
		service.update(
				new UpdateWrapper<DcDrawingApplyForEntity>()
						.lambda()
						.set(DcDrawingApplyForEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
						.set(DcDrawingApplyForEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
						.eq(DcDrawingApplyForEntity::getDr, 0)
						.eq(DcDrawingApplyForEntity::getId, billId)
		);
		/*
		 * 增加图纸为电子版的卷册套数
		 */
		// 获取图纸申请信息
		DcDrawingApplyForEntity drawingApplyFor = service.getById(billId);
		// 获取图纸申请-图纸卷册信息
		List<DcDrawingApplyForDrwgrpEntity> drwgrpList = dcDrawingApplyForDrwgrpMapper.selectList(
				new QueryWrapper<DcDrawingApplyForDrwgrpEntity>()
						.lambda()
						.eq(DcDrawingApplyForDrwgrpEntity::getDr, 0)
						.eq(DcDrawingApplyForDrwgrpEntity::getPid, billId)
		);
		if (ToolUtil.isEmpty(drwgrpList)) {
			return CommonResponse.success();
		}
		/*
		 * 循环增加卷册的电子版图纸卷册套数
		 */
		for (DcDrawingApplyForDrwgrpEntity drwgrp : drwgrpList) {
			// 获取图纸申请-图纸卷册-图纸信息
			List<DcDrawingApplyForDrwgrpDrawEntity> drawList = dcDrawingApplyForDrwgrpDrawMapper.selectList(
					new QueryWrapper<DcDrawingApplyForDrwgrpDrawEntity>()
							.lambda()
							.eq(DcDrawingApplyForDrwgrpDrawEntity::getDr, 0)
							.eq(DcDrawingApplyForDrwgrpDrawEntity::getPid, drwgrp.getId())
			);
			if (ToolUtil.isEmpty(drawList)) {
				continue;
			}
			// 图纸申请-图纸卷册-图纸信息数据是否为电子版
			boolean paperFlag = drawList.stream().anyMatch(a -> {
				try {
					JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
					return
							DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"))
									&& PaperFlagEnum.NO.getCode().equals(a.getPaperFlag());
				} catch (Exception e) {
					return false;
				}
			});
			// 图纸为电子版（paperFlag）
			if (paperFlag) {
				// 图纸库信息
				DcDrwgrpInfoEntity dcDrwgrpInfo = dcDrwgrpInfoService.getOne(
						new QueryWrapper<DcDrwgrpInfoEntity>().lambda()
								.eq(DcDrwgrpInfoEntity::getDr, 0)
								.eq(DcDrwgrpInfoEntity::getId, drwgrp.getDrwgrpId())
								.last("LIMIT 1")
				);
				// 申请份数
				int num = drawingApplyFor.getNum();
				// 之前的卷册套数
				int drwgrpNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getDrwgrpNum()) ? dcDrwgrpInfo.getDrwgrpNum() : 0;
				// 卷册套数=之前的卷册套数-签发份数
				drwgrpNum = drwgrpNum + num;
				// 更新图纸库的卷册套数
				dcDrwgrpInfoService.update(
						new UpdateWrapper<DcDrwgrpInfoEntity>()
								.lambda()
								.set(DcDrwgrpInfoEntity::getDrwgrpNum, drwgrpNum)
								.eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfo.getId())
								.eq(DcDrwgrpInfoEntity::getDr, 0)
				);
				// 更新图纸签发的卷册套数
				dcDrawdistributeInfoService.update(
						new UpdateWrapper<DcDrawdistributeInfoEntity>()
								.lambda()
								.set(DcDrawdistributeInfoEntity::getDrwgrpNum, drwgrpNum)
								.eq(DcDrawdistributeInfoEntity::getDrwgrpId, drwgrp.getDrwgrpId())
								.eq(DcDrawdistributeInfoEntity::getDr, 0)
				);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		if (logger.isInfoEnabled()) {
			logger.info("图纸申请-弃审后事件回调，[billId:{},state:{},billTypeCode:{}]", billId, state, billTypeCode);
		}
		// 修改图纸申请-流程状态为“自由态”
		service.update(
				new UpdateWrapper<DcDrawingApplyForEntity>()
						.lambda()
						.set(DcDrawingApplyForEntity::getFlowState, TzFlowStateEnum.ZERO.getCode())
						.set(DcDrawingApplyForEntity::getFlowStateName, TzFlowStateEnum.ZERO.getName())
						.eq(DcDrawingApplyForEntity::getDr, 0)
						.eq(DcDrawingApplyForEntity::getId, billId)
		);
		return CommonResponse.success();
	}

}
