package com.ejianc.business.dc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 卷册签发记录/我的图纸
 *
 * @author generator
 */
public class DcDrawdistributeRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long drwgrpId; // 卷册id
    private String drwgrpCode; // 卷册编号
    private String drwgrpName; // 卷册名称
    private String drwgrpVsn; // 卷册版本
    private Long drwgrpType; // 图纸类别--字典dc_drwgrp_type
    private Integer num; // 份数
    private Long mgrp; // 机组--字典pub_mgrp_code
    private Long specialty; // 专业--字典pub_specialty_code
    private String receiveDeptName; // 接收人部门名称
    private Long receiveUserId; // 接收人员id
    private String receiveUserCode; // 接收人编号
    private String receiveUserName; // 接收人姓名
    private String recycleSts; // 是否回收
    private Long createDeptId; // 创建部门id
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String issueUserCode; // 签发人编号
    private String issueUserName; // 签发人姓名
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate; // 签发日期
    private Long sourceUnitid; // 设计单位id
    private String sourceUnitname; // 设计单位
    private Long sys; // 系统--字典pub_system_code
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date drawArriveDate; // 到图日期

    private String recycleStsCn;

    private List<DcDrawInfoVO> dcDrawInfoList = new ArrayList<>(); // 图纸签发/图纸申请-图纸信息

    public Long getDrwgrpId() {
        return drwgrpId;
    }

    public void setDrwgrpId(Long drwgrpId) {
        this.drwgrpId = drwgrpId;
    }

    public String getDrwgrpCode() {
        return drwgrpCode;
    }

    public void setDrwgrpCode(String drwgrpCode) {
        this.drwgrpCode = drwgrpCode;
    }

    public String getDrwgrpName() {
        return drwgrpName;
    }

    public void setDrwgrpName(String drwgrpName) {
        this.drwgrpName = drwgrpName;
    }

    public String getDrwgrpVsn() {
        return drwgrpVsn;
    }

    public void setDrwgrpVsn(String drwgrpVsn) {
        this.drwgrpVsn = drwgrpVsn;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDrwgrpType() {
        return drwgrpType;
    }

    @ReferDeserialTransfer
    public void setDrwgrpType(Long drwgrpType) {
        this.drwgrpType = drwgrpType;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    public String getReceiveDeptName() {
        return receiveDeptName;
    }

    public void setReceiveDeptName(String receiveDeptName) {
        this.receiveDeptName = receiveDeptName;
    }

    public Long getReceiveUserId() {
        return receiveUserId;
    }

    public void setReceiveUserId(Long receiveUserId) {
        this.receiveUserId = receiveUserId;
    }

    public String getReceiveUserCode() {
        return receiveUserCode;
    }

    public void setReceiveUserCode(String receiveUserCode) {
        this.receiveUserCode = receiveUserCode;
    }

    public String getReceiveUserName() {
        return receiveUserName;
    }

    public void setReceiveUserName(String receiveUserName) {
        this.receiveUserName = receiveUserName;
    }

    public String getRecycleSts() {
        return recycleSts;
    }

    public void setRecycleSts(String recycleSts) {
        this.recycleSts = recycleSts;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getCreateDeptId() {
        return createDeptId;
    }

    @ReferDeserialTransfer
    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getIssueUserCode() {
        return issueUserCode;
    }

    public void setIssueUserCode(String issueUserCode) {
        this.issueUserCode = issueUserCode;
    }

    public String getIssueUserName() {
        return issueUserName;
    }

    public void setIssueUserName(String issueUserName) {
        this.issueUserName = issueUserName;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    @ReferSerialTransfer(referCode = "Dc-drawSourceMaintenance-Menu-Refer")
    public Long getSourceUnitid() {
        return sourceUnitid;
    }

    @ReferDeserialTransfer
    public void setSourceUnitid(Long sourceUnitid) {
        this.sourceUnitid = sourceUnitid;
    }

    public String getSourceUnitname() {
        return sourceUnitname;
    }

    public void setSourceUnitname(String sourceUnitname) {
        this.sourceUnitname = sourceUnitname;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSys() {
        return sys;
    }

    @ReferDeserialTransfer
    public void setSys(Long sys) {
        this.sys = sys;
    }

    public Date getDrawArriveDate() {
        return drawArriveDate;
    }

    public void setDrawArriveDate(Date drawArriveDate) {
        this.drawArriveDate = drawArriveDate;
    }

    public String getRecycleStsCn() {
        return recycleStsCn;
    }

    public void setRecycleStsCn(String recycleStsCn) {
        this.recycleStsCn = recycleStsCn;
    }

    public List<DcDrawInfoVO> getDcDrawInfoList() {
        return dcDrawInfoList;
    }

    public void setDcDrawInfoList(List<DcDrawInfoVO> dcDrawInfoList) {
        this.dcDrawInfoList = dcDrawInfoList;
    }
}
