package com.ejianc.business.dc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 图纸申请-卷册信息
 *
 * @author generator
 *
 */
public class DcDrawingApplyForDrwgrpVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    private Long pid; // 图纸申请ID
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String drwgrpCode; // 卷册编号
    private Long drwgrpId; // 卷册ID
    private String drwgrpName; // 卷册名称
    private String drwgrpVsn; // 卷册版本
    private String drwgrpSts; // 卷册状态(字典dc_drwgrp_sts)
    private Long sourceUnitid; // 设计单位id
    private String sourceUnitname; // 设计单位
    private Long drwgrpType; // 图纸类别--字典dc_drwgrp_type
    private String transferCode; // 传递单号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date drawArriveDate; // 到图日期
    private Long mgrp; // 机组--字典pub_mgrp_code
    private Long specialty; // 专业--字典pub_specialty_code
    private String specialtyName; // 专业名称
    private Long sys; // 系统--字典pub_system_code
    private String sysName; // 系统名称
    private String remarks; // 备注
    private String issueSts; // 签发状态(字典dc_issue_sts)
    private String issueUserCode; // 签发人编号
    private String issueUserName; // 签发人姓名
    private Date issueDate; // 签发日期
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long engineeringTypeId; // 工程类别
    private Long subitem; // 子项--字典zx
    private String subitemName; // 子项名称
    private String drwgrpTypeName; // 图纸类别名称
    private String mgrpName; // 机组名称

    private List<DcDrawingApplyForDrwgrpDrawVO> dcDrawingApplyForDrwgrpDrawList = new ArrayList<>(); // 图纸申请-卷册信息-图纸信息

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getDrwgrpCode() {
        return drwgrpCode;
    }

    public void setDrwgrpCode(String drwgrpCode) {
        this.drwgrpCode = drwgrpCode;
    }
    public Long getDrwgrpId() {
        return drwgrpId;
    }

    public void setDrwgrpId(Long drwgrpId) {
        this.drwgrpId = drwgrpId;
    }
    public String getDrwgrpName() {
        return drwgrpName;
    }

    public void setDrwgrpName(String drwgrpName) {
        this.drwgrpName = drwgrpName;
    }
    public String getDrwgrpVsn() {
        return drwgrpVsn;
    }

    public void setDrwgrpVsn(String drwgrpVsn) {
        this.drwgrpVsn = drwgrpVsn;
    }
    public String getDrwgrpSts() {
        return drwgrpSts;
    }

    public void setDrwgrpSts(String drwgrpSts) {
        this.drwgrpSts = drwgrpSts;
    }
    @ReferSerialTransfer(referCode = "Dc-drawSourceMaintenance-Menu-Refer")
    public Long getSourceUnitid() {
        return sourceUnitid;
    }

    @ReferDeserialTransfer
    public void setSourceUnitid(Long sourceUnitid) {
        this.sourceUnitid = sourceUnitid;
    }
    public String getSourceUnitname() {
        return sourceUnitname;
    }

    public void setSourceUnitname(String sourceUnitname) {
        this.sourceUnitname = sourceUnitname;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDrwgrpType() {
        return drwgrpType;
    }

    @ReferDeserialTransfer
    public void setDrwgrpType(Long drwgrpType) {
        this.drwgrpType = drwgrpType;
    }
    public String getTransferCode() {
        return transferCode;
    }

    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }
    public Date getDrawArriveDate() {
        return drawArriveDate;
    }

    public void setDrawArriveDate(Date drawArriveDate) {
        this.drawArriveDate = drawArriveDate;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }
    public String getSpecialtyName() {
        return specialtyName;
    }

    public void setSpecialtyName(String specialtyName) {
        this.specialtyName = specialtyName;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSys() {
        return sys;
    }

    @ReferDeserialTransfer
    public void setSys(Long sys) {
        this.sys = sys;
    }
    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getIssueSts() {
        return issueSts;
    }

    public void setIssueSts(String issueSts) {
        this.issueSts = issueSts;
    }
    public String getIssueUserCode() {
        return issueUserCode;
    }

    public void setIssueUserCode(String issueUserCode) {
        this.issueUserCode = issueUserCode;
    }
    public String getIssueUserName() {
        return issueUserName;
    }

    public void setIssueUserName(String issueUserName) {
        this.issueUserName = issueUserName;
    }
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSubitem() {
        return subitem;
    }

    @ReferDeserialTransfer
    public void setSubitem(Long subitem) {
        this.subitem = subitem;
    }
    public String getSubitemName() {
        return subitemName;
    }

    public void setSubitemName(String subitemName) {
        this.subitemName = subitemName;
    }

    public List<DcDrawingApplyForDrwgrpDrawVO> getDcDrawingApplyForDrwgrpDrawList() {
        return dcDrawingApplyForDrwgrpDrawList;
    }

    public void setDcDrawingApplyForDrwgrpDrawList(List<DcDrawingApplyForDrwgrpDrawVO> dcDrawingApplyForDrwgrpDrawList) {
        this.dcDrawingApplyForDrwgrpDrawList = dcDrawingApplyForDrwgrpDrawList;
    }

    public String getDrwgrpTypeName() {
        return drwgrpTypeName;
    }

    public void setDrwgrpTypeName(String drwgrpTypeName) {
        this.drwgrpTypeName = drwgrpTypeName;
    }

    public String getMgrpName() {
        return mgrpName;
    }

    public void setMgrpName(String mgrpName) {
        this.mgrpName = mgrpName;
    }
}
