package com.ejianc.business.dc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;

/**
 * 签发通讯录
 * 
 * @author generator
 * 
 */
public class DcLssueAddressBookVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String addressBookName; // 签发通讯录名称
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long addressBookTypeId; // 签发通讯录类型ID--字典lssue_address_book_type
    private String addressBookTypeCode; // 签发通讯录类型编号
    private String addressBookTypeName; // 签发通讯录类型名称
    
    private List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList = new ArrayList<>(); // 签发通讯录-明细

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getAddressBookName() {
        return addressBookName;
    }

    public void setAddressBookName(String addressBookName) {
        this.addressBookName = addressBookName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<DcLssueAddressBookDetailVO> getDcLssueAddressBookDetailList() {
        return dcLssueAddressBookDetailList;
     }

     public void setDcLssueAddressBookDetailList(List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList) {
        this.dcLssueAddressBookDetailList = dcLssueAddressBookDetailList;
     }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAddressBookTypeId() {
        return addressBookTypeId;
    }

    @ReferDeserialTransfer
    public void setAddressBookTypeId(Long addressBookTypeId) {
        this.addressBookTypeId = addressBookTypeId;
    }

    public String getAddressBookTypeCode() {
        return addressBookTypeCode;
    }

    public void setAddressBookTypeCode(String addressBookTypeCode) {
        this.addressBookTypeCode = addressBookTypeCode;
    }

    public String getAddressBookTypeName() {
        return addressBookTypeName;
    }

    public void setAddressBookTypeName(String addressBookTypeName) {
        this.addressBookTypeName = addressBookTypeName;
    }
}
