package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcExcelMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.util.DetailIndexExcelReader;
import com.ejianc.business.dc.util.EJCDateUtil;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileImportVo;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpcdata.api.IExternalApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.business.dc.util.ToolUtil.isInteger;

/**
 * 劳务分包档案
 *
 * @author generator
 */
@Service("labsubItemService")
public class ExcelItemServiceImpl implements IExcelItemService {

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRefApi iRefApi;

    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;

    @Autowired
    private IDcDrawInfoService dcDrawInfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DcExcelMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;



    @Override
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {



        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrwgrpInfoImportVO> successList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> errorList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> rtErrorList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> success500TmpList = new ArrayList<>(500);


        Map<String, DcDrwgrpInfoImportVO> selfCheckDcDrwgrp = new HashMap<>();
        Map<String, Integer> selfCheck = new HashMap<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                    }
                    Map<String, Map<String,Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("projectId")), Function.identity(),(e1,e2)->e2)
                    );
                    Map<String, Map<String,Object>> sourceUnitnameDataMap = mapper.queryMapSource().stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );
                    List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                    CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                    if (response.isSuccess()) {
                        mapProjLocal = response.getData();
                    }
                    Map<String, Map<String,Object>> projDataMap = mapProjLocal.stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );



                    for (int i = 0; i < result.size(); i++) {
                        Boolean flag = true;
                        List<String> datas = result.get(i);
                        DcDrwgrpInfoImportVO dcDrwgrpInfoVO = new DcDrwgrpInfoImportVO();
                        StringBuilder errorMessage = new StringBuilder("");
                        dcDrwgrpInfoVO.setId(IdWorker.getId());

                        // projectName
                        String projectName = datas.get(0);
                        if (ToolUtil.isNotEmpty(projectName)) {
                            Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                            if (ToolUtil.isNotEmpty(projectNameMap)) {
                                dcDrwgrpInfoVO.setProjectName((String) projectNameMap.get("name"));
                                dcDrwgrpInfoVO.setProjectCode((String) projectNameMap.get("code"));
                                Object id = projectNameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setProjectId(Long.parseLong((String) id));
                                } else {
                                    dcDrwgrpInfoVO.setProjectId((Long) id);
                                }
                                Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                                if (engineeringTypeId instanceof String) {
                                    dcDrwgrpInfoVO.setEngineeringTypeId(Long.parseLong((String) engineeringTypeId));
                                } else {
                                    dcDrwgrpInfoVO.setEngineeringTypeId((Long) engineeringTypeId);
                                }
                            } else {
                                errorMessage.append("[项目名称]" + projectName + ":错误参照无法获取;");
                                flag = false;
                            }
                        }
                        // drwgrpCode
                        String drwgrpCode = datas.get(1);
                        if (ToolUtil.isEmpty(drwgrpCode)) {
                            errorMessage.append("[卷册编号]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpCode(drwgrpCode);
                        // drwgrpName
                        String drwgrpName = datas.get(2);
                        if (ToolUtil.isEmpty(drwgrpName)) {
                            errorMessage.append("[卷册名称]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpName(drwgrpName);
                        // drwgrpVsn
                        String drwgrpVsn = datas.get(3);
                        if (ToolUtil.isEmpty(drwgrpVsn)) {
                            errorMessage.append("[卷册版本]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpVsn(drwgrpVsn);
                        // drwgrpTypeName
                        String drwgrpTypeName = datas.get(4);
                        CommonResponse<List<DefdocDetailVO>> drwgrpTypeDefdoc = iDefdocApi.getDefDocByDefCode("dc_drwgrp_type");
                        if (StringUtils.isBlank(drwgrpTypeName)) {
                            errorMessage.append("[图纸类别]").append(drwgrpTypeName).append(":自定义档案错误;");
                            flag = false;
                        } else if (!drwgrpTypeDefdoc.isSuccess() || CollectionUtils.isEmpty(drwgrpTypeDefdoc.getData())) {
                            errorMessage.append("[图纸类别]").append(drwgrpTypeName).append(":自定义档案错误;");
                            flag = false;
                        } else {
                            Long defdocDetailId = drwgrpTypeDefdoc.getData().stream().filter(a -> drwgrpTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                            dcDrwgrpInfoVO.setDrwgrpType(defdocDetailId);
                        }
                        // TransferCode
                        dcDrwgrpInfoVO.setTransferCode(datas.get(5));
                        // drawArriveDateStr
                        String drawArriveDateStr = datas.get(6);
                        if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                            Date parse = EJCDateUtil.parseDate(drawArriveDateStr, EJCDateUtil.DATE);
                            if (ToolUtil.isNotEmpty(parse)) {
                                dcDrwgrpInfoVO.setDrawArriveDate(parse);
                            } else {
                                errorMessage.append("[到图日期]" + drawArriveDateStr + ":格式错误");
                                flag = false;
                            }
                        } else {
                            errorMessage.append("[到图日期]为空;");
                            flag = false;
                        }
                        // sourceUnitname
                        String sourceUnitname = datas.get(7);
                        if (ToolUtil.isNotEmpty(sourceUnitname)) {
                            Map<String, Object> sourceUnitnameMap = (Map<String, Object>) sourceUnitnameDataMap.get(sourceUnitname);
                            if (ToolUtil.isNotEmpty(sourceUnitnameMap)) {
                                dcDrwgrpInfoVO.setSourceUnitname((String) sourceUnitnameMap.get("name"));
                                Object id = sourceUnitnameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setSourceUnitid(Long.parseLong((String) sourceUnitnameMap.get("id")));
                                } else {
                                    dcDrwgrpInfoVO.setSourceUnitid((Long) sourceUnitnameMap.get("id"));
                                }

                            } else {
                                errorMessage.append("[设计单位]" + sourceUnitname + ":参照错误;");
                                flag = false;
                            }
                        } else {
                            errorMessage.append("[设计单位]为空;");
                            flag = false;
                        }
                        // drwgrpNum
                        String drwgrpNum = datas.get(8);
                        try {
                            JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(dcDrwgrpInfoVO.getEngineeringTypeId() + "", "support-defdoc");
                            if ("火电".equals(((JSONObject) specialtyReferValue.get(0)).get("name")) && ToolUtil.isNotEmpty(drwgrpNum)) {
                                int i1 = Integer.parseInt(drwgrpNum);
                                dcDrwgrpInfoVO.setDrwgrpNum(i1);
                                dcDrwgrpInfoVO.setSurplusNum(i1);
                            } else if ("核电".equals(((JSONObject) specialtyReferValue.get(0)).get("name"))) {
                                dcDrwgrpInfoVO.setDrwgrpNum(0);
                                dcDrwgrpInfoVO.setSurplusNum(0);
                            }
                        } catch (Exception e) {
                            errorMessage.append("[卷册套数]").append(sourceUnitname).append(":校验是否火电或核电 参照错误;");
                        }
                        dcDrwgrpInfoVO.setRemarks(datas.get(9));
                        dcDrwgrpInfoVO.setRowIndex((i + 2));
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(dcDrwgrpInfoVO.getProjectId()));
                        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById((Long) stringStringMap.get("orgId"));
                        if (!orgVO.isSuccess()) {
                            errorMessage.append("[项目无对应组织]");
                        }
                        dcDrwgrpInfoVO.setOrgId((Long) stringStringMap.get("orgId"));
                        dcDrwgrpInfoVO.setOrgCode(orgVO.getData().getCode());
                        dcDrwgrpInfoVO.setOrgName(orgVO.getData().getName());
                        dcDrwgrpInfoVO.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        dcDrwgrpInfoVO.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                        Integer integer = selfCheck.get(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isNotEmpty(integer)) {
                            errorMessage.append("excel中已存在该数据与第" + integer + "行重复;");
                            flag = false;
                        } else {
                            selfCheck.put(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn(), (i + 2));
                        }
                        if (flag) {
                            success500TmpList.add(dcDrwgrpInfoVO);
                            if (success500TmpList.size() == 500) {
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                                if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                                    dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                        DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                        selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                                    });
                                }
                                success500TmpList.stream().forEach(el -> {
                                    DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                                        errorMessage.append("数据库中已存在该数据;");
                                        el.setErrorMessage(errorMessage.toString());
                                        errorList.add(el);
                                    } else {
                                        successList.add(el);
                                    }
                                });
                                success500TmpList = new ArrayList<DcDrwgrpInfoImportVO>(500);
                            }
                        } else {
                            dcDrwgrpInfoVO.setErrorMessage(errorMessage.toString());
                            errorList.add(dcDrwgrpInfoVO);
                        }
                    }
                    if (ToolUtil.isNotEmpty(success500TmpList)) {
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                        if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                            dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                            });
                        }
                        success500TmpList.stream().forEach(el -> {
                            DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                            if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                                el.setErrorMessage("数据库中已存在该数据;");
                                errorList.add(el);
                            } else {
                                successList.add(el);
                            }
                        });
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrwgrpInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        return success;
    }
    @Override
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrawInfoImportVO> successList = new ArrayList<>();
        List<DcDrawInfoImportVO> errorList = new ArrayList<>();
        List<DcDrawInfoImportVO> rtErrorList = new ArrayList<>();
        List<DcDrawInfoImportVO> success500TmpList = new ArrayList<>(500);
        Map<String, Integer> selfCheck = new HashMap<>();
        Map<String, DcDrwgrpInfoEntity> selfCheckDb = new HashMap<>();
        List<DcDrwgrpInfoEntity> selfCheckDbList = new ArrayList<>();
        Map<String, Long> dcDrwgrpMap = new HashMap<String, Long>();
        StringBuilder comStr = new StringBuilder();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                }
                Map<String, Map<String,Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("projectId")), Function.identity(),(e1,e2)->e2)
                );
                List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                if (response.isSuccess()) {
                    mapProjLocal = response.getData();
                }
                Map<String, Map<String,Object>> projDataMap = mapProjLocal.stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );
                for (int i = 0; i < result.size(); i++) {
                    Boolean flag = true;
                    List<String> datas = result.get(i);
                    DcDrawInfoImportVO dcDrawInfoVO = new DcDrawInfoImportVO();
                    StringBuilder errorMessage = new StringBuilder("");
                    dcDrawInfoVO.setId(IdWorker.getId());
                    // 打印状态：默认未打印
                    dcDrawInfoVO.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                    dcDrawInfoVO.setCheckState("N");
                    // projectName
                    String projectName = datas.get(0);
                    if (ToolUtil.isNotEmpty(projectName)) {
                        Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                        if (ToolUtil.isNotEmpty(projectNameMap)) {
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                dcDrawInfoVO.setProjectId(Long.parseLong((String) id));
                            } else {
                                dcDrawInfoVO.setProjectId((Long) id);
                            }
                            dcDrawInfoVO.setProjectCode((String) projectNameMap.get("code"));
                            dcDrawInfoVO.setProjectName((String) projectNameMap.get("name"));
                        } else {
                            errorMessage.append("[项目名称]" + projectName + ":错误参照无法获取;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[项目名称]为空;");
                        flag = false;
                    }
                    // drawCode
                    String drawCode = datas.get(1);
                    if (ToolUtil.isEmpty(drawCode)) {
                        errorMessage.append("[图纸编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawCode(drawCode);

                    // drawName
                    String drawName = datas.get(2);
                    if (ToolUtil.isEmpty(drawName)) {
                        errorMessage.append("[图纸名称]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawName(drawName);
                    // drawVsn
                    String drawVsn = datas.get(3);
                    if (ToolUtil.isEmpty(drawVsn)) {
                        errorMessage.append("[图纸版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawVsn(drawVsn);
                    // drwgrpCode
                    String drwgrpCode = datas.get(4);
                    if (ToolUtil.isEmpty(drwgrpCode)) {
                        errorMessage.append("[卷册编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpCode(drwgrpCode);
                    // drwgrpVsn
                    String drwgrpVsn = datas.get(5);
                    if (ToolUtil.isEmpty(drwgrpVsn)) {
                        errorMessage.append("[卷册版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpVsn(drwgrpVsn);
                    // TransferCode
                    dcDrawInfoVO.setTransferCode(datas.get(6));
                    // paperFlag
                    String paperFlag = datas.get(7);
                    if (ToolUtil.isEmpty(paperFlag)) {
                        errorMessage.append("[是否纸质版]为空;");
                        flag = false;
                    } else if (ToolUtil.isEmpty(PaperFlagEnum.getEnumByName(paperFlag))) {
                        errorMessage.append("[是否纸质版]必须为“是”或“否”;");
                        flag = false;
                    }
                    dcDrawInfoVO.setPaperFlag(PaperFlagEnum.getEnumByName(paperFlag).getCode());
                    // drawArriveDateStr
                    String drawArriveDateStr = datas.get(8);
                    if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                        Date parse = EJCDateUtil.parseDate(drawArriveDateStr, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            dcDrawInfoVO.setDrawArriveDate(parse);
                        } else {
                            errorMessage.append("[到图日期]" + drawArriveDateStr + ":格式错误;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[到图日期]为空;");
                        flag = false;
                    }
                    // drawTypeName
                    String drawTypeName = datas.get(9);
                    CommonResponse<List<DefdocDetailVO>> drawTypeDefdoc = iDefdocApi.getDefDocByDefCode("draw_type");
                    if (StringUtils.isBlank(drawTypeName)) {
                        errorMessage.append("[图纸类型]").append(drawTypeName).append(":自定义档案错误;");
                        flag = false;
                    } else if (!drawTypeDefdoc.isSuccess() || CollectionUtils.isEmpty(drawTypeDefdoc.getData())) {
                        errorMessage.append("[图纸类型]").append(drawTypeName).append(":自定义档案错误;");
                        flag = false;
                    } else {
                        Long defdocDetailId = drawTypeDefdoc.getData().stream().filter(a -> drawTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        dcDrawInfoVO.setDrawType(defdocDetailId);
                    }
                    dcDrawInfoVO.setRowIndex((i + 2));
                    if (ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpCode()) && ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpVsn())) {
                        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = selfCheckDb.get(dcDrawInfoVO.getProjectId()+dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(dcDrwgrpInfoEntity)) {
                            DcDrwgrpInfoEntity dcDrwgrpInfoEntityTemp = new DcDrwgrpInfoEntity();
                            dcDrwgrpInfoEntityTemp.setProjectId(dcDrawInfoVO.getProjectId());
                            dcDrwgrpInfoEntityTemp.setDrwgrpCode(dcDrawInfoVO.getDrwgrpCode());
                            dcDrwgrpInfoEntityTemp.setDrwgrpVsn(dcDrawInfoVO.getDrwgrpVsn());
                            selfCheckDb.put(dcDrawInfoVO.getProjectId()+dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(), dcDrwgrpInfoEntityTemp);
                            selfCheckDbList.add(dcDrwgrpInfoEntityTemp);
                        }
                    }
                    Integer integer = selfCheck.get(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn());
                    if (ToolUtil.isNotEmpty(integer)) {
                        errorMessage.append("excel中已存在该数据与第" + integer + "行重复;");
                        flag = false;
                    } else {
                        selfCheck.put(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn(), (i + 2));
                    }
                    if (flag) {
                        success500TmpList.add(dcDrawInfoVO);
                        if (success500TmpList.size() == 500) {
                            Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                            if (ToolUtil.isNotEmpty(selfCheckDbList)){
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                                selfCheckDbList = new ArrayList<>();
                                dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> {
                                    dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId());
                                });
                            }
                            List<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                            success500TmpList.stream().forEach(es -> {
                                Long aLong = dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                                if (ToolUtil.isEmpty(aLong)) {
                                    es.setErrorMessage("该图纸无卷册信息;");
                                } else {
                                    es.setDrwgrpId(aLong);
                                    Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(es.getProjectId()));
                                    es.setOrgId((Long) stringStringMap.get("orgId"));
                                    es.setOrgName((String)stringStringMap.get("orgName"));
                                    es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                                    es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                                    dcDrawInfoEntityList.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                                }
                            });
                            if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                                List<DcDrawInfoEntity> dcDrawInfoEntityListDb = dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                                dcDrawInfoEntityListDb.stream().forEach(ce -> {
                                    dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1);
                                });
                            }
                            success500TmpList.stream().forEach(ce -> {
                                if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                                    if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                        ce.setErrorMessage("数据库中已存在该数据;");
                                        errorList.add(ce);
                                    } else {
                                        successList.add(ce);
                                    }
                                } else {
                                    errorList.add(ce);
                                }
                            });
                            success500TmpList = new ArrayList<>(500);
                        }
                    } else {
                        dcDrawInfoVO.setErrorMessage(errorMessage.toString());
                        errorList.add(dcDrawInfoVO);
                    }
                }
                if (ToolUtil.isNotEmpty(success500TmpList)) {
                    Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                    if (ToolUtil.isNotEmpty(selfCheckDbList)){
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                        dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> {
                            dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId());
                        });
                    }
                    List<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                    success500TmpList.stream().forEach(es -> {
                        Long aLong = dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(aLong)) {
                            es.setErrorMessage("该图纸无卷册信息;");
                        } else {
                            es.setDrwgrpId(aLong);
                            Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(es.getProjectId()));
                            es.setOrgId((Long) stringStringMap.get("orgId"));
                            es.setOrgCode((String) stringStringMap.get("orgCode"));
                            es.setOrgName((String)  stringStringMap.get("orgName"));
                            es.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                            es.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                            es.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                            dcDrawInfoEntityList.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                        }
                    });
                    if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)){
                        List<DcDrawInfoEntity> dcDrawInfoEntityListDb = dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                        dcDrawInfoEntityListDb.stream().forEach(ce -> {
                            dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1);
                        });
                    }
                    success500TmpList.stream().forEach(ce -> {
                        if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                            if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                ce.setErrorMessage("数据库中已存在该数据;");
                                errorList.add(ce);
                            } else {
                                successList.add(ce);
                            }
                        } else {
                            errorList.add(ce);
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrawInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        success.setMsg(comStr.toString());
        return success;
    }


    @Override
    public CommonResponse<JSONObject> excelSendFileImport(HttpServletRequest request) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        MultipartFile mf = null;
        List<DcSendFileImportVo> successList = new ArrayList<>();
        List<DcSendFileImportVo> errorList = new ArrayList<>();
        List<DcSendFileImportVo> rtErrorList = new ArrayList<>();

        boolean isFailed = false;
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            mf = entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("发文信息超过10000条，请分批上传！");
                }
                List<DcFiledistributeCenterEntity> centerList = dcFiledistributeCenterService.list(
                        new QueryWrapper<DcFiledistributeCenterEntity>().lambda()
                                .eq(DcFiledistributeCenterEntity::getDr, 0)
                                .eq(DcFiledistributeCenterEntity::getFileSts, "Y")
                                .eq(DcFiledistributeCenterEntity::getAttribute, "1474197986685751304")
                );
                Map<String, DcFiledistributeCenterEntity> centerDataMap = centerList.stream().collect(Collectors.toMap(e -> e.getFileCode(), Function.identity(), (e1, e2) -> e2));
                Map<String, Map<String,Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("projectId")), Function.identity(),(e1,e2)->e2)
                );
                Map<String, Map<String,Object>> sourceUnitnameDataMap = mapper.queryMapSource().stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );
                List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                if (response.isSuccess()) {
                    mapProjLocal = response.getData();
                }
                Map<String, Map<String,Object>> projDataMap = mapProjLocal.stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );

                //人
                List<Map<String, Object>> employeeList = Lists.newArrayList();
                CommonResponse<List<Map<String, Object>>> employeeResponse = iExternalApi.getMapAllEmployee();
                if (employeeResponse.isSuccess()&& ListUtil.isNotEmpty(employeeResponse.getData())) {
                    employeeList = employeeResponse.getData();
                }
                Map<String, Map<String,Object>> employee = employeeList.stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );

                for (int i = 0; i < result.size(); i++) {
                    final boolean[] flag = {true};
                    List<String> datas = result.get(i);
                    DcSendFileImportVo dcSendFileImportVo = new DcSendFileImportVo();
                    StringBuilder errorMessage = new StringBuilder("");
                    dcSendFileImportVo.setId(IdWorker.getId());

                    // projectName
                    String projectName = datas.get(0);
                    if (ToolUtil.isNotEmpty(projectName)) {
                        Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                        if (ToolUtil.isNotEmpty(projectNameMap)) {
                            dcSendFileImportVo.setProjectName((String) projectNameMap.get("name"));
                            dcSendFileImportVo.setProjectCode((String) projectNameMap.get("code"));
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                dcSendFileImportVo.setProjectId(Long.parseLong((String) id));
                            } else {
                                dcSendFileImportVo.setProjectId((Long) id);
                            }
                            Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                            if (engineeringTypeId instanceof String) {
                                dcSendFileImportVo.setEngineeringTypeId(Long.parseLong((String) engineeringTypeId));
                            } else {
                                dcSendFileImportVo.setEngineeringTypeId((Long) engineeringTypeId);
                            }
                        } else {
                            errorMessage.append("[项目名称]" + projectName + ":错误参照无法获取;");
                            flag[0] = false;
                        }
                    }

                    //org
                    if (ToolUtil.isNotEmpty(dcSendFileImportVo.getProjectId())) {
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(dcSendFileImportVo.getProjectId()));
                        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById((Long) stringStringMap.get("orgId"));
                        if (!orgVO.isSuccess()) {
                            errorMessage.append("[项目无对应组织]");
                            flag[0] = false;
                        }
                        dcSendFileImportVo.setOrgId((Long) stringStringMap.get("orgId"));
                        dcSendFileImportVo.setOrgCode(orgVO.getData().getCode());
                        dcSendFileImportVo.setOrgName(orgVO.getData().getName());
                        dcSendFileImportVo.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        dcSendFileImportVo.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                    }

                    //外部编码
                    dcSendFileImportVo.setFileCode(datas.get(1));
                    //内部编码
                    dcSendFileImportVo.setFileInternalCode(datas.get(2));

                    //文件名称
                    String fileName = datas.get(3);
                    if (ToolUtil.isEmpty(fileName)) {
                        errorMessage.append("[文件名称]为空;");
                        flag[0] = false;
                    }
                    dcSendFileImportVo.setFileName(fileName);

                    //版本
                    String fileVsn = datas.get(4);
                    if (ToolUtil.isEmpty(fileVsn)) {
                        errorMessage.append("[版本]为空;");
                        flag[0] = false;
                    }
                    dcSendFileImportVo.setFileVsn(fileVsn);

                    //发文日期
                    String sendDateStr = datas.get(5);
                    if (ToolUtil.isNotEmpty(sendDateStr)) {
                        Date parse = EJCDateUtil.parseDate(sendDateStr, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            dcSendFileImportVo.setSendDate(parse);
                        } else {
                            errorMessage.append("[发文日期]" + sendDateStr + ":格式错误");
                            flag[0] = false;
                        }
                    } else {
                        errorMessage.append("[发文日期]为空;");
                        flag[0] = false;
                    }

                    //报送类型
                    String submitType = datas.get(6);
                    CommonResponse<List<DefdocDetailVO>> drwgrpTypeDefdoc = iDefdocApi.getDefDocByDefCode("SUBMIT_TYPE");
                    if (StringUtils.isBlank(submitType)) {
                        errorMessage.append("[报送类型]").append(submitType).append(":自定义档案错误;");
                        flag[0] = false;
                    } else if (!drwgrpTypeDefdoc.isSuccess() || CollectionUtils.isEmpty(drwgrpTypeDefdoc.getData())) {
                        errorMessage.append("[报送类型]").append(submitType).append(":自定义档案错误;");
                        flag[0] = false;
                    } else {
                        Long defdocDetailId = drwgrpTypeDefdoc.getData().stream().filter(a -> submitType.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        String defdocDetailCode = drwgrpTypeDefdoc.getData().stream().filter(a -> submitType.equals(a.getName())).map(DefdocDetailVO::getCode).findFirst().orElse(null);
                        dcSendFileImportVo.setSubmitType(defdocDetailId);
                        dcSendFileImportVo.setSubmitTypeCode(defdocDetailCode);
                    }

                    //文件属性
                    String attribute = datas.get(7);
                    List<Map> maps = dcFiledistributeCenterService.selectAttributeByPid("1474197986685751299");
                    if (StringUtils.isBlank(attribute)) {
                        errorMessage.append("[文件属性]").append(attribute).append(":错误;");
                        flag[0] = false;
                    } else if (ToolUtil.isEmpty(maps)) {
                        errorMessage.append("[文件属性]").append(attribute).append(":获取参照错误;");
                        flag[0] = false;
                    } else {
                        Map attributeMap = maps.stream().filter(a -> attribute.equals(a.get("category_name"))).findFirst().orElse(null);
                        if (attributeMap == null) {
                            errorMessage.append("[文件属性]").append(attribute).append(":获取对应参照错误;");
                            flag[0] = false;
                        } else {
                            dcSendFileImportVo.setAttribute((Long) attributeMap.get("id"));
                        }
                    }

                    //文件类型
                    String filetype = datas.get(8);
                    if (dcSendFileImportVo.getAttribute() != null && dcSendFileImportVo.getAttribute() != 0) {
                        List<Map> maps1 = dcFiledistributeCenterService.selectAttributeByPid(dcSendFileImportVo.getAttribute() + "");
                        if (StringUtils.isBlank(filetype)) {
                            errorMessage.append("[文件类型]").append(filetype).append(":错误;");
                            flag[0] = false;
                        } else if (ToolUtil.isEmpty(maps1)) {
                            errorMessage.append("[文件类型]").append(filetype).append(":获取参照错误;");
                            flag[0] = false;
                        } else {
                            Map filetypeMap = maps.stream().filter(a -> filetype.equals(a.get("category_name"))).findFirst().orElse(null);
                            if (filetypeMap == null) {
                                errorMessage.append("[文件类型]").append(filetype).append(":获取对应参照错误;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setFiletype((Long) filetypeMap.get("id"));
                            }
                        }
                    } else {
                        errorMessage.append("[文件类型]").append(attribute).append(":获取参照错误;");
                        flag[0] = false;
                    }

                    //单位工程代码
                    String unitProjCodeName = datas.get(9);
                    Map<String, String> queryMap = new HashMap<>();
                    queryMap.put("projectId", dcSendFileImportVo.getProjectId() + "");
                    queryMap.put("categoryCode", "gcdm");
                    CommonResponse<List<DataDictionaryVO>> unitProjCodeIdResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                    if (unitProjCodeIdResponse.isSuccess()) {
                        List<DataDictionaryVO> data = unitProjCodeIdResponse.getData();
                        if (data != null) {
                            DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> unitProjCodeName.equals(a.getDictionaryName())).findFirst().orElse(new DataDictionaryVO());
                            dcSendFileImportVo.setUnitProjCodeId(dataDictionaryVO.getId());
                            dcSendFileImportVo.setUnitProjCode(dataDictionaryVO.getDictionaryName());
                            dcSendFileImportVo.setUnitProjCode(dataDictionaryVO.getDictionaryCode());
                        }
                    }

                    //机组
                    String mgrpName = datas.get(10);
                    if (ToolUtil.isEmpty(mgrpName)) {
                        errorMessage.append("[机组]为空;");
                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "mgrp");
                        CommonResponse<List<DataDictionaryVO>> mgrpResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (mgrpResponse.isSuccess()) {
                            List<DataDictionaryVO> data = mgrpResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[机组]").append(mgrpName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setMgrp(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[机组]").append(mgrpName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //主送单位/部门
                    String submitOrgName = datas.get(11);
                    if (ToolUtil.isNotEmpty(submitOrgName)) {
                        String[] split = submitOrgName.split(",");
                        List<Map<String, Object>> submitOrgMapList = Arrays.stream(split).map(a -> {
                            Map<String, Object> submitOrgMap = sourceUnitnameDataMap.get(a);
                            if (submitOrgMap == null) {
                                errorMessage.append("[主送单位/部门]").append(a).append(":获取参照错误;");
                                flag[0] = false;
                            }
                            return submitOrgMap;
                        }).collect(Collectors.toList());
                        String ids = StringUtils.join(submitOrgMapList.stream().map(a -> a.get("id")).collect(Collectors.toList()), ",");
                        String names = StringUtils.join(submitOrgMapList.stream().map(a -> a.get("name")).collect(Collectors.toList()), ",");
//                        String codes = StringUtils.join(submitOrgMapList.stream().map(a -> a.get("code")).collect(Collectors.toList()), ",");
                        dcSendFileImportVo.setSubmitOrgId(ids);
                        dcSendFileImportVo.setSubmitOrgName(names);
                        dcSendFileImportVo.setSubmitOrgCode(ids);
                    }

                    //抄送单位/部门
                    String copyOrgName = datas.get(12);
                    if (ToolUtil.isNotEmpty(copyOrgName)) {
                        String[] split = copyOrgName.split(",");
                        List<Map<String, Object>> copyOrgMapList = Arrays.stream(split).map(a -> {
                            Map<String, Object> copyOrgMap = sourceUnitnameDataMap.get(a);
                            if (copyOrgMap == null) {
                                errorMessage.append("[抄送单位/部门]").append(a).append(":获取参照错误;");
                                flag[0] = false;
                            }
                            return copyOrgMap;
                        }).collect(Collectors.toList());
                        String ids = StringUtils.join(copyOrgMapList.stream().map(a -> a.get("id")).collect(Collectors.toList()), ",");
                        String names = StringUtils.join(copyOrgMapList.stream().map(a -> a.get("name")).collect(Collectors.toList()), ",");
//                        String codes = StringUtils.join(submitOrgMapList.stream().map(a -> a.get("code")).collect(Collectors.toList()), ",");
                        dcSendFileImportVo.setCopyOrgId(ids);
                        dcSendFileImportVo.setCopyOrgName(names);
                        dcSendFileImportVo.setCopyOrgCode(ids);
                    }

                    //升版状态
                    String upgradeStateName = datas.get(13);
                    CommonResponse<List<DefdocDetailVO>> upgradeStateDefdoc = iDefdocApi.getDefDocByDefCode("dc_fw_upgrade_state");
                    if (StringUtils.isBlank(upgradeStateName)) {
                        errorMessage.append("[升版状态]").append(upgradeStateName).append(":自定义档案错误;");
                        flag[0] = false;
                    } else if (!upgradeStateDefdoc.isSuccess() || CollectionUtils.isEmpty(upgradeStateDefdoc.getData())) {
                        errorMessage.append("[升版状态]").append(upgradeStateName).append(":自定义档案错误;");
                        flag[0] = false;
                    } else {
                        Long defdocDetailId = upgradeStateDefdoc.getData().stream().filter(a -> upgradeStateName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        dcSendFileImportVo.setUpgradeState(defdocDetailId);
                    }

                    //是否涉费
                    String costFlag = datas.get(14);
                    if (ToolUtil.isNotEmpty(costFlag) && "是".equals(costFlag)) {
                        dcSendFileImportVo.setCostFlag(true);
                    } else if (ToolUtil.isNotEmpty(costFlag) && "否".equals(costFlag)) {
                        dcSendFileImportVo.setCostFlag(false);
                    }

                    //是否保密
                    String secretFlag = datas.get(15);
                    if (ToolUtil.isNotEmpty(secretFlag) && "是".equals(secretFlag)) {
                        dcSendFileImportVo.setSecretFlag(true);
                    } else if (ToolUtil.isNotEmpty(secretFlag) && "否".equals(secretFlag)) {
                        dcSendFileImportVo.setSecretFlag(false);
                    }

                    //是否需回复
                    String needReplyFlag = datas.get(16);
                    if (ToolUtil.isNotEmpty(needReplyFlag) && "是".equals(needReplyFlag)) {
                        dcSendFileImportVo.setSecretFlag(true);
                    } else if (ToolUtil.isNotEmpty(needReplyFlag) && "否".equals(needReplyFlag)) {
                        dcSendFileImportVo.setSecretFlag(false);
                    }

                    //需回复日期
                    String needReplyDate = datas.get(17);
                    if (ToolUtil.isNotEmpty(needReplyDate)) {
                        Date parse = EJCDateUtil.parseDate(needReplyDate, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            dcSendFileImportVo.setNeedReplyDate(parse);
                        } else {
                            errorMessage.append("[需回复日期]" + needReplyDate + ":格式错误;");
                            flag[0] = false;
                        }
                    }

                    //回复收文编号
                    String centerCode = datas.get(18);
                    if (ToolUtil.isNotEmpty(centerCode)) {
                        DcFiledistributeCenterEntity dcFiledistributeCenterEntity = centerDataMap.get(centerCode);
                        if (dcFiledistributeCenterEntity == null) {
                            errorMessage.append("[回复收文编号]" + needReplyDate + ":获取参照错误;");
                            flag[0] = false;
                        } else {
                            dcSendFileImportVo.setCenterId(dcFiledistributeCenterEntity.getId());
                            dcSendFileImportVo.setReceiveFileCode(dcFiledistributeCenterEntity.getFileCode());
                        }
                    }

                    //合同编号

                    //作业编码
                    String jobCodeName = datas.get(19);
                    if (ToolUtil.isNotEmpty(jobCodeName)) {
                        Map<String, String> map = new HashMap<>();
                        map.put("categoryName", jobCodeName);
                        CommonResponse<Map<String, Long>> mapCommonResponse = billCodeRuleApi.materialClassificationTree(map);
                        if (mapCommonResponse.isSuccess()) {
                            Map<String, Long> data = mapCommonResponse.getData();
                            if (ToolUtil.isNotEmpty(data)) {
                                Long id = data.get("name");
                                dcSendFileImportVo.setJobCode(id);
                            }
                        }
                    }

                    //标段
                    String sectionName = datas.get(20);
                    if (ToolUtil.isEmpty(sectionName)) {
//                        errorMessage.append("[标段]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "bidsection");
                        CommonResponse<List<DataDictionaryVO>> sectionResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (sectionResponse.isSuccess()) {
                            List<DataDictionaryVO> data = sectionResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> sectionName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[标段]").append(sectionName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setBidsection(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[标段]").append(sectionName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //专业
                    String specialtyName = datas.get(21);
                    if (ToolUtil.isEmpty(specialtyName)) {
//                        errorMessage.append("[专业]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "specialty");
                        CommonResponse<List<DataDictionaryVO>> specialtyResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (specialtyResponse.isSuccess()) {
                            List<DataDictionaryVO> data = specialtyResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[专业]").append(specialtyName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setSpecialty(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[专业]").append(specialtyName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //系统
                    String sysName = datas.get(22);
                    if (ToolUtil.isEmpty(sysName)) {
//                        errorMessage.append("[系统]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "sys");
                        CommonResponse<List<DataDictionaryVO>> sysResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (sysResponse.isSuccess()) {
                            List<DataDictionaryVO> data = sysResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> sysName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[系统]").append(sysName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setSys(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[系统]").append(sysName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //子项
                    String subItemName = datas.get(23);
                    if (ToolUtil.isEmpty(subItemName)) {
//                        errorMessage.append("[子项]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "subItem");
                        CommonResponse<List<DataDictionaryVO>> subItemResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (subItemResponse.isSuccess()) {
                            List<DataDictionaryVO> data = subItemResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> subItemName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[子项]").append(subItemName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setSubItem(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[子项]").append(subItemName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //材料类型
                    String materialTypeName = datas.get(24);
                    if (ToolUtil.isEmpty(materialTypeName)) {
//                        errorMessage.append("[材料类型]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "materialType");
                        CommonResponse<List<DataDictionaryVO>> materialTypeResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (materialTypeResponse.isSuccess()) {
                            List<DataDictionaryVO> data = materialTypeResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> materialTypeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[材料类型]").append(materialTypeName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[材料类型]").append(materialTypeName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //部门
                    String deptName = datas.get(25);
                    if (ToolUtil.isEmpty(deptName)) {
                        errorMessage.append("[部门]为空;");
                        flag[0]=false;
                    } else{
                        CommonResponse<OrgVO> orgResponse = iOrgApi.findByNameAndTenantId(deptName, InvocationInfoProxy.getTenantid());
                        if (orgResponse.isSuccess()){
                            OrgVO data = orgResponse.getData();
                            if (data != null){
                                dcSendFileImportVo.setDeptId(data.getId());
                            }else {
                                errorMessage.append("[部门]").append(deptName).append(":获取对应参照错误;");
                                flag[0] = false;
                            }
                        }else {
                            errorMessage.append("[部门]").append(deptName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //主要活动
                    String mainActivitiesName = datas.get(26);
                    if (ToolUtil.isNotEmpty(mainActivitiesName)) {
                        Map<String, String> map = new HashMap<>();
                        map.put("categoryName", mainActivitiesName);
                        CommonResponse<Map<String, Long>> mapCommonResponse = billCodeRuleApi.materialClassificationTree(map);
                        if (mapCommonResponse.isSuccess()) {
                            Map<String, Long> data = mapCommonResponse.getData();
                            if (ToolUtil.isNotEmpty(data)) {
                                Long id = data.get("name");
                                dcSendFileImportVo.setMainActivities(id);
                            }else {
                                errorMessage.append("[主要活动]").append(mainActivitiesName).append(":获取对应参照错误;");
                                flag[0] = false;
                            }
                        }else {
                            errorMessage.append("[主要活动]").append(mainActivitiesName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }

                    //分项活动
                    String subentryActivitiesName = datas.get(27);
                    if (ToolUtil.isNotEmpty(subentryActivitiesName)) {
                        Map<String, String> map = new HashMap<>();
                        map.put("categoryName", subentryActivitiesName);
                        CommonResponse<Map<String, Long>> mapCommonResponse = billCodeRuleApi.materialClassificationTree(map);
                        if (mapCommonResponse.isSuccess()) {
                            Map<String, Long> data = mapCommonResponse.getData();
                            if (ToolUtil.isNotEmpty(data)) {
                                Long id = data.get("name");
                                dcSendFileImportVo.setSubentryActivities(id);
                            }else {
                                errorMessage.append("[分项活动]").append(subentryActivitiesName).append(":获取对应参照错误;");
                                flag[0] = false;
                            }
                        }else {
                            errorMessage.append("[分项活动]").append(subentryActivitiesName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }
                    //主要种类
                    String principalItemName = datas.get(28);
                    if (ToolUtil.isEmpty(principalItemName)) {
//                        errorMessage.append("[主要种类]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "principalItem");
                        CommonResponse<List<DataDictionaryVO>> principalItemResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (principalItemResponse.isSuccess()) {
                            List<DataDictionaryVO> data = principalItemResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> principalItemName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[主要种类]").append(principalItemName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[主要种类]").append(principalItemName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }
                    //通讯类型代码
                    String cmitTypeCodeName = datas.get(29);
                    if (ToolUtil.isEmpty(cmitTypeCodeName)) {
//                        errorMessage.append("[通讯类型代码]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "cmitTypeCode");
                        CommonResponse<List<DataDictionaryVO>> cmitTypeCodeResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (cmitTypeCodeResponse.isSuccess()) {
                            List<DataDictionaryVO> data = cmitTypeCodeResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> cmitTypeCodeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[通讯类型代码]").append(cmitTypeCodeName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[通讯类型代码]").append(cmitTypeCodeName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }
                    //收文方通讯代码
                    String receiverCmitCodeName = datas.get(30);
                    if (ToolUtil.isEmpty(receiverCmitCodeName)) {
//                        errorMessage.append("[收文方通讯代码]为空;");
//                        flag[0] = false;
                    } else {
                        queryMap.put("categoryCode", "receiverCmitCode");
                        CommonResponse<List<DataDictionaryVO>> receiverCmitCodeResponse = billCodeRuleApi.queryUnitBumber(queryMap);
                        if (receiverCmitCodeResponse.isSuccess()) {
                            List<DataDictionaryVO> data = receiverCmitCodeResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> receiverCmitCodeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[收文方通讯代码]").append(receiverCmitCodeName).append(":获取对应参照错误;");
                                    flag[0] = false;
                                } else {
                                    dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                                }
                            }
                        } else {
                            errorMessage.append("[收文方通讯代码]").append(receiverCmitCodeName).append(":获取参照错误;");
                            flag[0] = false;
                        }
                    }
                    //部门主任审核
                    String deptDirectorName = datas.get(31);
                    if (ToolUtil.isEmpty(deptDirectorName)){
//                        errorMessage.append("[部门主任审核]为空;");
//                        flag[0] = false;
                    }else {
                        String[] deptDirectorNameArray = deptDirectorName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : deptDirectorNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[部门主任审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[部门主任审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setDeptDirector(ids.toString());
                    }
                    //技术组长
                    String skillDirectorName = datas.get(32);
                    if (ToolUtil.isEmpty(deptDirectorName)){
//                        errorMessage.append("[技术组长]为空;");
//                        flag[0] = false;
                    }else {
                        String[] skillDirectorNameArray = skillDirectorName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : skillDirectorNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[技术组长]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[技术组长]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setSkillDirector(ids.toString());
                    }

                    //审核（会签）
                    String countersignName = datas.get(33);
                    if (ToolUtil.isEmpty(countersignName)){
//                        errorMessage.append("[审核（会签）]为空;");
//                        flag[0] = false;
                    }else {
                        String[] countersignNameArray = countersignName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : countersignNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[审核（会签）]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[审核（会签）]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setCountersign(ids.toString());
                    }

                    //分管领导审核
                    String branchDirectorName = datas.get(34);
                    if (ToolUtil.isEmpty(branchDirectorName)){
//                        errorMessage.append("[分管领导审核]为空;");
//                        flag[0] = false;
                    }else {
                        String[] branchDirectorNameArray = branchDirectorName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : branchDirectorNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[分管领导审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[分管领导审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setBranchDirector(ids.toString());
                    }

                    //项目经理
                    String projectDirectorName = datas.get(35);
                    if (ToolUtil.isEmpty(projectDirectorName)){
//                        errorMessage.append("[项目经理]为空;");
//                        flag[0] = false;
                    }else {
                        String[] projectDirectorNameArray = projectDirectorName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : projectDirectorNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[项目经理]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[项目经理]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setProjectDirector(ids.toString());
                    }

                    //文档审核
                    String documentName = datas.get(36);
                    if (ToolUtil.isEmpty(documentName)){
//                        errorMessage.append("[文档审核]为空;");
//                        flag[0] = false;
                    }else {
                        String[] documentNameArray = documentName.split(",");
                        StringBuilder ids = new StringBuilder("");
                        for (String s : documentNameArray) {
                            Map<String, Object> stringObjectMap = employee.get(s);
                            if (stringObjectMap == null) {
                                errorMessage.append("[文档审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }

                            try {
                                long id = Long.parseLong(stringObjectMap.get("id").toString());
                                if (ids.length() == 0){
                                    ids.append(id);
                                }else {
                                    ids.append(","+id);
                                }
                            }catch (Exception e){
                                logger.info(e.getMessage(),s, JSONObject.toJSONString(stringObjectMap));
                                errorMessage.append("[文档审核]").append(s).append(":获取参照错误;");
                                flag[0] = false;
                            }
                        }
                        dcSendFileImportVo.setDocument(ids.toString());
                    }

                    dcSendFileImportVo.setErrorMessage(errorMessage.toString());
                    dcSendFileImportVo.setRowIndex(i+2);


                    if (flag[0]){
                        successList.add(dcSendFileImportVo);
                    }else {
                        errorList.add(dcSendFileImportVo);
                    }

                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcSendFileImportVo::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);

        return success;
    }



}
