package com.ejianc.business.dc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 图纸申请
 *
 * @author generator
 */
public class DcDrawapplyInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private Long drwgrpId; // 卷册id
    private String drwgrpCode; // 卷册编号
    private String drwgrpName; // 卷册名称
    private String drwgrpVsn; // 卷册版本
    private Long drwgrpType; // 图纸类别--字典dc_drwgrp_type
    private Long sourceUnitid; // 设计单位id
    private String sourceUnitname; // 设计单位
    private Long mgrp; // 机组--字典pub_mgrp_code
    private Long specialty; // 专业--字典pub_specialty_code
    private Long sys; // 系统--字典pub_system_code
    private Integer surplusNum; // 库存量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date drawArriveDate; // 到图日期
    private Integer num; // 份数
    private String paperFlag; // 是否纸质版
    private String issueUserCode; // 审核人编号
    private String issueUserName; // 审核人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate; // 审核日期
    private String distCode; // 分发单号
    private String distUserCode; // 分发人编号
    private String distUserName; // 分发人姓名
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date distDate; // 分发日期
    private Long createDeptId; // 创建部门id
    private String createDeptName; // 创建部门
    private String createUserName; // 创建人
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称

    private List<DcDrawdistributeDrawinfoVO> dcDrawdistributeDrawinfoList = new ArrayList<>(); // 图纸签发/图纸申请-图纸信息

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="Dc-dcDrwgrpInfo-Menu-Refer")
    public Long getDrwgrpId() {
        return drwgrpId;
    }

    @ReferDeserialTransfer
    public void setDrwgrpId(Long drwgrpId) {
        this.drwgrpId = drwgrpId;
    }

    public String getDrwgrpCode() {
        return drwgrpCode;
    }

    public void setDrwgrpCode(String drwgrpCode) {
        this.drwgrpCode = drwgrpCode;
    }

    public String getDrwgrpName() {
        return drwgrpName;
    }

    public void setDrwgrpName(String drwgrpName) {
        this.drwgrpName = drwgrpName;
    }

    public String getDrwgrpVsn() {
        return drwgrpVsn;
    }

    public void setDrwgrpVsn(String drwgrpVsn) {
        this.drwgrpVsn = drwgrpVsn;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDrwgrpType() {
        return drwgrpType;
    }

    @ReferDeserialTransfer
    public void setDrwgrpType(Long drwgrpType) {
        this.drwgrpType = drwgrpType;
    }

    @ReferSerialTransfer(referCode = "Dc-drawSourceMaintenance-Menu-Refer")
    public Long getSourceUnitid() {
        return sourceUnitid;
    }

    @ReferDeserialTransfer
    public void setSourceUnitid(Long sourceUnitid) {
        this.sourceUnitid = sourceUnitid;
    }

    public String getSourceUnitname() {
        return sourceUnitname;
    }

    public void setSourceUnitname(String sourceUnitname) {
        this.sourceUnitname = sourceUnitname;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSys() {
        return sys;
    }

    @ReferDeserialTransfer
    public void setSys(Long sys) {
        this.sys = sys;
    }

    public Integer getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(Integer surplusNum) {
        this.surplusNum = surplusNum;
    }

    public Date getDrawArriveDate() {
        return drawArriveDate;
    }

    public void setDrawArriveDate(Date drawArriveDate) {
        this.drawArriveDate = drawArriveDate;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getPaperFlag() {
        return paperFlag;
    }

    public void setPaperFlag(String paperFlag) {
        this.paperFlag = paperFlag;
    }

    public String getIssueUserCode() {
        return issueUserCode;
    }

    public void setIssueUserCode(String issueUserCode) {
        this.issueUserCode = issueUserCode;
    }

    public String getIssueUserName() {
        return issueUserName;
    }

    public void setIssueUserName(String issueUserName) {
        this.issueUserName = issueUserName;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public String getDistCode() {
        return distCode;
    }

    public void setDistCode(String distCode) {
        this.distCode = distCode;
    }

    public String getDistUserCode() {
        return distUserCode;
    }

    public void setDistUserCode(String distUserCode) {
        this.distUserCode = distUserCode;
    }

    public String getDistUserName() {
        return distUserName;
    }

    public void setDistUserName(String distUserName) {
        this.distUserName = distUserName;
    }

    public Date getDistDate() {
        return distDate;
    }

    public void setDistDate(Date distDate) {
        this.distDate = distDate;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getCreateDeptId() {
        return createDeptId;
    }

    @ReferDeserialTransfer
    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }

    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public List<DcDrawdistributeDrawinfoVO> getDcDrawdistributeDrawinfoList() {
        return dcDrawdistributeDrawinfoList;
    }

    public void setDcDrawdistributeDrawinfoList(List<DcDrawdistributeDrawinfoVO> dcDrawdistributeDrawinfoList) {
        this.dcDrawdistributeDrawinfoList = dcDrawdistributeDrawinfoList;
    }
}
