/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dc.bean.CtOtherFileTakeEntity;
import com.ejianc.business.dc.mapper.CtOtherFileTakeMapper;
import com.ejianc.business.dc.service.ICtOtherFileTakeService;
import com.ejianc.business.dc.vo.CtOtherFileTakeVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ctOtherFileTakeService")
public class CtOtherFileTakeServiceImpl
extends BaseServiceImpl<CtOtherFileTakeMapper, CtOtherFileTakeEntity>
implements ICtOtherFileTakeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public CtOtherFileTakeVO saveOrUpdate(CtOtherFileTakeVO saveOrUpdateVO) {
        boolean b;
        CommonResponse snCommonResponse = new CommonResponse();
        CtOtherFileTakeEntity entity = (CtOtherFileTakeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), CtOtherFileTakeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)"Invoice_Open_Apply_Code", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            BillCodeApiVO apiVO = new BillCodeApiVO();
            apiVO.setProjectId(entity.getProjectId());
            apiVO.setProjectCode(entity.getProjectCode());
            apiVO.setProjectName(entity.getProjectName());
            apiVO.setCategoryId(entity.getAttribute());
            ArrayList<BillCodeRuleSNVO> snVoList = new ArrayList<BillCodeRuleSNVO>();
            BillCodeRuleSNVO outSnVO = new BillCodeRuleSNVO();
            outSnVO.setSourcePid(entity.getId());
            outSnVO.setSourceCode(entity.getCode());
            outSnVO.setSourceType("BT231011000000001");
            outSnVO.setSourceTypeName("\u5176\u4ed6\u6587\u4ef6\u53d6\u53f7");
            try {
                JSONArray referEntityValue;
                JSONObject specialtyRef;
                if (Objects.nonNull(entity.getFileType())) {
                    JSONArray fileTypeReferValue = ReferObjectUtil.getReferEntityValue((String)(entity.getFileType() + ""), (String)"data-dictionary");
                    JSONObject fileTypeRef = (JSONObject)fileTypeReferValue.get(0);
                    outSnVO.setRule18(fileTypeRef.getString("code"));
                }
                if (Objects.nonNull(entity.getSpecialty())) {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSpecialty() + ""), (String)"data-dictionary");
                    specialtyRef = (JSONObject)specialtyReferValue.get(0);
                    outSnVO.setRule05(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getMaterialType())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMaterialType() + ""), (String)"data-dictionary");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule17(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getSys())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSys() + ""), (String)"data-dictionary");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule14(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getSubItem())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSubItem() + ""), (String)"data-dictionary");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule16(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getMainActivities())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getMainActivities() + ""), (String)"data-dictionary-category");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule11(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getSubentryActivities())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getSubentryActivities() + ""), (String)"data-dictionary-category");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule10(specialtyRef.getString("code"));
                }
                if (Objects.nonNull(entity.getPrincipalItem())) {
                    referEntityValue = ReferObjectUtil.getReferEntityValue((String)(entity.getPrincipalItem() + ""), (String)"data-dictionary");
                    specialtyRef = (JSONObject)referEntityValue.get(0);
                    outSnVO.setRule15(specialtyRef.getString("code"));
                }
                outSnVO.setRuleType(RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode());
                snVoList.add(outSnVO);
                BillCodeRuleSNVO outSnNb = (BillCodeRuleSNVO)BeanMapper.map((Object)outSnVO, BillCodeRuleSNVO.class);
                outSnNb.setRuleType(RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode());
                snVoList.add(outSnNb);
            }
            catch (Exception e) {
                throw new BusinessException(String.format("\u53d6\u53f7\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a[%s]", e.getMessage()));
            }
            apiVO.setSnList(snVoList);
            snCommonResponse = this.billCodeRuleApi.generateBillCode(apiVO);
            if (!snCommonResponse.isSuccess()) {
                throw new RuntimeException(String.format("\u53d6\u53f7\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a[%s]", snCommonResponse.getMsg()));
            }
            List snList = ((BillCodeApiVO)snCommonResponse.getData()).getSnList();
            for (BillCodeRuleSNVO codeSnVO : snList) {
                if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) {
                    entity.setFileCode(codeSnVO.getGenerateBillCode());
                    continue;
                }
                if (!RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode().equals(codeSnVO.getRuleType())) continue;
                entity.setFileInternalCode(codeSnVO.getGenerateBillCode());
            }
        }
        if ((b = this.saveOrUpdate((Object)entity, false)) && Objects.nonNull(snCommonResponse.getData())) {
            BillCodeApiVO responseData = (BillCodeApiVO)snCommonResponse.getData();
            this.billCodeRuleApi.commitBillCode(responseData);
        }
        return (CtOtherFileTakeVO)((Object)BeanMapper.map((Object)((Object)entity), CtOtherFileTakeVO.class));
    }

    @Override
    public void delete(List<CtOtherFileTakeVO> vos) {
        HashMap sourceIds = Maps.newHashMap();
        List idList = Lists.newArrayList();
        if (ListUtil.isNotEmpty(vos)) {
            for (CtOtherFileTakeVO vo : vos) {
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids", idList);
        CommonResponse commonResponse = this.billCodeRuleApi.releaseBillCode((Map)sourceIds);
        if (!commonResponse.isSuccess()) {
            throw new RuntimeException("\u8fd8\u53f7\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + commonResponse.getMsg());
        }
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

