/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrawingApplyForDrwgrpDrawEntity;
import com.ejianc.business.dc.bean.DcDrawingApplyForDrwgrpEntity;
import com.ejianc.business.dc.bean.DcDrawingApplyForEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpDrawMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForMapper;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawingApplyForService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawingApplyForVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dcDrawingApplyForService")
public class DcDrawingApplyForServiceImpl
extends BaseServiceImpl<DcDrawingApplyForMapper, DcDrawingApplyForEntity>
implements IDcDrawingApplyForService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DcDrawingApplyForMapper dcDrawingApplyForMapper;
    @Autowired
    private DcDrawingApplyForDrwgrpDrawMapper dcDrawingApplyForDrwgrpDrawMapper;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private DcDrawingApplyForDrwgrpMapper dcDrawingApplyForDrwgrpMapper;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;

    @Override
    public void printDataDispose(List<Long> ids) {
        if (ToolUtil.isEmpty(ids)) {
            return;
        }
        for (Long id : ids) {
            DcDrawingApplyForEntity drawingApplyFor = (DcDrawingApplyForEntity)((Object)this.getById(id));
            if (!ToolUtil.isEmpty(drawingApplyFor.getDistCode())) continue;
            this.reduceInventory(drawingApplyFor);
            BillCodeParam billCodeParam = BillCodeParam.build((String)"DC_DRAWAPPLY_DIST_CODE", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)drawingApplyFor), DcDrawingApplyForVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)id)).set(DcDrawingApplyForEntity::getDistCode, billCode.getData())).set(DcDrawingApplyForEntity::getDistUserCode, (Object)this.sessionManager.getUserContext().getUserId())).set(DcDrawingApplyForEntity::getDistUserName, (Object)this.sessionManager.getUserContext().getUserName())).set(DcDrawingApplyForEntity::getDistDate, (Object)new Date()));
                continue;
            }
            throw new RuntimeException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    private void reduceInventory(DcDrawingApplyForEntity drawingApplyFor) {
        List drawingApplyForList = this.dcDrawingApplyForMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcDrawingApplyForEntity::getCode, (Object)drawingApplyFor.getCode())).isNotNull(DcDrawingApplyForEntity::getDistCode));
        if (ToolUtil.isNotEmpty(drawingApplyForList)) {
            return;
        }
        List drwgrpList = this.dcDrawingApplyForDrwgrpMapper.selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcDrawingApplyForDrwgrpEntity::getPid, (Object)drawingApplyFor.getId()));
        if (ToolUtil.isEmpty(drwgrpList)) {
            return;
        }
        for (DcDrawingApplyForDrwgrpEntity drwgrp : drwgrpList) {
            int surplusNum;
            List drawList = this.dcDrawingApplyForDrwgrpDrawMapper.selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcDrawingApplyForDrwgrpDrawEntity::getPid, (Object)drwgrp.getId()));
            boolean paperFlag = drawList.stream().anyMatch(a -> {
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(a.getDrawType() + ""), (String)"support-defdoc");
                    return DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"code")) && PaperFlagEnum.ARE.getCode().equals(a.getPaperFlag());
                }
                catch (Exception e) {
                    return false;
                }
            });
            if (!paperFlag) continue;
            DcDrwgrpInfoEntity dcDrwgrpInfo = (DcDrwgrpInfoEntity)((Object)this.dcDrwgrpInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)drwgrp.getDrwgrpId())).last("LIMIT 1")));
            int num = drawingApplyFor.getNum();
            int n = surplusNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getSurplusNum()) ? dcDrwgrpInfo.getSurplusNum() : 0;
            if (surplusNum < num) {
                throw new RuntimeException("\u5e93\u5b58\u91cf\u4e0d\u8db3\uff0c\u8bf7\u63a7\u5236\u7b7e\u53d1\u4efd\u6570");
            }
            this.dcDrwgrpInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcDrwgrpInfoEntity::getSurplusNum, (Object)(surplusNum -= num))).eq(BaseEntity::getId, (Object)dcDrwgrpInfo.getId())).eq(BaseEntity::getDr, (Object)0));
            this.dcDrawdistributeInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(DcDrawdistributeInfoEntity::getSurplusNum, (Object)surplusNum)).eq(DcDrawdistributeInfoEntity::getDrwgrpId, (Object)dcDrwgrpInfo.getId())).eq(BaseEntity::getDr, (Object)0));
        }
    }
}

