package com.ejianc.business.basem.service.impl;

import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.bean.ActRuTaskPo;
import com.ejianc.business.basem.service.IActRuExecutionService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.api.IExternalApi;
import com.ejianc.ztpcdata.vo.ActRuTaskVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Classname ActRuExecutionService
 * @Description TODO
 * @Date 2023/4/27 15:33
 * @Created by lijunxue
 */
@Service("actRuTaskService")
public class ActRuTaskService implements IActRuExecutionService {
    @Autowired
    private IExternalApi iExternalApi;


    /**
     * 根据业务id获取到当前节点的类型
     * @param businessKey
     * @return
     */
    public String getNodeType(String businessKey) {
        List<ActRuTaskPo> actRuTaskPos = Lists.newArrayList();
        CommonResponse<List<ActRuTaskVO>> response = iExternalApi.getByBizKey(businessKey);
        if (response.isSuccess()) {
            actRuTaskPos = BeanMapper.mapList(response.getData(), ActRuTaskPo.class);
        }
        if (ToolUtil.isNotEmpty(actRuTaskPos) && actRuTaskPos.size() == 1) {
            return actRuTaskPos.get(0).getDescription();
        } else {
            // 有多个说明 可能出现不同的情况
            return "ERROR";
        }
    }

    /**
     * 根据业务id获取到当前节点的类型（多个）
     * @param businessKey
     * @return
     */
    public List<ActRuTaskPo> getNodeTypes(String businessKey) {
        List<ActRuTaskPo> actRuTaskPos = Lists.newArrayList();
        CommonResponse<List<ActRuTaskVO>> response = iExternalApi.getByBizKey(businessKey);
        if (response.isSuccess()) {
            actRuTaskPos = BeanMapper.mapList(response.getData(), ActRuTaskPo.class);
        }
        if (ToolUtil.isNotEmpty(actRuTaskPos)) {
            return actRuTaskPos;
        }
        return null;
    }
}
