package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.enumUtils.*;
import com.ejianc.business.dc.mapper.DcDrawingApplyForMapper;
import com.ejianc.business.dc.service.*;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeRecordVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoVO;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 卷册信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcDrwgrpInfo")
public class DcDrwgrpInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDcDrwgrpInfoService service;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DcDrawingApplyForMapper dcDrawingApplyForMapper;
    @Autowired
    private IDefdocApi defdocApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> saveOrUpdate(@RequestBody DcDrwgrpInfoVO saveOrUpdateVO) {
        String opType = "";
    	DcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrwgrpInfoEntity.class);

    	//校验同一个项目下卷册名称，卷册编号，卷册版本不能重复
        QueryWrapper<DcDrwgrpInfoEntity> queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ToolUtil.isNotEmpty(entity.getProjectId()),DcDrwgrpInfoEntity::getProjectId, entity.getProjectId())
                .eq(DcDrwgrpInfoEntity::getDr, 0)
                .eq(DcDrwgrpInfoEntity::getDrwgrpCode, entity.getDrwgrpCode())
                .eq(DcDrwgrpInfoEntity::getDrwgrpVsn, entity.getDrwgrpVsn());
        List<DcDrwgrpInfoEntity> list = service.list(queryWrapper);
    	if(entity.getId() == null || entity.getId() == 0){
            entity.setDrwgrpSts(DrwgrpStsEnum.N.getCode());
            entity.setIssueSts(IssueStsEnum.ISSUE.getCode());
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
            opType = "add";
            if (list.size() > 0) {
                throw new BusinessException("该卷册已添加");
            }
        }else {
            opType = "edit";
            if (list.size() > 1) {
                throw new BusinessException("该卷册已添加");
            }
        }
//        //更新子表信息
//        if ("edit".equals(operateType)) {
//            dcDrawInfoService.remove(new QueryWrapper<DcDrawInfoEntity>().lambda()
//                    .eq(DcDrawInfoEntity::getDrwgrpId, entity.getId()));
//
////            dcDrawdistributeDrwgrpinfoService.remove(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
////                    .eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpCode, entity.getDrwgrpCode())
////                    .eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpVsn,entity.getDrwgrpVsn()));
//        }
        List<DcDrawInfoVO> dcDrawInfoEntityList = saveOrUpdateVO.getDcDrawInfoEntityList();
        List<DcDrawInfoEntity> entityList = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
        //校验传过来的是否重复
        entityList.stream().collect(Collectors.groupingBy(e -> e.getDrawCode() + "--" + e.getDrawVsn(),Collectors.toList()))
                .forEach((key,value)->{
                    if (value.size() > 1) {
                        throw new BusinessException("图纸添加重复！");
                    }
        });
        if (entityList.size() > 0) {
            for (DcDrawInfoEntity dcDrawInfoEntity : entityList) {
                dcDrawInfoEntity.setDrwgrpId(entity.getId());
                dcDrawInfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawInfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawInfoEntity.setOrgId(entity.getOrgId());
                dcDrawInfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawInfoEntity.setOrgName(entity.getOrgName());
                dcDrawInfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawInfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawInfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawInfoEntity.setProjectId(entity.getProjectId());
                dcDrawInfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawInfoEntity.setProjectName(entity.getProjectName());
                if (dcDrawInfoEntity.getId() == null || dcDrawInfoEntity.getId() == 0) {
                    dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
                    if (ToolUtil.isEmpty(dcDrawInfoEntity.getPrintStatus())){
                        dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                    }
                    if (ToolUtil.isEmpty(dcDrawInfoEntity.getCheckState())){
                        dcDrawInfoEntity.setCheckState("N");
                    }
                }

                //判断图纸是否添加重复 =================编辑时校验数据库是否已存在
                if ("edit".equals(opType)) {
                    QueryWrapper<DcDrawInfoEntity> dcDrawInfoEntityQueryWrapper = new QueryWrapper();
                    dcDrawInfoEntityQueryWrapper.lambda().eq(ToolUtil.isNotEmpty(entity.getProjectId()),DcDrawInfoEntity::getDrwgrpId, dcDrawInfoEntity.getDrwgrpId())
                            .eq(DcDrawInfoEntity::getDr, 0)
                            .eq(DcDrawInfoEntity::getDrawCode, dcDrawInfoEntity.getDrawCode())
                            .eq(DcDrawInfoEntity::getDrawVsn, dcDrawInfoEntity.getDrawVsn());
                    List<DcDrawInfoEntity> listSon = dcDrawInfoService.list(dcDrawInfoEntityQueryWrapper);
                    if(dcDrawInfoEntity.getId() == null || dcDrawInfoEntity.getId() == 0){
                        if (listSon.size() > 0) {
                            throw new BusinessException("【" + dcDrawInfoEntity.getDrawCode() + "】图纸已添加");
                        }
                    }else {
                        if (listSon.size() > 1) {
                            throw new BusinessException("【" + dcDrawInfoEntity.getDrawCode() + "】图纸已添加");
                        }
                    }
                }
            }
            dcDrawInfoService.saveOrUpdateBatch(entityList, entityList.size(), false);
        }
        entity.setDcDrawInfoEntityList(entityList);


        service.saveOrUpdate(entity, false);
        DcDrwgrpInfoVO vo = BeanMapper.map(entity, DcDrwgrpInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
    * 升版
     * @param fList
    * @return DataResponse
    **/
    @PostMapping("/upgrade")
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> upgrade(@RequestBody DcDrwgrpInfoVO f) {
        DcDrwgrpInfoEntity entity = BeanMapper.map(f, DcDrwgrpInfoEntity.class);
        List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
        List<DcDrawInfoEntity> dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
        entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
        service.upgrade(entity);
        return CommonResponse.success("升版单据成功！");
    }

    /**
     * 添加图纸附件
     * @param f
     * @return
     */
    @PostMapping("/addAttachment")
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoEntity> addAttachment(@RequestBody DcDrwgrpInfoVO f) {
        DcDrwgrpInfoEntity entity = BeanMapper.map(f, DcDrwgrpInfoEntity.class);
        //图纸签发信息
        List<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityList = dcDrawdistributeInfoService.list(new QueryWrapper<DcDrawdistributeInfoEntity>().lambda()
                .eq(DcDrawdistributeInfoEntity::getDrwgrpId, entity.getId())
                .eq(DcDrawdistributeInfoEntity::getDr,0)
        );
        for (DcDrawdistributeInfoEntity infoEntity : dcDrawdistributeInfoEntityList) {
            //删除图纸签发-图纸信息
            dcDrawdistributeDrawinfoService.remove(new QueryWrapper<DcDrawdistributeDrawinfoEntity>().lambda()
                    .eq(DcDrawdistributeDrawinfoEntity::getPid,infoEntity.getId())
                    .eq(DcDrawdistributeDrawinfoEntity::getDr,0)
            );

            //删除图纸签发-签发信息
            dcDrawdistributeDrwgrpinfoService.remove(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                    .eq(DcDrawdistributeDrwgrpinfoEntity::getPid,infoEntity.getId())
                    .eq(DcDrawdistributeDrwgrpinfoEntity::getDr,0)
            );

        }

        //删除图纸签发信息
        dcDrawdistributeInfoService.remove(new QueryWrapper<DcDrawdistributeInfoEntity>().lambda()
                .eq(DcDrawdistributeInfoEntity::getDrwgrpId,entity.getId())
                .eq(DcDrawdistributeInfoEntity::getDr,0)
        );

        entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
        entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());

        for (DcDrawInfoEntity dcDrawInfoEntity : entity.getDcDrawInfoEntityList()) {
            dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
            dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            dcDrawInfoEntity.setCheckState("N");
        }

        service.updateById(entity);
        return CommonResponse.success("添加图纸附件成功！",entity);
    }

    /**
     * 图纸回收
     * @param fList
     * @return DataResponse
     **/
    @PostMapping("/annul")
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> annul(@RequestBody List<DcDrwgrpInfoVO> fList) {
        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityList = new ArrayList<>();
        fList.stream().forEach(f -> {
            DcDrwgrpInfoEntity entity = BeanMapper.map(f, DcDrwgrpInfoEntity.class);
            List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
            List<DcDrawInfoEntity> dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
            entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
            dcDrwgrpInfoEntityList.add(entity);
        });
        service.annul(dcDrwgrpInfoEntityList);
        return CommonResponse.success("作废单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> queryDetail(Long id) {
    	DcDrwgrpInfoEntity entity = service.selectById(id);
    	DcDrwgrpInfoVO vo = BeanMapper.map(entity, DcDrwgrpInfoVO.class);
    	//图纸信息
//        List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
//                .eq(DcDrawInfoEntity::getDrwgrpId, vo.getId()));
//        List<DcDrawInfoVO> dcDrawInfoVOS = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoVO.class);
//        vo.setDcDrawInfoEntityList(dcDrawInfoVOS);
        //签发信息
        List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                .eq(DcDrawdistributeRecordEntity::getDrwgrpId, vo.getId()));
        List<DcDrawdistributeRecordVO> dcDrawdistributeRecordVOList = BeanMapper.mapList(dcDrawdistributeRecordEntityList, DcDrawdistributeRecordVO.class);
        vo.setDcDrawdistributeRecordList(dcDrawdistributeRecordVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrwgrpInfoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DcDrwgrpInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> idList = vos.stream().map(DcDrwgrpInfoVO::getId).collect(Collectors.toList());
        service.removeByIds(idList,true);
        List<DcDrawInfoEntity> list = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda().in(DcDrawInfoEntity::getDrwgrpId, idList));
        if (list.size() > 0) {
            dcDrawInfoService.removeByIds(list.stream().map(DcDrawInfoEntity::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success("删除成功！");
    }

    public static List<String> findUniqueCodes(List<String> list1, List<String> list2) {
        // 创建一个新的List来存储不相同的数字
//        List<String> uniqueNumbers = new ArrayList<>();

        // 遍历第二个List，找出只在第二个List中的元素
        for (String code : list2) {
            if (!list1.contains(code)) {
                list1.add(code);
            }
        }

        return list1;
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("drwgrpCode");
        param.getFuzzyFields().add("drwgrpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<DcDrwgrpInfoEntity> page=new Page<>();
        // 判断用户是否有在查询框查询
        if(param.getSearchText()!=null&&param.getSearchText()!=""){
            // 根据用户输入的查询条件去主表查询数据
            List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = service.queryList(param);
            // 创建一个新的查询对象用于子表查询使用
            QueryParam queryParam = Utils.deepCopy(param);
            queryParam.getFuzzyFields().clear();
            queryParam.getFuzzyFields().add("draw_code");
            // 使用新的查询对象去做子表查询
            List<DcDrawInfoEntity> dcDrawInfoEntities = dcDrawInfoService.queryList(queryParam);
            // 遍历主表里的drwgrpId
            List<String> codes1 = dcDrwgrpInfoEntities.stream().map(dc->Long.toString(dc.getId())).collect(Collectors.toList());
            // 遍历子表表里的drwgrpId
            List<String> codes2 = dcDrawInfoEntities.stream().map(dc -> Long.toString(dc.getDrwgrpId())).collect(Collectors.toList());
            // 获取两个表中不同的drwgrp_code
            List<String> uniqueCodes = findUniqueCodes(codes1, codes2);
            if (uniqueCodes!=null&&uniqueCodes.size()>0){
                page = service.queryPage(uniqueCodes, param);
            }

        }else {
            page=service.queryPage(param,false);
        }
        IPage<DcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrwgrpInfoVO.class));
        pageData.getRecords().stream().forEach(e->{
            e.setDrwgrpStsCn(DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts()).getName());
            e.setIssueStsCn(IssueStsEnum.getEnumByCode(e.getIssueSts()).getName());
        });
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("createTime");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcDrwgrpInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DcDrwgrpInfoVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, DcDrwgrpInfoVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setDrwgrpStsCn(DrwgrpStsEnum.getEnumByCode(vo.getDrwgrpSts()).getName());
                vo.setIssueStsCn(IssueStsEnum.getEnumByCode(vo.getIssueSts()).getName());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("drwgrpInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照   只查询有效，未签发的，库存量大于0的数据，且排除签发信息已存在的卷册信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refDcDrwgrpInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> refDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        String sts = "";
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (StringUtils.isNotBlank(_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.parseLong(_con.getString("projectId"))));
            }
            param.getParams().put("drwgrpSts", new Parameter(QueryParam.EQ, _con.getString("drwgrpSts")));
            if (IssueStsEnum.NOT_ISSUE.getCode().equals(_con.getString("issueSts"))) {
                sts = _con.getString("issueSts");
                param.getParams().put("issueSts", new Parameter(QueryParam.EQ, _con.getString("issueSts")));
            }
            if (IssueStsEnum.ISSUE.getCode().equals(_con.getString("issueSts"))) {
                sts = _con.getString("issueSts");
                List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                        .select("DISTINCT drwgrp_id")
                        .lambda()
                        .eq(StringUtils.isNotBlank(_con.getString("projectId")), DcDrawInfoEntity::getProjectId, _con.getString("projectId"))
                        .eq(DcDrawInfoEntity::getIssueSts, _con.getString("issueSts"))
                        .eq(DcDrawInfoEntity::getDr, 0));
                param.getParams().put("id", new Parameter(QueryParam.IN, dcDrawInfoEntityList.stream().map(DcDrawInfoEntity::getDrwgrpId).filter(Objects::nonNull).collect(Collectors.toList())));
            }
        }

        IPage<DcDrwgrpInfoEntity> page = service.queryPage(param,false);
        IPage<DcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrwgrpInfoVO.class));
        if (StringUtils.isNotBlank(sts)) {
            String finalSts = sts;
            pageData.getRecords().forEach(dcDrwgrpInfoVO -> {
                List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrwgrpId, dcDrwgrpInfoVO.getId())
                        .eq(DcDrawInfoEntity::getIssueSts, finalSts)
                        .eq(DcDrawInfoEntity::getDr, 0));
                dcDrwgrpInfoVO.setDcDrawInfoEntityList(BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoVO.class));
                if (IssueStsEnum.ISSUE.getCode().equals(finalSts)) {
                    List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                            .select(DcDrawdistributeRecordEntity.class, dcDrawdistributeRecordEntity -> !dcDrawdistributeRecordEntity.getColumn().equals("id"))
                            .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrwgrpInfoVO.getId())
                            .eq(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.N.getCode())
                            .eq(DcDrawdistributeRecordEntity::getDr, 0));
                    dcDrwgrpInfoVO.setDcDrawdistributeRecordList(BeanMapper.mapList(dcDrawdistributeRecordEntityList, DcDrawdistributeRecordVO.class));
                }
            });
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 图纸签发
     *
     * @param ids 图纸库信息ID
     * @return 返回对象
     */
    @RequestMapping(value = {"/drawingIssuanceSave","/drawingIssuanceSave/{leaderShip}"}, method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BatchSubmitVO.BatchSubmitDetailVO>> drawingIssuanceSave(@RequestBody List<Long> ids,@PathVariable(value = "leaderShip",required = false) String leaderShip) {
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> drawdistributeIds = service.drawingIssuanceSave(ids,leaderShip);
            return CommonResponse.success("图纸签发成功！", drawdistributeIds);
        } catch (RuntimeException e){
            logger.error("图纸签发失败！错误信息：", e);
            return CommonResponse.error(e.getMessage());
        }
    }

    /**
     * 获取图纸库卷册信息和图纸信息
     *
     * @param ids 卷册ID
     * @return 图纸库卷册信息和图纸信息
     */
    @RequestMapping(value = "/getDrwgrpInfoAndSublist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<DcDrwgrpInfoVO>> getDrwgrpInfoAndSublist(@RequestBody List<Long> ids) {
        /*
         * 查询卷册信息
         */
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityList = service.queryList(param);
        /*
         * 设置每个卷册信息的图纸信息
         */
        dcDrwgrpInfoEntityList.forEach(item -> {
            QueryParam dcDrawInfoParam = new QueryParam();
            dcDrawInfoParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            dcDrawInfoParam.getParams().put("drwgrpId", new Parameter(QueryParam.EQ, item.getId()));
            List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.queryList(dcDrawInfoParam);
            item.setDcDrawInfoEntityList(dcDrawInfoEntityList);
        });
        // 转换Entity为VO
        List<DcDrwgrpInfoVO> dcDrwgrpInfoVOList = BeanMapper.mapList(dcDrwgrpInfoEntityList, DcDrwgrpInfoVO.class);
        // 返回
        return CommonResponse.success(dcDrwgrpInfoVOList);
    }

    /**
     * 添加图纸
     *
     * @param drwgrpId       卷册ID
     * @param dcDrawInfoList 图纸信息
     * @return 返回对象
     */
    @PostMapping("/saveDrawInfo/{drwgrpId}")
    @ResponseBody
    public CommonResponse<Void> saveDrawInfo(@PathVariable Long drwgrpId, @RequestBody List<DcDrawInfoVO> dcDrawInfoList) {
        try {
            service.saveDrawInfo(drwgrpId, dcDrawInfoList);
            return CommonResponse.success();
        } catch (RuntimeException e) {
            if (logger.isErrorEnabled()) {
                logger.error("添加图纸失败！错误信息：", e);
            }
            return CommonResponse.error("添加图纸失败！");
        }
    }

    @RequestMapping(value = "/refDrwgrpInfoTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refDrwgrpInfoTree(
            @RequestParam(required = false) String searchText,
            @RequestParam(required = false) String condition,
            @RequestParam(required = false) Long pid) {

        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return Lists.newArrayList();
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("drwgrpSts", new Parameter(QueryParam.EQ, DrwgrpStsEnum.Y.getCode()));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (StringUtils.isNotBlank(_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.parseLong(_con.getString("projectId"))));
            }
        }

        List<DcDrwgrpInfoEntity> dataList = service.queryList(param);
        List<Map> dataMapList = Lists.newArrayList();
        for (DcDrwgrpInfoEntity data : dataList) {
            Map<String, Object> dataMap = Maps.newHashMap();
            dataMap.put("id", data.getId());
            dataMap.put("name", data.getDrwgrpCode());
            dataMapList.add(dataMap);
        }
        return ResultAsTree.createTreeData(dataMapList);
    }


    /**
     * 制造目录图纸信息
     * @param projectId 项目id
     * @return
     */
    @RequestMapping(value = "/makePrintDataForNum",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> makePrintDataForNum(String projectId){
        List<DcDrwgrpInfoEntity> list = null;//卷册信息
        if (ToolUtil.isEmpty(projectId)) {
            list = service.list(new QueryWrapper<DcDrwgrpInfoEntity>()
                    .lambda()
                    .eq(DcDrwgrpInfoEntity::getDr, 0)
            );
        }else {
            list = service.list(new QueryWrapper<DcDrwgrpInfoEntity>()
                    .lambda()
                    .eq(DcDrwgrpInfoEntity::getDr,0)
                    .eq(DcDrwgrpInfoEntity::getProjectId,projectId)
            );
        }
        Long drawTypeId = null;//图纸类型-目录id
        CommonResponse<List<Map<String, Object>>> drawType = defdocApi.queryDetailListByDefdocCode("draw_type", null);
        if (drawType.isSuccess()){
            if (drawType.getData().size() > 0){
                for (Map<String, Object> map : drawType.getData()) {
                    if ("目录".equals(map.get("description"))){
                        drawTypeId = Long.valueOf(map.get("id").toString());
                    }
                }
            }else {
                return CommonResponse.error("未找到自定义档案");
            }

        }else {
            return CommonResponse.error("未找到自定义档案");
        }

        if (drawTypeId == null){
            return CommonResponse.error("未找到自定义档案-目录");
        }

        for (DcDrwgrpInfoEntity dcDrwgrpInfoEntity : list) {
            //图纸信息数据
            List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                    .lambda()
                    .eq(DcDrawInfoEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                    .eq(DcDrawInfoEntity::getDr, 0)
            );
            //是否需要添加目录-没有目录就需要添加目录
            boolean flag = dcDrawInfoEntityList.stream().anyMatch(a -> {
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                    return DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"));
                } catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            });

            //添加目录图纸信息
            if (!flag){
                //图纸信息
                DcDrawInfoEntity dcDrawInfoEntity = new DcDrawInfoEntity();
                dcDrawInfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
                dcDrawInfoEntity.setDrawCode(dcDrwgrpInfoEntity.getDrwgrpCode()+"-1");
                dcDrawInfoEntity.setDrawName(dcDrwgrpInfoEntity.getDrwgrpName());
                dcDrawInfoEntity.setDrawType(drawTypeId);
                dcDrawInfoEntity.setDrawVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                dcDrawInfoEntity.setPaperFlag("Y");
                dcDrawInfoEntity.setDrwgrpId(dcDrwgrpInfoEntity.getId());
                dcDrawInfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
                dcDrawInfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                dcDrawInfoEntity.setCheckState("N");
                dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
                boolean b = dcDrawInfoService.save(dcDrawInfoEntity);

                if (b) {
                    //图纸签发对应数据
                    List<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityList = dcDrawdistributeInfoService.list(new QueryWrapper<DcDrawdistributeInfoEntity>()
                            .lambda()
                            .eq(DcDrawdistributeInfoEntity::getDr, 0)
                            .eq(DcDrawdistributeInfoEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                    );

                    for (DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity : dcDrawdistributeInfoEntityList) {
                        //图纸签发-图纸信息
                        DcDrawdistributeDrawinfoEntity dcDrawdistributeDrawinfoEntity = new DcDrawdistributeDrawinfoEntity();
                        dcDrawdistributeDrawinfoEntity.setPid(dcDrawdistributeInfoEntity.getId());
                        dcDrawdistributeDrawinfoEntity.setDrawId(dcDrawInfoEntity.getId());
                        dcDrawdistributeDrawinfoEntity.setDrwgrpId(dcDrwgrpInfoEntity.getId());
                        dcDrawdistributeDrawinfoEntity.setDrawCode(dcDrwgrpInfoEntity.getDrwgrpCode()+"-1");
                        dcDrawdistributeDrawinfoEntity.setDrawName(dcDrwgrpInfoEntity.getDrwgrpName());
                        dcDrawdistributeDrawinfoEntity.setDrawVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                        dcDrawdistributeDrawinfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
                        dcDrawdistributeDrawinfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                        dcDrawdistributeDrawinfoEntity.setDrawType(drawTypeId);
                        dcDrawdistributeDrawinfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
                        dcDrawdistributeDrawinfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                        dcDrawdistributeDrawinfoEntity.setPaperFlag("Y");
                        boolean c = dcDrawdistributeDrawinfoService.save(dcDrawdistributeDrawinfoEntity);

                        //清空分发单号
                        if (c){
                            dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                    .lambda()
                                    .eq(DcDrawdistributeInfoEntity::getId,dcDrawdistributeInfoEntity.getId())
                                    .set(DcDrawdistributeInfoEntity::getDistCode,"")
                            );
                        }
                    }
                }

            }
        }

        return CommonResponse.success();
    }
}
