package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dc.bean.CtOtherFileTakeEntity;
import com.ejianc.business.dc.controller.CtOtherFileTakeController;
import com.ejianc.business.dc.mapper.CtOtherFileTakeMapper;
import com.ejianc.business.dc.service.ICtOtherFileTakeService;
import com.ejianc.business.dc.vo.CtOtherFileTakeVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 其他文件取号
 *
 * @author generator
 */
@Service("ctOtherFileTakeService")
public class CtOtherFileTakeServiceImpl extends BaseServiceImpl<CtOtherFileTakeMapper, CtOtherFileTakeEntity> implements ICtOtherFileTakeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;//取号规则api

    @Override
    public CtOtherFileTakeVO saveOrUpdate(CtOtherFileTakeVO saveOrUpdateVO) {
        // 取号信息
        CommonResponse<BillCodeApiVO> snCommonResponse = new CommonResponse<>();
        CtOtherFileTakeEntity entity = BeanMapper.map(saveOrUpdateVO, CtOtherFileTakeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setId(IdWorker.getId());
            /*
             * 1.生成单据编号
             */
            BillCodeParam billCodeParam = BillCodeParam.build(CtOtherFileTakeController.BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            /*
             * 2.生成内外部编码
             */
            BillCodeApiVO apiVO = new BillCodeApiVO();
            // 项目id
            apiVO.setProjectId(entity.getProjectId());
            // 项目编码
            apiVO.setProjectCode(entity.getProjectCode());
            // 项目名称
            apiVO.setProjectName(entity.getProjectName());
            // 文档分类主键Id
            apiVO.setCategoryId(entity.getAttribute());

            List<BillCodeRuleSNVO> snVoList = new ArrayList<>();

            BillCodeRuleSNVO outSnVO = new BillCodeRuleSNVO();
            // 来源单据主表id
            outSnVO.setSourcePid(entity.getId());
            // 来源单据编码
            outSnVO.setSourceCode(entity.getCode());
            // 来源单据类型
            outSnVO.setSourceType("BT231011000000001");
            // 来源单据类型名称
            outSnVO.setSourceTypeName("其他文件取号");
            try {
//                if (Objects.isNull(entity.getFileType()) || Objects.isNull(entity.getSpecialty())
//                        || Objects.isNull(entity.getMaterialType()) || Objects.isNull(entity.getSys())
//                        || Objects.isNull(entity.getSubItem()) || Objects.isNull(entity.getMainActivities())
//                        || Objects.isNull(entity.getSubentryActivities()) || Objects.isNull(entity.getPrincipalItem())) {
//                    throw new RuntimeException("内部编码和外部编码取号元素为空！");
//                }
                if (Objects.nonNull(entity.getFileType())) {
                    JSONArray fileTypeReferValue = ReferObjectUtil.getReferEntityValue(entity.getFileType() + "", "data-dictionary");
                    JSONObject fileTypeRef = (JSONObject) fileTypeReferValue.get(0);
                    outSnVO.setRule18(fileTypeRef.getString("code"));//Rule18文件类型
                }
                if (Objects.nonNull(entity.getSpecialty())) {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(entity.getSpecialty() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) specialtyReferValue.get(0);
                    outSnVO.setRule05(specialtyRef.getString("code"));//Rule05专业
                }
                if (Objects.nonNull(entity.getMaterialType())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getMaterialType() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule17(specialtyRef.getString("code"));//Rule17材料类型
                }
                if (Objects.nonNull(entity.getSys())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSys() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule14(specialtyRef.getString("code"));//Rule14系统
                }
                if (Objects.nonNull(entity.getSubItem())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSubItem() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule16(specialtyRef.getString("code"));//Rule16子项
                }
                if (Objects.nonNull(entity.getMainActivities())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getMainActivities() + "", "data-dictionary-category");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule11(specialtyRef.getString("code"));//Rule11主要活动
                }
                if (Objects.nonNull(entity.getSubentryActivities())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSubentryActivities() + "", "data-dictionary-category");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule10(specialtyRef.getString("code"));//Rule10分项活动
                }
                if (Objects.nonNull(entity.getPrincipalItem())) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getPrincipalItem() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule15(specialtyRef.getString("code"));//Rule15主要种类
                }
                //规则类型，0内部编码，1外部编码
                outSnVO.setRuleType(RuleTypeEnum.外部编码.getCode());
                snVoList.add(outSnVO);
                //规则类型，0内部编码，1外部编码
                BillCodeRuleSNVO outSnNb = BeanMapper.map(outSnVO, BillCodeRuleSNVO.class);
                outSnNb.setRuleType(RuleTypeEnum.内部编码.getCode());
                snVoList.add(outSnNb);
            } catch (Exception e) {
                throw new BusinessException(String.format("取号失败！错误信息：[%s]", e.getMessage()));
            }
            apiVO.setSnList(snVoList);
            snCommonResponse = billCodeRuleApi.generateBillCode(apiVO);
            if (!snCommonResponse.isSuccess()) {
                throw new RuntimeException(String.format("取号失败！错误信息：[%s]", snCommonResponse.getMsg()));
            } else {
                List<BillCodeRuleSNVO> snList = snCommonResponse.getData().getSnList();
                for (BillCodeRuleSNVO codeSnVO : snList) {
                    if (RuleTypeEnum.外部编码.getCode().equals(codeSnVO.getRuleType())) {
                        entity.setFileCode(codeSnVO.getGenerateBillCode());
                    } else if (RuleTypeEnum.内部编码.getCode().equals(codeSnVO.getRuleType())) {
                        entity.setFileInternalCode(codeSnVO.getGenerateBillCode());
                    }
                }
            }
        }
        boolean b = saveOrUpdate(entity, false);
        if (b && Objects.nonNull(snCommonResponse.getData())) {
            //业务单据保持成功后，提交取号
            BillCodeApiVO responseData = snCommonResponse.getData();
            billCodeRuleApi.commitBillCode(responseData);
        }
        return BeanMapper.map(entity, CtOtherFileTakeVO.class);
    }

    @Override
    public void delete(List<CtOtherFileTakeVO> vos) {
        Map<String, Object> sourceIds = Maps.newHashMap();
        List<Long> idList = Lists.newArrayList();

        if (ListUtil.isNotEmpty(vos)) {
            for (CtOtherFileTakeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids", idList);
        CommonResponse commonResponse = billCodeRuleApi.releaseBillCode(sourceIds);
        if (commonResponse.isSuccess()) {
            removeByIds(vos.stream().map(CtOtherFileTakeVO::getId).collect(Collectors.toList()), true);
        } else {
            throw new RuntimeException("还号失败！错误信息：" + commonResponse.getMsg());
        }
    }
}
