package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.bean.ActRuTaskPo;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.settle.api.ISettlementCenterDcDrwgrpInfoApi;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("dcDrwgrpInfo") 
public class DcDrwgrpInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	private DcDrwgrpInfoMapper dcDrwgrpInfoMapper;
	@Autowired
	private ISettlementCenterDcDrwgrpInfoApi settlementCenterDcDrwgrpInfoApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
		} else {
			nodeType = "ERROR";
		}
		logger.info("beforeSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		/*
		 * 修改流程状态为“待技术录入”
		 */
		UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, billId)
				.set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.ONE.getCode())
				.set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.ONE.getName());
		this.dcDrwgrpInfoMapper.update(null, updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		/*
		 * 修改流程状态为“待技术录入”
		 */
		UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, billId)
				.set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.ZERO.getCode())
				.set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.ZERO.getName());
		this.dcDrwgrpInfoMapper.update(null, updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
		String nodeType;
		if (ToolUtil.isNotEmpty(actRuTaskPos)) {
			nodeType = actRuTaskPos.get(0).getDescription();
		} else {
			nodeType = "ERROR";
		}
		logger.info("afterApprovalProcessor图纸库数据终审后回调，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.dcDrwgrpInfoMapper.selectById(billId);
		if(null != dcDrwgrpInfoEntity) {
			UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfoEntity.getId())
					.set(DcDrwgrpInfoEntity::getDrwgrpSts, DrwgrpStsEnum.Y.getCode())
					.set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
					.set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName());
			int update = this.dcDrwgrpInfoMapper.update(null, updateWrapper);
			if (update != 1) {
				throw new BusinessException("更新数据失败!");
			}
		}

		SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO = new SettlementCenterDcDrwgrpInfoVO();
		settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoId(billId);
		settlementCenterDcDrwgrpInfoVO.setFirstNodeTime(new Date());
		settlementCenterDcDrwgrpInfoVO.setOrgId(dcDrwgrpInfoEntity.getOrgId());
		settlementCenterDcDrwgrpInfoVO.setOrgCode(dcDrwgrpInfoEntity.getOrgCode());
		settlementCenterDcDrwgrpInfoVO.setOrgName(dcDrwgrpInfoEntity.getOrgName());
		settlementCenterDcDrwgrpInfoVO.setParentOrgId(dcDrwgrpInfoEntity.getParentOrgId());
		settlementCenterDcDrwgrpInfoVO.setParentOrgCode(dcDrwgrpInfoEntity.getParentOrgCode());
		settlementCenterDcDrwgrpInfoVO.setParentOrgName(dcDrwgrpInfoEntity.getParentOrgName());
		settlementCenterDcDrwgrpInfoVO.setProjectId(dcDrwgrpInfoEntity.getProjectId());
		settlementCenterDcDrwgrpInfoVO.setProjectCode(dcDrwgrpInfoEntity.getProjectCode());
		settlementCenterDcDrwgrpInfoVO.setProjectName(dcDrwgrpInfoEntity.getProjectName());
		settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoCode(dcDrwgrpInfoEntity.getDrwgrpCode());
		settlementCenterDcDrwgrpInfoVO.setFlowState(SettleFlowStateEnum.ONE.getCode());
		settlementCenterDcDrwgrpInfoVO.setFlowStateName(SettleFlowStateEnum.ONE.getName());
		settlementCenterDcDrwgrpInfoVO.setWhetherUpgrade(0);
		settlementCenterDcDrwgrpInfoApi.saveOrUpdateSettlementCenterDcDrwgrpInfo(settlementCenterDcDrwgrpInfoVO);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
