package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.FwFlowStateEnum;
import com.ejianc.business.dc.enumUtils.RuleElemType;
import com.ejianc.business.dc.enumUtils.SubmitTypeEnum;
import com.ejianc.business.dc.mapper.DcSendFileMapper;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 发文管理
 * 
 * @author generator
 * 
 */
@Service("dcSendFileService")
public class DcSendFileServiceImpl extends BaseServiceImpl<DcSendFileMapper, DcSendFileEntity> implements IDcSendFileService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";//此处需要根据实际修改
    @Autowired
    private IDcSendFileService service;

    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;//取号规则api

    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;

    /**
     * @description:将旧版本文件状态置为无效
     * @author: chengminggao
     * @date: 2023/6/1 10:32
     * @param: [entity]
     * @return: boolean
     **/
    @Override
    public boolean upgradeFileSts(DcSendFileEntity entity) {
        // 发文管理-修改流程状态为“已升版”
        this.update(
                new UpdateWrapper<DcSendFileEntity>()
                        .lambda()
                        .set(DcSendFileEntity::getFlowState, FwFlowStateEnum.TWENTY_TWO.getCode())
                        .set(DcSendFileEntity::getFlowStateName, FwFlowStateEnum.TWENTY_TWO.getName())
                        .eq(DcSendFileEntity::getDr, 0)
                        .eq(DcSendFileEntity::getId, entity.getId())
        );
        // 文件分发中心-修改流程状态为“已升版”
        dcFiledistributeCenterService.update(
                new UpdateWrapper<DcFiledistributeCenterEntity>()
                        .lambda()
                        .set(DcFiledistributeCenterEntity::getFlowState, FwFlowStateEnum.TWENTY_TWO.getCode())
                        .set(DcFiledistributeCenterEntity::getFlowStateName, FwFlowStateEnum.TWENTY_TWO.getName())
                        .eq(DcFiledistributeCenterEntity::getDr, 0)
                        .eq(DcFiledistributeCenterEntity::getSourceId, entity.getId())
        );
        return true;
    }

    @Override
    public CommonResponse<DcSendFileVO> saveOrUpdate(DcSendFileVO saveOrUpdateVO) {
        DcSendFileEntity entity = BeanMapper.map(saveOrUpdateVO, DcSendFileEntity.class);
        boolean flag = true;//是否修改
        if (entity.getId() == null || entity.getId() == 0) {
            flag = false;
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
        }
        // 流程状态
        if (ToolUtil.isEmpty(entity.getFlowState())) {
            // 设置为“草稿状态”
            entity.setFlowState(FwFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(FwFlowStateEnum.ZERO.getName());
        }

        //如果是新增，则取号，如果是修改则不取号
        if (!flag) {
            //先取号
            BillCodeApiVO apiVO = new BillCodeApiVO();
            apiVO.setProjectId(entity.getProjectId());//项目id
            apiVO.setProjectCode(entity.getProjectCode());//项目编码
            apiVO.setProjectName(entity.getProjectName());//项目名称
            apiVO.setCategoryId(entity.getFiletype());//文件类型

            List<BillCodeRuleSNVO> snVoList = new ArrayList<>();
            BillCodeRuleSNVO outSnVO = new BillCodeRuleSNVO();
            outSnVO.setSourcePid(entity.getId());
            outSnVO.setSourceCode(entity.getBillCode());
            outSnVO.setSourceType("BT230411000000004");
            outSnVO.setSourceTypeName("发文管理");

            boolean wbSign = true;
            boolean nbSign = true;
            /*
             * 是否生成外部编码和内部编码
             * “报审”、“报备”：内部编码取号规则中规定的字段，必须全部填写，否则不生产内部编码
             * “内部发布”：外部编码不生成
             * “发函管理”：内部编码不生成
             */
            if (SubmitTypeEnum.A.getCode().equals(entity.getSubmitTypeCode()) || SubmitTypeEnum.B.getCode().equals(entity.getSubmitTypeCode())) {
                // 查询内部编码的取号规则
                CommonResponse<BillCodeRuleVO> billCodeRule = billCodeRuleApi.getBillCodeRule(entity.getProjectId(), entity.getFiletype(), RuleTypeEnum.内部编码.getCode());
                /*
                 * 内部编码取号规则中规定的字段，必须全部填写，否则不生产内部编码
                 */
                if (billCodeRule.isSuccess() && ToolUtil.isNotEmpty(billCodeRule.getData())
                        && ToolUtil.isNotEmpty(billCodeRule.getData().getBillCodeRuleAttrList())) {
                    // “自定义流水依据”字段数量
                    AtomicInteger count = new AtomicInteger();
                    /*
                     * “自定义流水依据”字段的页面填写不为空的取号规则
                     */
                    List<BillCodeRuleAttrVO> billCodeRuleAttrList = billCodeRule.getData().getBillCodeRuleAttrList()
                            .stream().filter(a -> {
                                if (RuleElemType.自定义流水依据.getCode().equals(a.getRuleElemType())) {
                                    count.getAndIncrement();
                                    try {
                                        return ToolUtil.isNotEmpty(getRuleElemValue(entity, a.getRuleElemCode()));
                                    } catch (Exception e) {
                                        throw new BusinessException("取号错误；请检查取号规则配置");
                                    }
                                }
                                return false;
                            }).collect(Collectors.toList());
                    // “自定义流水依据”字段数量必须等于“自定义流水依据”字段的页面填写不为空的取号规则数量
                    if (ToolUtil.isEmpty(billCodeRuleAttrList) || count.get() != billCodeRuleAttrList.size()) {
                        nbSign = false;
                    }
                } else {
                    nbSign = false;
                }
            } else if (SubmitTypeEnum.C.getCode().equals(entity.getSubmitTypeCode())) {
                wbSign = false;
            }else if(StringUtils.isEmpty(entity.getSubmitTypeCode())){
                nbSign = false;
            }
            try {
                if (entity.getSpecialty() != null) {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(entity.getSpecialty() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) specialtyReferValue.get(0);
                    outSnVO.setRule05(specialtyRef.getString("code"));//Rule05专业
                }
                if (entity.getMgrp() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getMgrp() + "", "data-dictionary");
                    JSONObject mgrpSpecialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule07(mgrpSpecialtyRef.getString("code"));//Rule07机组
                }
                if (entity.getDeptShortName() != null) {
                    outSnVO.setRule08(entity.getDeptShortName());//Rule08部门
                }
                if (entity.getMainActivities() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getMainActivities() + "", "data-dictionary-category");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule11(specialtyRef.getString("code"));//Rule11主要活动
                }
                if (entity.getSubentryActivities() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSubentryActivities() + "", "data-dictionary-category");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule10(specialtyRef.getString("code"));//Rule10分项活动
                }
                if (entity.getPrincipalItem() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getPrincipalItem() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule15(specialtyRef.getString("code"));//Rule15主要种类
                }
                if (entity.getCmitTypeCode() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getCmitTypeCode() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule09(specialtyRef.getString("code"));//Rule09通信类型代码
                }
                if (entity.getReceiverCmitCode() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getReceiverCmitCode() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule13(specialtyRef.getString("code"));//Rule13收文方通讯代码
                }
                if (entity.getSys() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSys() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule14(specialtyRef.getString("code"));//Rule14系统
                }
                if (entity.getSubItem() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSubItem() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule16(specialtyRef.getString("code"));//Rule16子项
                }
                if (entity.getMaterialType() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getMaterialType() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule17(specialtyRef.getString("code"));//Rule17材料类型
                }
                if (entity.getUnitProjCodeId() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getUnitProjCodeId() + "", "data-dictionary");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule19(specialtyRef.getString("code"));//Rule19单位工程代码
                }
                if (entity.getJobCode() != null) {
                    JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getJobCode() + "", "data-dictionary-category");
                    JSONObject specialtyRef = (JSONObject) referEntityValue.get(0);
                    outSnVO.setRule20(specialtyRef.getString("code"));//Rule20作业编码
                }
                if (wbSign) {
                    //规则类型，0内部编码，1外部编码
                    outSnVO.setRuleType(RuleTypeEnum.外部编码.getCode());
                    snVoList.add(outSnVO);
                }
                if (nbSign) {
                    //规则类型，0内部编码，1外部编码
                    BillCodeRuleSNVO outSnNb = BeanMapper.map(outSnVO, BillCodeRuleSNVO.class);
                    outSnNb.setRuleType(RuleTypeEnum.内部编码.getCode());
                    snVoList.add(outSnNb);
                }
            } catch (Exception e) {
                logger.info(e.getMessage(),"referCode:data-dictionary转换出错");
                throw new BusinessException("referCode:data-dictionary id：" + entity.getSpecialty() + "转换出错");
            }
            apiVO.setSnList(snVoList);
            CommonResponse<BillCodeApiVO> snCommonResponse = billCodeRuleApi.generateBillCode(apiVO);
            if (!snCommonResponse.isSuccess()) {
                return CommonResponse.error(snCommonResponse.getMsg());
            } else {
                List<BillCodeRuleSNVO> snList = snCommonResponse.getData().getSnList();
                for (BillCodeRuleSNVO codeSnVO : snList) {
                    if (RuleTypeEnum.外部编码.getCode().equals(codeSnVO.getRuleType())) {
                        entity.setFileCode(codeSnVO.getGenerateBillCode());
                    } else if (RuleTypeEnum.内部编码.getCode().equals(codeSnVO.getRuleType())) {
                        entity.setFileInternalCode(codeSnVO.getGenerateBillCode());
                    }
                }
            }
            boolean b = service.saveOrUpdate(entity, false);
            if (b) {
                //业务单据保持成功后，提交取号
                BillCodeApiVO responseData = snCommonResponse.getData();
                billCodeRuleApi.commitBillCode(responseData);
            }
        }else {
            service.saveOrUpdate(entity, false);
        }
        DcSendFileVO vo = BeanMapper.map(entity, DcSendFileVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<String> delete(List<DcSendFileVO> vos) {
        Map sourceIds = new HashMap<String, Object>() ;
        List idList = new ArrayList<String>();

        if(ListUtil.isNotEmpty(vos)){
            for (DcSendFileVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids",idList);
        CommonResponse commonResponse = billCodeRuleApi.releaseBillCode(sourceIds);
        if(commonResponse.isSuccess()){
            service.removeByIds(vos.stream().map(DcSendFileVO::getId).collect(Collectors.toList()),true);
            return CommonResponse.success("删除成功！");
        }else{
            return CommonResponse.error(commonResponse.getMsg());
        }

    }

    /**
     * 获取取号规则元素字段值
     *
     * @param entity       数据源
     * @param ruleElemCode 取号规则的元素字段code
     * @return 取号规则元素字段值
     * @throws Exception
     */
    private Object getRuleElemValue(DcSendFileEntity entity, String ruleElemCode) throws Exception {
        Object value = null;
        if ("rule05".equals(ruleElemCode)) {
            value = entity.getSpecialty();
        } else if ("rule07".equals(ruleElemCode)) {
            value = entity.getMgrp();
        } else if ("rule08".equals(ruleElemCode)) {
            value = entity.getDeptShortName();
        } else if ("rule11".equals(ruleElemCode)) {
            value = entity.getMainActivities();
        } else if ("rule10".equals(ruleElemCode)) {
            value = entity.getSubentryActivities();
        } else if ("rule15".equals(ruleElemCode)) {
            value = entity.getPrincipalItem();
        } else if ("rule09".equals(ruleElemCode)) {
            value = entity.getCmitTypeCode();
        } else if ("rule13".equals(ruleElemCode)) {
            value = entity.getReceiverCmitCode();
        } else if ("rule14".equals(ruleElemCode)) {
            value = entity.getSys();
        } else if ("rule16".equals(ruleElemCode)) {
            value = entity.getSubItem();
        } else if ("rule17".equals(ruleElemCode)) {
            value = entity.getMaterialType();
        } else if ("rule19".equals(ruleElemCode)) {
            value = entity.getUnitProjCodeId();
        } else if ("rule20".equals(ruleElemCode)) {
            value = entity.getJobCode();
        }
        return value;
    }
}
