package com.ejianc.business.dc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * 图纸信息
 *
 * @author generator
 */
public class DcDrawInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String drawCode; // 图纸编号
    private String drawName; // 图纸名称
    private String drawVsn; // 图纸版本
    private String drwgrpCode; // 卷册编号
    private String drwgrpVsn; // 卷册版本
    private Long drawType; // 图纸类型
    private String transferCode; // 传递单号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date drawArriveDate; // 到图日期
    private String issueSts; // 签发状态
    private String drawAttachment; // 图纸附件
    private Long createDeptId; // 创建部门id
    private Long orgId; // 所属组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long drwgrpId; // 卷册ID
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String printStatus; // 打印状态（0：未打印，2：已打印）
    private String paperFlag; // 是否纸质版（Y：是，N：否）
    private String otherAttachment; // 文件ID（逗号分隔）
    private String checkState; // 会检状态（Y：已会检，N：未会检）
    private String drawSts;//图纸状态(Y:有效N:无效)

    public Long getDrwgrpId() {
        return drwgrpId;
    }

    public void setDrwgrpId(Long drwgrpId) {
        this.drwgrpId = drwgrpId;
    }

    public String getDrawCode() {
        return drawCode;
    }

    public void setDrawCode(String drawCode) {
        this.drawCode = drawCode;
    }

    public String getDrawName() {
        return drawName;
    }

    public void setDrawName(String drawName) {
        this.drawName = drawName;
    }

    public String getDrawVsn() {
        return drawVsn;
    }

    public void setDrawVsn(String drawVsn) {
        this.drawVsn = drawVsn;
    }

    public String getDrwgrpCode() {
        return drwgrpCode;
    }

    public void setDrwgrpCode(String drwgrpCode) {
        this.drwgrpCode = drwgrpCode;
    }

    public String getDrwgrpVsn() {
        return drwgrpVsn;
    }

    public void setDrwgrpVsn(String drwgrpVsn) {
        this.drwgrpVsn = drwgrpVsn;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDrawType() {
        return drawType;
    }

    @ReferDeserialTransfer
    public void setDrawType(Long drawType) {
        this.drawType = drawType;
    }

    public String getTransferCode() {
        return transferCode;
    }

    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public Date getDrawArriveDate() {
        return drawArriveDate;
    }

    public void setDrawArriveDate(Date drawArriveDate) {
        this.drawArriveDate = drawArriveDate;
    }

    public String getIssueSts() {
        return issueSts;
    }

    public void setIssueSts(String issueSts) {
        this.issueSts = issueSts;
    }

    public String getDrawAttachment() {
        return drawAttachment;
    }

    public void setDrawAttachment(String drawAttachment) {
        this.drawAttachment = drawAttachment;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCreateDeptId() {
        return createDeptId;
    }

    @ReferDeserialTransfer
    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }

    /**
     * 组织ID
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织ID
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPrintStatus() {
        return printStatus;
    }

    public void setPrintStatus(String printStatus) {
        this.printStatus = printStatus;
    }

    public String getPaperFlag() {
        return paperFlag;
    }

    public void setPaperFlag(String paperFlag) {
        this.paperFlag = paperFlag;
    }

    public String getOtherAttachment() {
        return otherAttachment;
    }

    public void setOtherAttachment(String otherAttachment) {
        this.otherAttachment = otherAttachment;
    }

    public String getCheckState() {
        return checkState;
    }

    public void setCheckState(String checkState) {
        this.checkState = checkState;
    }

    public String getDrawSts() {
        return drawSts;
    }

    public void setDrawSts(String drawSts) {
        this.drawSts = drawSts;
    }
}
