/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeRecordEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.DcLssueAddressBookEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IDcLssueAddressBookService;
import com.ejianc.business.dc.vo.DcDrawdistributeDrwgrpinfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookDetailVO;
import com.ejianc.business.dc.vo.DcLssueAddressBookVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcDrawdistributeInfo"})
public class DcDrawdistributeInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    public static final String BILL_CODE = "DC_DRAWDISTRIBUTE_INFO";
    @Autowired
    private IDcDrawdistributeInfoService service;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private IDcLssueAddressBookService dcLssueAddressBookService;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> saveOrUpdate(@RequestBody DcDrawdistributeInfoVO saveOrUpdateVO) {
        List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoEntityList;
        List entityList;
        DcDrawdistributeInfoEntity entity = (DcDrawdistributeInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcDrawdistributeInfoEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setFlowState(TzFlowStateEnum.TWO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.TWO.getName());
            this.dcDrawInfoService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DcDrawInfoEntity::getDrwgrpId, (Object)saveOrUpdateVO.getDrwgrpId())).set(DcDrawInfoEntity::getIssueSts, (Object)IssueStsEnum.NOT_ISSUE.getCode()));
            entity.getDcDrawdistributeDrawinfoList().forEach(dcDrawdistributeDrawinfoEntity -> {
                dcDrawdistributeDrawinfoEntity.setId(null);
                dcDrawdistributeDrawinfoEntity.setCreateDeptId(entity.getCreateDeptId());
            });
        }
        if ((entityList = BeanMapper.mapList(dcDrawdistributeDrwgrpinfoEntityList = saveOrUpdateVO.getDcDrawdistributeDrwgrpinfoEntityList(), DcDrawdistributeDrwgrpinfoEntity.class)).size() > 0) {
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : entityList) {
                dcDrawdistributeDrwgrpinfoEntity.setPid(entity.getId());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpId(entity.getDrwgrpId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgId(entity.getOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setOrgName(entity.getOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setProjectId(entity.getProjectId());
                dcDrawdistributeDrwgrpinfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawdistributeDrwgrpinfoEntity.setProjectName(entity.getProjectName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpName(entity.getDrwgrpName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpType(entity.getDrwgrpType());
                dcDrawdistributeDrwgrpinfoEntity.setMgrp(entity.getMgrp());
                dcDrawdistributeDrwgrpinfoEntity.setSpecialty(entity.getSpecialty());
            }
        }
        entity.setDcDrawdistributeDrwgrpinfoEntityList(entityList);
        this.service.saveOrUpdate((Object)entity, false);
        entity.getDcDrawdistributeDrawinfoList().forEach(dcDrawdistributeDrawinfoEntity -> this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(dcDrawdistributeDrawinfoEntity.getDrawId()), "BT230602000000005", "otherAttachment", String.valueOf(dcDrawdistributeDrawinfoEntity.getId()), "BT230602000000002", "otherAttachment"));
        DcDrawdistributeInfoVO vo = (DcDrawdistributeInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrawdistributeInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/fill_issue"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> fill_issue(@RequestBody DcDrawdistributeInfoVO saveOrUpdateVO) {
        DcDrawdistributeInfoEntity entity = (DcDrawdistributeInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcDrawdistributeInfoEntity.class));
        String operateType = entity.getId() == null || entity.getId() == 0L ? "add" : "edit";
        List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoEntityList = saveOrUpdateVO.getDcDrawdistributeDrwgrpinfoEntityList();
        List entityList = BeanMapper.mapList(dcDrawdistributeDrwgrpinfoEntityList, DcDrawdistributeDrwgrpinfoEntity.class);
        if (entityList.size() > 0) {
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : entityList) {
                dcDrawdistributeDrwgrpinfoEntity.setPid(entity.getId());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpId(entity.getDrwgrpId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgId(entity.getOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setOrgName(entity.getOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawdistributeDrwgrpinfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawdistributeDrwgrpinfoEntity.setProjectId(entity.getProjectId());
                dcDrawdistributeDrwgrpinfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawdistributeDrwgrpinfoEntity.setProjectName(entity.getProjectName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpName(entity.getDrwgrpName());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawdistributeDrwgrpinfoEntity.setDrwgrpType(entity.getDrwgrpType());
                dcDrawdistributeDrwgrpinfoEntity.setMgrp(entity.getMgrp());
                dcDrawdistributeDrwgrpinfoEntity.setSpecialty(entity.getSpecialty());
            }
        }
        entity.setDcDrawdistributeDrwgrpinfoEntityList(entityList);
        this.service.saveOrUpdate((Object)entity, false);
        DcDrawdistributeInfoVO vo = (DcDrawdistributeInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrawdistributeInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> queryDetail(Long id) {
        DcDrawdistributeInfoEntity entity = (DcDrawdistributeInfoEntity)((Object)this.service.selectById(id));
        DcDrawdistributeInfoVO vo = (DcDrawdistributeInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrawdistributeInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrawdistributeInfoVO> vos) {
        List idList = vos.stream().map(DcDrawdistributeInfoVO::getId).collect(Collectors.toList());
        List entityList = this.service.list((Wrapper)new QueryWrapper().lambda().in(DcDrawdistributeInfoEntity::getId, idList));
        this.service.removeByIds(idList, true);
        this.dcDrawInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().in(DcDrawInfoEntity::getDrwgrpId, (Collection)entityList.stream().map(DcDrawdistributeInfoEntity::getDrwgrpId).collect(Collectors.toList()))).set(DcDrawInfoEntity::getIssueSts, (Object)IssueStsEnum.ISSUE.getCode())).set(DcDrawInfoEntity::getPrintStatus, (Object)PrintStatusEnum.PRINT.getCode()));
        this.dcDrawdistributeRecordService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().in(DcDrawdistributeRecordEntity::getDrwgrpId, (Collection)entityList.stream().map(DcDrawdistributeInfoEntity::getDrwgrpId).collect(Collectors.toList()))).set(BaseEntity::getDr, (Object)1));
        this.dcDrwgrpInfoService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().in(BaseEntity::getId, (Collection)entityList.stream().map(DcDrawdistributeInfoEntity::getDrwgrpId).collect(Collectors.toList()))).set(DcDrwgrpInfoEntity::getIssueSts, (Object)IssueStsEnum.ISSUE.getCode()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeInfoVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("drwgrpCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("drwgrpVsn");
        param.getFuzzyFields().add("drwgrpName");
        param.getFuzzyFields().add("distCode");
        param.getFuzzyFields().add("distUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrawdistributeInfoVO.class));
        pageData.getRecords().forEach(e -> {
            String drwgrpStsCn = ToolUtil.isNotEmpty((Object)DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts())) ? DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts()).getName() : "";
            e.setDrwgrpStsCn(drwgrpStsCn);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrawdistributeInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcDrawdistributeInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeInfoVO>> refDcDrawdistributeInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrawdistributeInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/printDataDispose"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> printDataDispose(@RequestBody List<Long> drwgrpIds) {
        try {
            this.service.printDataDispose(drwgrpIds);
        }
        catch (RuntimeException e) {
            this.logger.error("\u56fe\u7eb8\u7b7e\u53d1-\u6253\u5370\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:", (Throwable)e);
            return CommonResponse.error((String)e.getMessage());
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/addBook/{bookId}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DcDrawdistributeInfoEntity>> addBook(@RequestBody List<Long> ids, @PathVariable Long bookId) {
        List dcDrawdistributeInfoEntities = new ArrayList();
        try {
            DcLssueAddressBookEntity dcLssueAddressBookEntity = (DcLssueAddressBookEntity)((Object)this.dcLssueAddressBookService.selectById(bookId));
            DcLssueAddressBookVO bookVO = (DcLssueAddressBookVO)((Object)BeanMapper.map((Object)((Object)dcLssueAddressBookEntity), DcLssueAddressBookVO.class));
            List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList = bookVO.getDcLssueAddressBookDetailList();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            dcDrawdistributeInfoEntities = this.service.queryList(queryParam);
            for (DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity : dcDrawdistributeInfoEntities) {
                List dcDrawdistributeDrwgrpinfoEntityList = this.dcDrawdistributeDrwgrpinfoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getPid, (Object)dcDrawdistributeInfoEntity.getId())).eq(BaseEntity::getDr, (Object)0));
                for (DcLssueAddressBookDetailVO dcLssueAddressBookDetailVO : dcLssueAddressBookDetailList) {
                    boolean exist = dcDrawdistributeDrwgrpinfoEntityList.stream().anyMatch(item -> item.getReceiveUserId().equals(dcLssueAddressBookDetailVO.getReceiveUserId()));
                    if (exist) continue;
                    DcDrawdistributeDrwgrpinfoEntity entity = new DcDrawdistributeDrwgrpinfoEntity();
                    entity.setReceiveDeptName(dcLssueAddressBookDetailVO.getReceiveDeptName());
                    entity.setReceiveUserCode(dcLssueAddressBookDetailVO.getReceiveUserCode());
                    entity.setReceiveUserId(dcLssueAddressBookDetailVO.getReceiveUserId());
                    entity.setReceiveUserName(dcLssueAddressBookDetailVO.getReceiveUserName());
                    entity.setNum(dcLssueAddressBookDetailVO.getNum());
                    entity.setRecycleSts("N");
                    entity.setPid(dcDrawdistributeInfoEntity.getId());
                    entity.setDrwgrpId(dcDrawdistributeInfoEntity.getDrwgrpId());
                    entity.setOrgId(dcDrawdistributeInfoEntity.getOrgId());
                    entity.setOrgCode(dcDrawdistributeInfoEntity.getOrgCode());
                    entity.setOrgName(dcDrawdistributeInfoEntity.getOrgName());
                    entity.setParentOrgId(dcDrawdistributeInfoEntity.getParentOrgId());
                    entity.setParentOrgCode(dcDrawdistributeInfoEntity.getParentOrgCode());
                    entity.setParentOrgName(dcDrawdistributeInfoEntity.getParentOrgName());
                    entity.setProjectId(dcDrawdistributeInfoEntity.getProjectId());
                    entity.setProjectCode(dcDrawdistributeInfoEntity.getProjectCode());
                    entity.setProjectName(dcDrawdistributeInfoEntity.getProjectName());
                    entity.setDrwgrpCode(dcDrawdistributeInfoEntity.getDrwgrpCode());
                    entity.setDrwgrpName(dcDrawdistributeInfoEntity.getDrwgrpName());
                    entity.setDrwgrpVsn(dcDrawdistributeInfoEntity.getDrwgrpVsn());
                    entity.setDrwgrpType(dcDrawdistributeInfoEntity.getDrwgrpType());
                    entity.setMgrp(dcDrawdistributeInfoEntity.getMgrp());
                    entity.setSpecialty(dcDrawdistributeInfoEntity.getSpecialty());
                    this.dcDrawdistributeDrwgrpinfoService.save((Object)entity);
                }
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)e.getMessage());
        }
        return CommonResponse.success(dcDrawdistributeInfoEntities);
    }

    @RequestMapping(value={"/addReceiveUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DcDrawdistributeInfoEntity>> addBook(@RequestBody JSONObject param) {
        JSONArray jsonArray = param.getJSONArray("idList");
        if (jsonArray == null || jsonArray.size() == 0) {
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
        }
        List dcDrawdistributeInfoEntities = new ArrayList();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", (Object)jsonArray));
        dcDrawdistributeInfoEntities = this.service.queryList(queryParam);
        JSONArray userList = param.getJSONArray("userList");
        if (userList == null || userList.size() == 0) {
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u4eba\u5458\u4fe1\u606f");
        }
        for (DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity : dcDrawdistributeInfoEntities) {
            List dcDrawdistributeDrwgrpinfoEntityList = this.dcDrawdistributeDrwgrpinfoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getPid, (Object)dcDrawdistributeInfoEntity.getId())).eq(BaseEntity::getDr, (Object)0));
            for (int i = 0; i < userList.size(); ++i) {
                JSONObject user = userList.getJSONObject(i);
                boolean exist = dcDrawdistributeDrwgrpinfoEntityList.stream().anyMatch(item -> item.getReceiveUserId().equals(user.getLong("id")));
                if (exist) continue;
                DcDrawdistributeDrwgrpinfoEntity entity = new DcDrawdistributeDrwgrpinfoEntity();
                entity.setReceiveDeptName(user.getString("deptName"));
                entity.setReceiveUserCode(user.getString("code"));
                entity.setReceiveUserId(user.getLong("id"));
                entity.setReceiveUserName(user.getString("name"));
                entity.setNum(user.getInteger("num"));
                entity.setRecycleSts("N");
                entity.setPid(dcDrawdistributeInfoEntity.getId());
                entity.setDrwgrpId(dcDrawdistributeInfoEntity.getDrwgrpId());
                entity.setOrgId(dcDrawdistributeInfoEntity.getOrgId());
                entity.setOrgCode(dcDrawdistributeInfoEntity.getOrgCode());
                entity.setOrgName(dcDrawdistributeInfoEntity.getOrgName());
                entity.setParentOrgId(dcDrawdistributeInfoEntity.getParentOrgId());
                entity.setParentOrgCode(dcDrawdistributeInfoEntity.getParentOrgCode());
                entity.setParentOrgName(dcDrawdistributeInfoEntity.getParentOrgName());
                entity.setProjectId(dcDrawdistributeInfoEntity.getProjectId());
                entity.setProjectCode(dcDrawdistributeInfoEntity.getProjectCode());
                entity.setProjectName(dcDrawdistributeInfoEntity.getProjectName());
                entity.setDrwgrpCode(dcDrawdistributeInfoEntity.getDrwgrpCode());
                entity.setDrwgrpName(dcDrawdistributeInfoEntity.getDrwgrpName());
                entity.setDrwgrpVsn(dcDrawdistributeInfoEntity.getDrwgrpVsn());
                entity.setDrwgrpType(dcDrawdistributeInfoEntity.getDrwgrpType());
                entity.setMgrp(dcDrawdistributeInfoEntity.getMgrp());
                entity.setSpecialty(dcDrawdistributeInfoEntity.getSpecialty());
                this.dcDrawdistributeDrwgrpinfoService.save((Object)entity);
            }
        }
        return CommonResponse.success(dcDrawdistributeInfoEntities);
    }
}

