/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrawinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeRecordEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.enumUtils.DrawTypeEnum;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.mapper.DcDrawingApplyForMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrawinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeRecordVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoVO;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.business.settle.api.ISettlementCenterDcDrwgrpInfoApi;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dcDrwgrpInfo"})
public class DcDrwgrpInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDcDrwgrpInfoService service;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DcDrawingApplyForMapper dcDrawingApplyForMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoApi settlementCenterDcDrwgrpInfoApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> saveOrUpdate(@RequestBody DcDrwgrpInfoVO saveOrUpdateVO) {
        String opType = "";
        DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DcDrwgrpInfoEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ToolUtil.isNotEmpty(entity.getProjectId()), DcDrwgrpInfoEntity::getProjectId, (Object)entity.getProjectId())).eq(BaseEntity::getDr, (Object)0)).eq(DcDrwgrpInfoEntity::getDrwgrpCode, (Object)entity.getDrwgrpCode())).eq(DcDrwgrpInfoEntity::getDrwgrpVsn, (Object)entity.getDrwgrpVsn());
        List list = this.service.list((Wrapper)queryWrapper);
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setDrwgrpSts(DrwgrpStsEnum.N.getCode());
            entity.setIssueSts(IssueStsEnum.ISSUE.getCode());
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
            opType = "add";
            if (list.size() > 0) {
                throw new BusinessException("\u8be5\u5377\u518c\u5df2\u6dfb\u52a0");
            }
        } else {
            opType = "edit";
            if (list.size() > 1) {
                throw new BusinessException("\u8be5\u5377\u518c\u5df2\u6dfb\u52a0");
            }
        }
        List<DcDrawInfoVO> dcDrawInfoEntityList = saveOrUpdateVO.getDcDrawInfoEntityList();
        List entityList = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
        entityList.stream().collect(Collectors.groupingBy(e -> e.getDrawCode() + "--" + e.getDrawVsn(), Collectors.toList())).forEach((key, value) -> {
            if (value.size() > 1) {
                throw new BusinessException("\u56fe\u7eb8\u6dfb\u52a0\u91cd\u590d\uff01");
            }
        });
        if (entityList.size() > 0) {
            for (DcDrawInfoEntity dcDrawInfoEntity : entityList) {
                dcDrawInfoEntity.setDrwgrpId(entity.getId());
                dcDrawInfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawInfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawInfoEntity.setOrgId(entity.getOrgId());
                dcDrawInfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawInfoEntity.setOrgName(entity.getOrgName());
                dcDrawInfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawInfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawInfoEntity.setParentOrgName(entity.getParentOrgName());
                dcDrawInfoEntity.setProjectId(entity.getProjectId());
                dcDrawInfoEntity.setProjectCode(entity.getProjectCode());
                dcDrawInfoEntity.setProjectName(entity.getProjectName());
                if (dcDrawInfoEntity.getId() == null || dcDrawInfoEntity.getId() == 0L) {
                    dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
                    if (ToolUtil.isEmpty(dcDrawInfoEntity.getPrintStatus())) {
                        dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                    }
                    if (ToolUtil.isEmpty(dcDrawInfoEntity.getCheckState())) {
                        dcDrawInfoEntity.setCheckState("N");
                    }
                }
                if (!"edit".equals(opType)) continue;
                QueryWrapper dcDrawInfoEntityQueryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)dcDrawInfoEntityQueryWrapper.lambda().eq(ToolUtil.isNotEmpty(entity.getProjectId()), DcDrawInfoEntity::getDrwgrpId, (Object)dcDrawInfoEntity.getDrwgrpId())).eq(BaseEntity::getDr, (Object)0)).eq(DcDrawInfoEntity::getDrawCode, (Object)dcDrawInfoEntity.getDrawCode())).eq(DcDrawInfoEntity::getDrawVsn, (Object)dcDrawInfoEntity.getDrawVsn());
                List listSon = this.dcDrawInfoService.list((Wrapper)dcDrawInfoEntityQueryWrapper);
                if (!(dcDrawInfoEntity.getId() == null || dcDrawInfoEntity.getId() == 0L ? listSon.size() > 0 : listSon.size() > 1)) continue;
                throw new BusinessException("\u3010" + dcDrawInfoEntity.getDrawCode() + "\u3011\u56fe\u7eb8\u5df2\u6dfb\u52a0");
            }
            this.dcDrawInfoService.saveOrUpdateBatch(entityList, entityList.size(), false);
        }
        entity.setDcDrawInfoEntityList(entityList);
        this.service.saveOrUpdate((Object)entity, false);
        DcDrwgrpInfoVO vo = (DcDrwgrpInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @PostMapping(value={"/upgrade"})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> upgrade(@RequestBody DcDrwgrpInfoVO f) {
        DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)((Object)f), DcDrwgrpInfoEntity.class));
        List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
        List dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
        entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
        this.service.upgrade(entity);
        return CommonResponse.success((String)"\u5347\u7248\u5355\u636e\u6210\u529f\uff01");
    }

    @PostMapping(value={"/addAttachment"})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoEntity> addAttachment(@RequestBody DcDrwgrpInfoVO f) {
        DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)((Object)f), DcDrwgrpInfoEntity.class));
        List dcDrawdistributeInfoEntityList = this.dcDrawdistributeInfoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeInfoEntity::getDrwgrpId, (Object)entity.getId())).eq(BaseEntity::getDr, (Object)0));
        for (DcDrawdistributeInfoEntity infoEntity : dcDrawdistributeInfoEntityList) {
            this.dcDrawdistributeDrawinfoService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeDrawinfoEntity::getPid, (Object)infoEntity.getId())).eq(BaseEntity::getDr, (Object)0));
            this.dcDrawdistributeDrwgrpinfoService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getPid, (Object)infoEntity.getId())).eq(BaseEntity::getDr, (Object)0));
        }
        this.dcDrawdistributeInfoService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawdistributeInfoEntity::getDrwgrpId, (Object)entity.getId())).eq(BaseEntity::getDr, (Object)0));
        entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
        entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
        for (DcDrawInfoEntity dcDrawInfoEntity : entity.getDcDrawInfoEntityList()) {
            dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
            dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            dcDrawInfoEntity.setCheckState("N");
        }
        this.service.updateById((Object)entity);
        return CommonResponse.success((String)"\u6dfb\u52a0\u56fe\u7eb8\u9644\u4ef6\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @PostMapping(value={"/annul"})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> annul(@RequestBody List<DcDrwgrpInfoVO> fList) {
        ArrayList<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityList = new ArrayList<DcDrwgrpInfoEntity>();
        fList.stream().forEach(f -> {
            DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)((Object)BeanMapper.map((Object)f, DcDrwgrpInfoEntity.class)));
            List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
            List dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
            entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
            dcDrwgrpInfoEntityList.add(entity);
        });
        this.service.annul(dcDrwgrpInfoEntityList);
        return CommonResponse.success((String)"\u4f5c\u5e9f\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> queryDetail(Long id) {
        DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)this.service.selectById(id));
        DcDrwgrpInfoVO vo = (DcDrwgrpInfoVO)((Object)BeanMapper.map((Object)((Object)entity), DcDrwgrpInfoVO.class));
        List dcDrawdistributeRecordEntityList = this.dcDrawdistributeRecordService.list((Wrapper)new QueryWrapper().lambda().eq(DcDrawdistributeRecordEntity::getDrwgrpId, (Object)vo.getId()));
        List dcDrawdistributeRecordVOList = BeanMapper.mapList((Iterable)dcDrawdistributeRecordEntityList, DcDrawdistributeRecordVO.class);
        vo.setDcDrawdistributeRecordList(dcDrawdistributeRecordVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrwgrpInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcDrwgrpInfoVO dcDrwgrpInfoVO : vos) {
            }
        }
        List idList = vos.stream().map(DcDrwgrpInfoVO::getId).collect(Collectors.toList());
        this.service.removeByIds(idList, true);
        List list = this.dcDrawInfoService.list((Wrapper)new QueryWrapper().lambda().in(DcDrawInfoEntity::getDrwgrpId, idList));
        if (list.size() > 0) {
            this.dcDrawInfoService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        this.settlementCenterDcDrwgrpInfoApi.deleteForDrwgrp(idList);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public static List<String> findUniqueCodes(List<String> list1, List<String> list2) {
        for (String code : list2) {
            if (list1.contains(code)) continue;
            list1.add(code);
        }
        return list1;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("drwgrpCode");
        param.getFuzzyFields().add("drwgrpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage<DcDrwgrpInfoEntity> page = new IPage<DcDrwgrpInfoEntity>();
        if (param.getSearchText() != null && param.getSearchText() != "") {
            List dcDrwgrpInfoEntities = this.service.queryList(param);
            QueryParam queryParam = (QueryParam)Utils.deepCopy((Object)param);
            queryParam.getFuzzyFields().clear();
            queryParam.getFuzzyFields().add("draw_code");
            List dcDrawInfoEntities = this.dcDrawInfoService.queryList(queryParam);
            List<String> codes1 = dcDrwgrpInfoEntities.stream().map(dc -> Long.toString(dc.getId())).collect(Collectors.toList());
            List<String> codes2 = dcDrawInfoEntities.stream().map(dc -> Long.toString(dc.getDrwgrpId())).collect(Collectors.toList());
            List<String> uniqueCodes = DcDrwgrpInfoController.findUniqueCodes(codes1, codes2);
            if (uniqueCodes != null && uniqueCodes.size() > 0) {
                page = this.service.queryPage(uniqueCodes, param);
            }
        } else {
            page = this.service.queryPage(param, false);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrwgrpInfoVO.class));
        pageData.getRecords().stream().forEach(e -> {
            e.setDrwgrpStsCn(DrwgrpStsEnum.getEnumByCode(e.getDrwgrpSts()).getName());
            e.setIssueStsCn(IssueStsEnum.getEnumByCode(e.getIssueSts()).getName());
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("createTime");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, DcDrwgrpInfoVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setDrwgrpStsCn(DrwgrpStsEnum.getEnumByCode(vo.getDrwgrpSts()).getName());
                vo.setIssueStsCn(IssueStsEnum.getEnumByCode(vo.getIssueSts()).getName());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("drwgrpInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDcDrwgrpInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> refDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        String sts = "";
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (StringUtils.isNotBlank((CharSequence)_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.parseLong(_con.getString("projectId"))));
            }
            param.getParams().put("drwgrpSts", new Parameter("eq", (Object)_con.getString("drwgrpSts")));
            if (IssueStsEnum.NOT_ISSUE.getCode().equals(_con.getString("issueSts"))) {
                sts = _con.getString("issueSts");
                param.getParams().put("issueSts", new Parameter("eq", (Object)_con.getString("issueSts")));
            }
            if (IssueStsEnum.ISSUE.getCode().equals(_con.getString("issueSts"))) {
                sts = _con.getString("issueSts");
                List dcDrawInfoEntityList = this.dcDrawInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().select(new String[]{"DISTINCT drwgrp_id"}).lambda().eq(StringUtils.isNotBlank((CharSequence)_con.getString("projectId")), DcDrawInfoEntity::getProjectId, (Object)_con.getString("projectId"))).eq(DcDrawInfoEntity::getIssueSts, (Object)_con.getString("issueSts"))).eq(BaseEntity::getDr, (Object)0));
                param.getParams().put("id", new Parameter("in", dcDrawInfoEntityList.stream().map(DcDrawInfoEntity::getDrwgrpId).filter(Objects::nonNull).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DcDrwgrpInfoVO.class));
        if (StringUtils.isNotBlank((CharSequence)sts)) {
            String finalSts = sts;
            pageData.getRecords().forEach(dcDrwgrpInfoVO -> {
                List dcDrawInfoEntityList = this.dcDrawInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawInfoEntity::getDrwgrpId, (Object)dcDrwgrpInfoVO.getId())).eq(DcDrawInfoEntity::getIssueSts, (Object)finalSts)).eq(BaseEntity::getDr, (Object)0));
                dcDrwgrpInfoVO.setDcDrawInfoEntityList(BeanMapper.mapList((Iterable)dcDrawInfoEntityList, DcDrawInfoVO.class));
                if (IssueStsEnum.ISSUE.getCode().equals(finalSts)) {
                    List dcDrawdistributeRecordEntityList = this.dcDrawdistributeRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(DcDrawdistributeRecordEntity.class, dcDrawdistributeRecordEntity -> !dcDrawdistributeRecordEntity.getColumn().equals("id")).eq(DcDrawdistributeRecordEntity::getDrwgrpId, (Object)dcDrwgrpInfoVO.getId())).eq(DcDrawdistributeRecordEntity::getRecycleSts, (Object)RecycleEnum.N.getCode())).eq(BaseEntity::getDr, (Object)0));
                    dcDrwgrpInfoVO.setDcDrawdistributeRecordList(BeanMapper.mapList((Iterable)dcDrawdistributeRecordEntityList, DcDrawdistributeRecordVO.class));
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/drawingIssuanceSave", "/drawingIssuanceSave/{leaderShip}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BatchSubmitVO.BatchSubmitDetailVO>> drawingIssuanceSave(@RequestBody List<Long> ids, @PathVariable(value="leaderShip", required=false) String leaderShip) {
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> drawdistributeIds = this.service.drawingIssuanceSave(ids, leaderShip);
            return CommonResponse.success((String)"\u56fe\u7eb8\u7b7e\u53d1\u6210\u529f\uff01", drawdistributeIds);
        }
        catch (RuntimeException e) {
            this.logger.error("\u56fe\u7eb8\u7b7e\u53d1\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return CommonResponse.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/getDrwgrpInfoAndSublist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DcDrwgrpInfoVO>> getDrwgrpInfoAndSublist(@RequestBody List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("id", new Parameter("in", ids));
        List dcDrwgrpInfoEntityList = this.service.queryList(param);
        dcDrwgrpInfoEntityList.forEach(item -> {
            QueryParam dcDrawInfoParam = new QueryParam();
            dcDrawInfoParam.getParams().put("dr", new Parameter("eq", (Object)0));
            dcDrawInfoParam.getParams().put("drwgrpId", new Parameter("eq", (Object)item.getId()));
            List dcDrawInfoEntityList = this.dcDrawInfoService.queryList(dcDrawInfoParam);
            item.setDcDrawInfoEntityList(dcDrawInfoEntityList);
        });
        List dcDrwgrpInfoVOList = BeanMapper.mapList((Iterable)dcDrwgrpInfoEntityList, DcDrwgrpInfoVO.class);
        return CommonResponse.success((Object)dcDrwgrpInfoVOList);
    }

    @PostMapping(value={"/saveDrawInfo/{drwgrpId}"})
    @ResponseBody
    public CommonResponse<Void> saveDrawInfo(@PathVariable Long drwgrpId, @RequestBody List<DcDrawInfoVO> dcDrawInfoList) {
        try {
            this.service.saveDrawInfo(drwgrpId, dcDrawInfoList);
            return CommonResponse.success();
        }
        catch (RuntimeException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u6dfb\u52a0\u56fe\u7eb8\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            return CommonResponse.error((String)"\u6dfb\u52a0\u56fe\u7eb8\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/refDrwgrpInfoTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refDrwgrpInfoTree(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) Long pid) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return Lists.newArrayList();
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("drwgrpSts", new Parameter("eq", (Object)DrwgrpStsEnum.Y.getCode()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotBlank((CharSequence)(_con = JSONObject.parseObject((String)condition)).getString("projectId"))) {
            param.getParams().put("projectId", new Parameter("eq", (Object)Long.parseLong(_con.getString("projectId"))));
        }
        List dataList = this.service.queryList(param);
        ArrayList dataMapList = Lists.newArrayList();
        for (DcDrwgrpInfoEntity data : dataList) {
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("id", data.getId());
            dataMap.put("name", data.getDrwgrpCode());
            dataMapList.add(dataMap);
        }
        return ResultAsTree.createTreeData((List)dataMapList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/makePrintDataForNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> makePrintDataForNum(String projectId) {
        List list = null;
        list = ToolUtil.isEmpty(projectId) ? this.service.list((Wrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)) : this.service.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcDrwgrpInfoEntity::getProjectId, (Object)projectId));
        Long drawTypeId = null;
        CommonResponse drawType = this.defdocApi.queryDetailListByDefdocCode("draw_type", null);
        if (!drawType.isSuccess()) return CommonResponse.error((String)"\u672a\u627e\u5230\u81ea\u5b9a\u4e49\u6863\u6848");
        if (((List)drawType.getData()).size() <= 0) return CommonResponse.error((String)"\u672a\u627e\u5230\u81ea\u5b9a\u4e49\u6863\u6848");
        for (Map map : (List)drawType.getData()) {
            if (!"\u76ee\u5f55".equals(map.get("description"))) continue;
            drawTypeId = Long.valueOf(map.get("id").toString());
        }
        if (drawTypeId == null) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u81ea\u5b9a\u4e49\u6863\u6848-\u76ee\u5f55");
        }
        for (DcDrwgrpInfoEntity dcDrwgrpInfoEntity : list) {
            List dcDrawInfoEntityList = this.dcDrawInfoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(DcDrawInfoEntity::getDrwgrpId, (Object)dcDrwgrpInfoEntity.getId())).eq(BaseEntity::getDr, (Object)0));
            boolean flag = dcDrawInfoEntityList.stream().anyMatch(a -> {
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(a.getDrawType() + ""), (String)"support-defdoc");
                    return DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"code"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            });
            if (flag) continue;
            DcDrawInfoEntity dcDrawInfoEntity = new DcDrawInfoEntity();
            dcDrawInfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
            dcDrawInfoEntity.setDrawCode(dcDrwgrpInfoEntity.getDrwgrpCode() + "-1");
            dcDrawInfoEntity.setDrawName(dcDrwgrpInfoEntity.getDrwgrpName());
            dcDrawInfoEntity.setDrawType(drawTypeId);
            dcDrawInfoEntity.setDrawVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
            dcDrawInfoEntity.setPaperFlag("Y");
            dcDrawInfoEntity.setDrwgrpId(dcDrwgrpInfoEntity.getId());
            dcDrawInfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
            dcDrawInfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
            dcDrawInfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            dcDrawInfoEntity.setCheckState("N");
            dcDrawInfoEntity.setIssueSts(IssueStsEnum.ISSUE.getCode());
            boolean b = this.dcDrawInfoService.save((Object)dcDrawInfoEntity);
            if (!b) continue;
            List dcDrawdistributeInfoEntityList = this.dcDrawdistributeInfoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcDrawdistributeInfoEntity::getDrwgrpId, (Object)dcDrwgrpInfoEntity.getId()));
            for (DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity : dcDrawdistributeInfoEntityList) {
                DcDrawdistributeDrawinfoEntity dcDrawdistributeDrawinfoEntity = new DcDrawdistributeDrawinfoEntity();
                dcDrawdistributeDrawinfoEntity.setPid(dcDrawdistributeInfoEntity.getId());
                dcDrawdistributeDrawinfoEntity.setDrawId(dcDrawInfoEntity.getId());
                dcDrawdistributeDrawinfoEntity.setDrwgrpId(dcDrwgrpInfoEntity.getId());
                dcDrawdistributeDrawinfoEntity.setDrawCode(dcDrwgrpInfoEntity.getDrwgrpCode() + "-1");
                dcDrawdistributeDrawinfoEntity.setDrawName(dcDrwgrpInfoEntity.getDrwgrpName());
                dcDrawdistributeDrawinfoEntity.setDrawVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                dcDrawdistributeDrawinfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
                dcDrawdistributeDrawinfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                dcDrawdistributeDrawinfoEntity.setDrawType(drawTypeId);
                dcDrawdistributeDrawinfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
                dcDrawdistributeDrawinfoEntity.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                dcDrawdistributeDrawinfoEntity.setPaperFlag("Y");
                boolean c = this.dcDrawdistributeDrawinfoService.save((Object)dcDrawdistributeDrawinfoEntity);
                if (!c) continue;
                this.dcDrawdistributeInfoService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DcDrawdistributeInfoEntity::getId, (Object)dcDrawdistributeInfoEntity.getId())).set(DcDrawdistributeInfoEntity::getDistCode, (Object)""));
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"pushSettlementCenterDcDrwgrpInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse pushSettlementCenterDcDrwgrpInfo(@RequestBody QueryParam param) {
        List list = this.service.queryList(param);
        for (DcDrwgrpInfoEntity dcDrwgrpInfoEntity : list) {
            SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO = new SettlementCenterDcDrwgrpInfoVO();
            settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoId(dcDrwgrpInfoEntity.getId());
            settlementCenterDcDrwgrpInfoVO.setFirstNodeTime(new Date());
            settlementCenterDcDrwgrpInfoVO.setOrgId(dcDrwgrpInfoEntity.getOrgId());
            settlementCenterDcDrwgrpInfoVO.setOrgCode(dcDrwgrpInfoEntity.getOrgCode());
            settlementCenterDcDrwgrpInfoVO.setOrgName(dcDrwgrpInfoEntity.getOrgName());
            settlementCenterDcDrwgrpInfoVO.setParentOrgId(dcDrwgrpInfoEntity.getParentOrgId());
            settlementCenterDcDrwgrpInfoVO.setParentOrgCode(dcDrwgrpInfoEntity.getParentOrgCode());
            settlementCenterDcDrwgrpInfoVO.setParentOrgName(dcDrwgrpInfoEntity.getParentOrgName());
            settlementCenterDcDrwgrpInfoVO.setProjectId(dcDrwgrpInfoEntity.getProjectId());
            settlementCenterDcDrwgrpInfoVO.setProjectCode(dcDrwgrpInfoEntity.getProjectCode());
            settlementCenterDcDrwgrpInfoVO.setProjectName(dcDrwgrpInfoEntity.getProjectName());
            settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoCode(dcDrwgrpInfoEntity.getDrwgrpCode());
            settlementCenterDcDrwgrpInfoVO.setFlowState(SettleFlowStateEnum.ONE.getCode());
            settlementCenterDcDrwgrpInfoVO.setFlowStateName(SettleFlowStateEnum.ONE.getName());
            settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoName(dcDrwgrpInfoEntity.getDrwgrpName());
            settlementCenterDcDrwgrpInfoVO.setWhetherUpgrade(Integer.valueOf(0));
            settlementCenterDcDrwgrpInfoVO.setTenantId(InvocationInfoProxy.getTenantid());
            this.settlementCenterDcDrwgrpInfoApi.saveOrUpdateSettlementCenterDcDrwgrpInfo(settlementCenterDcDrwgrpInfoVO);
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f");
    }
}

